package de.flapdoodle.testdoc;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Line}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLine.builder()}.
 */
@Generated(from = "Line", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableLine implements Line {
  private final String className;
  private final String fileName;
  private final String methodName;
  private final int lineNumber;

  private ImmutableLine(String className, String fileName, String methodName, int lineNumber) {
    this.className = className;
    this.fileName = fileName;
    this.methodName = methodName;
    this.lineNumber = lineNumber;
  }

  /**
   * @return The value of the {@code className} attribute
   */
  @Override
  public String className() {
    return className;
  }

  /**
   * @return The value of the {@code fileName} attribute
   */
  @Override
  public String fileName() {
    return fileName;
  }

  /**
   * @return The value of the {@code methodName} attribute
   */
  @Override
  public String methodName() {
    return methodName;
  }

  /**
   * @return The value of the {@code lineNumber} attribute
   */
  @Override
  public int lineNumber() {
    return lineNumber;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Line#className() className} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for className
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLine withClassName(String value) {
    String newValue = Objects.requireNonNull(value, "className");
    if (this.className.equals(newValue)) return this;
    return validate(new ImmutableLine(newValue, this.fileName, this.methodName, this.lineNumber));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Line#fileName() fileName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for fileName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLine withFileName(String value) {
    String newValue = Objects.requireNonNull(value, "fileName");
    if (this.fileName.equals(newValue)) return this;
    return validate(new ImmutableLine(this.className, newValue, this.methodName, this.lineNumber));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Line#methodName() methodName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for methodName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLine withMethodName(String value) {
    String newValue = Objects.requireNonNull(value, "methodName");
    if (this.methodName.equals(newValue)) return this;
    return validate(new ImmutableLine(this.className, this.fileName, newValue, this.lineNumber));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Line#lineNumber() lineNumber} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for lineNumber
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLine withLineNumber(int value) {
    if (this.lineNumber == value) return this;
    return validate(new ImmutableLine(this.className, this.fileName, this.methodName, value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLine} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLine
        && equalTo((ImmutableLine) another);
  }

  private boolean equalTo(ImmutableLine another) {
    return className.equals(another.className)
        && fileName.equals(another.fileName)
        && methodName.equals(another.methodName)
        && lineNumber == another.lineNumber;
  }

  /**
   * Computes a hash code from attributes: {@code className}, {@code fileName}, {@code methodName}, {@code lineNumber}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + className.hashCode();
    h += (h << 5) + fileName.hashCode();
    h += (h << 5) + methodName.hashCode();
    h += (h << 5) + lineNumber;
    return h;
  }

  /**
   * Prints the immutable value {@code Line} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Line{"
        + "className=" + className
        + ", fileName=" + fileName
        + ", methodName=" + methodName
        + ", lineNumber=" + lineNumber
        + "}";
  }

  private static ImmutableLine validate(ImmutableLine instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link Line} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Line instance
   */
  public static ImmutableLine copyOf(Line instance) {
    if (instance instanceof ImmutableLine) {
      return (ImmutableLine) instance;
    }
    return ImmutableLine.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLine ImmutableLine}.
   * <pre>
   * ImmutableLine.builder()
   *    .className(String) // required {@link Line#className() className}
   *    .fileName(String) // required {@link Line#fileName() fileName}
   *    .methodName(String) // required {@link Line#methodName() methodName}
   *    .lineNumber(int) // required {@link Line#lineNumber() lineNumber}
   *    .build();
   * </pre>
   * @return A new ImmutableLine builder
   */
  public static ImmutableLine.Builder builder() {
    return new ImmutableLine.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableLine ImmutableLine}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Line", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CLASS_NAME = 0x1L;
    private static final long INIT_BIT_FILE_NAME = 0x2L;
    private static final long INIT_BIT_METHOD_NAME = 0x4L;
    private static final long INIT_BIT_LINE_NUMBER = 0x8L;
    private long initBits = 0xfL;

    private String className;
    private String fileName;
    private String methodName;
    private int lineNumber;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Line} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Line instance) {
      Objects.requireNonNull(instance, "instance");
      className(instance.className());
      fileName(instance.fileName());
      methodName(instance.methodName());
      lineNumber(instance.lineNumber());
      return this;
    }

    /**
     * Initializes the value for the {@link Line#className() className} attribute.
     * @param className The value for className 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder className(String className) {
      this.className = Objects.requireNonNull(className, "className");
      initBits &= ~INIT_BIT_CLASS_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Line#fileName() fileName} attribute.
     * @param fileName The value for fileName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder fileName(String fileName) {
      this.fileName = Objects.requireNonNull(fileName, "fileName");
      initBits &= ~INIT_BIT_FILE_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Line#methodName() methodName} attribute.
     * @param methodName The value for methodName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder methodName(String methodName) {
      this.methodName = Objects.requireNonNull(methodName, "methodName");
      initBits &= ~INIT_BIT_METHOD_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Line#lineNumber() lineNumber} attribute.
     * @param lineNumber The value for lineNumber 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder lineNumber(int lineNumber) {
      this.lineNumber = lineNumber;
      initBits &= ~INIT_BIT_LINE_NUMBER;
      return this;
    }

    /**
     * Builds a new {@link ImmutableLine ImmutableLine}.
     * @return An immutable instance of Line
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLine build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return ImmutableLine.validate(new ImmutableLine(className, fileName, methodName, lineNumber));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CLASS_NAME) != 0) attributes.add("className");
      if ((initBits & INIT_BIT_FILE_NAME) != 0) attributes.add("fileName");
      if ((initBits & INIT_BIT_METHOD_NAME) != 0) attributes.add("methodName");
      if ((initBits & INIT_BIT_LINE_NUMBER) != 0) attributes.add("lineNumber");
      return "Cannot build Line, some of required attributes are not set " + attributes;
    }
  }
}
