package de.flapdoodle.testdoc;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CalledMethod}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCalledMethod.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableCalledMethod.of()}.
 */
@Generated(from = "CalledMethod", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableCalledMethod implements CalledMethod {
  private final Line line;

  private ImmutableCalledMethod(Line line) {
    this.line = Objects.requireNonNull(line, "line");
  }

  private ImmutableCalledMethod(ImmutableCalledMethod original, Line line) {
    this.line = line;
  }

  /**
   * @return The value of the {@code line} attribute
   */
  @Override
  public Line line() {
    return line;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CalledMethod#line() line} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for line
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCalledMethod withLine(Line value) {
    if (this.line == value) return this;
    Line newValue = Objects.requireNonNull(value, "line");
    return new ImmutableCalledMethod(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCalledMethod} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCalledMethod
        && equalTo((ImmutableCalledMethod) another);
  }

  private boolean equalTo(ImmutableCalledMethod another) {
    return line.equals(another.line);
  }

  /**
   * Computes a hash code from attributes: {@code line}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + line.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CalledMethod} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CalledMethod{"
        + "line=" + line
        + "}";
  }

  /**
   * Construct a new immutable {@code CalledMethod} instance.
   * @param line The value for the {@code line} attribute
   * @return An immutable CalledMethod instance
   */
  public static ImmutableCalledMethod of(Line line) {
    return new ImmutableCalledMethod(line);
  }

  /**
   * Creates an immutable copy of a {@link CalledMethod} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CalledMethod instance
   */
  public static ImmutableCalledMethod copyOf(CalledMethod instance) {
    if (instance instanceof ImmutableCalledMethod) {
      return (ImmutableCalledMethod) instance;
    }
    return ImmutableCalledMethod.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCalledMethod ImmutableCalledMethod}.
   * <pre>
   * ImmutableCalledMethod.builder()
   *    .line(de.flapdoodle.testdoc.Line) // required {@link CalledMethod#line() line}
   *    .build();
   * </pre>
   * @return A new ImmutableCalledMethod builder
   */
  public static ImmutableCalledMethod.Builder builder() {
    return new ImmutableCalledMethod.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCalledMethod ImmutableCalledMethod}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CalledMethod", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_LINE = 0x1L;
    private long initBits = 0x1L;

    private Line line;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.testdoc.HasLine} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HasLine instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.testdoc.CalledMethod} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CalledMethod instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof HasLine) {
        HasLine instance = (HasLine) object;
        if ((bits & 0x1L) == 0) {
          line(instance.line());
          bits |= 0x1L;
        }
      }
      if (object instanceof CalledMethod) {
        CalledMethod instance = (CalledMethod) object;
        if ((bits & 0x1L) == 0) {
          line(instance.line());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link CalledMethod#line() line} attribute.
     * @param line The value for line 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder line(Line line) {
      this.line = Objects.requireNonNull(line, "line");
      initBits &= ~INIT_BIT_LINE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCalledMethod ImmutableCalledMethod}.
     * @return An immutable instance of CalledMethod
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCalledMethod build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCalledMethod(null, line);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_LINE) != 0) attributes.add("line");
      return "Cannot build CalledMethod, some of required attributes are not set " + attributes;
    }
  }
}
