/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.testdoc;

import de.flapdoodle.testdoc.Line;
import de.flapdoodle.testdoc.Preconditions;
import java.util.Arrays;

public abstract class Stacktraces {
    private Stacktraces() {
    }

    static Line currentLine(Scope scope) {
        return Stacktraces.lineOf(new RuntimeException().getStackTrace(), Stacktraces.offset(scope));
    }

    private static int offset(Scope scope) {
        switch (scope) {
            case Caller: {
                return 1;
            }
            case CallerOfCaller: {
                return 2;
            }
            case CallerOfCallerWithDelegate: {
                return 3;
            }
        }
        throw new IllegalArgumentException("scope not supported: " + (Object)((Object)scope));
    }

    private static Line lineOf(StackTraceElement[] stackTrace, int skipLines) {
        int stackAfterRecorderCall = skipLines;
        Preconditions.checkArgument(stackAfterRecorderCall > 0, "could not find recorder in stackTrace: %s", Arrays.asList(stackTrace));
        Preconditions.checkArgument(stackAfterRecorderCall < stackTrace.length, "found recorder in stackTrace at %s, but nothing left: %s", stackAfterRecorderCall, Arrays.asList(stackTrace));
        return Stacktraces.lineOf(stackTrace[stackAfterRecorderCall]);
    }

    private static Line lineOf(StackTraceElement stack) {
        return Line.builder().className(stack.getClassName()).fileName(stack.getFileName()).methodName(stack.getMethodName()).lineNumber(stack.getLineNumber()).build();
    }

    public static enum Scope {
        Caller,
        CallerOfCaller,
        CallerOfCallerWithDelegate;

    }
}

