/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.testdoc;

import de.flapdoodle.testdoc.Includes;
import de.flapdoodle.testdoc.Preconditions;
import de.flapdoodle.testdoc.TabSize;
import de.flapdoodle.testdoc.TrowingSupplier;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

abstract class Resources {
    private Resources() {
    }

    public static Optional<String> resource(Class<?> clazz, String resourceName) {
        return Optional.ofNullable(clazz.getResourceAsStream(resourceName)).map(is -> Resources.read(() -> is));
    }

    public static Optional<List<String>> sourceCodeOf(Class<?> clazz, TabSize tabSize, Includes ... options) {
        List<Path> codeRoots = Resources.sourceCodeRoots();
        Preconditions.checkArgument(!codeRoots.isEmpty(), "no sourceCodeRoots found");
        for (Path codeRoot : codeRoots) {
            Path resolved = codeRoot.resolve(Resources.asPath(clazz));
            if (!Resources.isFile(resolved)) continue;
            List<String> tabToSpaces = Resources.tabToSpaces(Resources.readLines(() -> new FileInputStream(resolved.toFile())), tabSize.asSpaces());
            return Optional.of(Resources.applyOptions(tabToSpaces, options));
        }
        return Optional.empty();
    }

    private static List<String> applyOptions(List<String> lines, Includes ... options) {
        if (options.length > 0) {
            EnumSet<Includes> optionsAsSet = EnumSet.copyOf(Arrays.asList(options));
            if (optionsAsSet.contains((Object)Includes.WithoutPackage)) {
                lines = Resources.stripPackage(lines);
            }
            if (optionsAsSet.contains((Object)Includes.WithoutImports)) {
                lines = Resources.stripImports(lines);
            }
            if (optionsAsSet.contains((Object)Includes.Trim)) {
                lines = Resources.trimBlock(lines);
            }
        }
        return lines;
    }

    private static List<String> stripImports(List<String> lines) {
        return lines.stream().filter(l -> !l.startsWith("import")).collect(Collectors.toList());
    }

    private static List<String> trimBlock(List<String> lines) {
        int i;
        int firstContentLine = 0;
        int lastContentLine = lines.size();
        for (i = 0; i < lines.size(); ++i) {
            if (lines.get(i).trim().isEmpty()) continue;
            firstContentLine = i;
            break;
        }
        for (i = lines.size() - 1; i > firstContentLine; --i) {
            if (lines.get(i).trim().isEmpty()) continue;
            lastContentLine = i;
            break;
        }
        return lines.subList(firstContentLine, lastContentLine + 1);
    }

    private static List<String> stripPackage(List<String> lines) {
        for (int i = 0; i < lines.size(); ++i) {
            if (!lines.get(i).startsWith("package")) continue;
            return lines.subList(i + 1, lines.size());
        }
        return lines;
    }

    public static List<String> tabToSpaces(List<String> src, String tabSize) {
        return src.stream().map(s -> s.replace("\t", tabSize)).collect(Collectors.toList());
    }

    private static Path asPath(Class<?> clazz) {
        Preconditions.checkArgument(!clazz.isAnonymousClass(), "class %s is anonymous", clazz);
        String packageAsDir = clazz.getPackage().getName().replace('.', File.separatorChar);
        return Paths.get(packageAsDir, new String[0]).resolve(clazz.getSimpleName() + ".java");
    }

    private static List<Path> sourceCodeRoots() {
        Path mayBeMavenRoot = Paths.get("", new String[0]).toAbsolutePath();
        Path testSources = mayBeMavenRoot.resolve(Paths.get("src", "test", "java"));
        Path sources = mayBeMavenRoot.resolve(Paths.get("src", "main", "java"));
        ArrayList<Path> ret = new ArrayList<Path>();
        if (Resources.isDir(testSources)) {
            ret.add(testSources);
        }
        if (Resources.isDir(sources)) {
            ret.add(sources);
        }
        return ret;
    }

    private static boolean isDir(Path resolved) {
        File asFile = resolved.toFile();
        return asFile.isDirectory() && asFile.exists();
    }

    private static boolean isFile(Path resolved) {
        File asFile = resolved.toFile();
        return asFile.isFile() && asFile.exists();
    }

    public static String read(TrowingSupplier<InputStream> input) {
        return Resources.read(input, buffer -> buffer.lines().collect(Collectors.joining("\n")));
    }

    public static String joinedWithNewLine(Collection<String> lines) {
        return lines.stream().collect(Collectors.joining("\n"));
    }

    public static List<String> readLines(TrowingSupplier<InputStream> input) {
        return Resources.read(input, buffer -> buffer.lines().collect(Collectors.toList()));
    }

    /*
     * Exception decompiling
     */
    public static <T> T read(TrowingSupplier<InputStream> input, Function<BufferedReader, T> bufferMapping) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

