/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.testdoc;

import de.flapdoodle.testdoc.Includes;
import de.flapdoodle.testdoc.Line;
import de.flapdoodle.testdoc.Preconditions;
import de.flapdoodle.testdoc.Recording;
import de.flapdoodle.testdoc.Resources;
import de.flapdoodle.testdoc.Stacktraces;
import de.flapdoodle.testdoc.TabSize;

public class Recorder {
    public static Recording with(String template) {
        return Recorder.generateMarkDown(Stacktraces.Scope.CallerOfCallerWithDelegate, template, TabSize.spaces(8));
    }

    public static Recording with(String template, TabSize tabSize) {
        return Recorder.generateMarkDown(Stacktraces.Scope.CallerOfCallerWithDelegate, template, tabSize);
    }

    private static Recording generateMarkDown(Stacktraces.Scope scope, String template, TabSize tabSize) {
        try {
            Line currentLine = Stacktraces.currentLine(scope);
            String testClassName = currentLine.className();
            Class<?> clazz = Class.forName(testClassName);
            return Recorder.with(clazz, template, tabSize);
        }
        catch (ClassNotFoundException | RuntimeException rx) {
            throw new RuntimeException(rx);
        }
    }

    protected static Recording with(Class<?> clazz, String template, TabSize tabSize) {
        return new Recording(template, Recorder.templateOf(clazz, template), Resources.sourceCodeOf(clazz, tabSize, new Includes[0]).get(), tabSize);
    }

    private static String templateOf(Class<?> clazz, String template) {
        return Resources.read(() -> Preconditions.checkNotNull(clazz.getResourceAsStream(template), "could not get %s for %s", template, clazz));
    }
}

