/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.testdoc;

import de.flapdoodle.testdoc.Template;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class ImmutableReplacements
implements Template.Replacements {
    private final Map<String, String> replacement;

    private ImmutableReplacements(Map<String, String> replacement) {
        this.replacement = replacement;
    }

    @Override
    public Map<String, String> replacement() {
        return this.replacement;
    }

    public final ImmutableReplacements withReplacement(Map<String, ? extends String> entries) {
        if (this.replacement == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableReplacements.createUnmodifiableMap(true, false, entries);
        return new ImmutableReplacements(newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReplacements && this.equalTo((ImmutableReplacements)another);
    }

    private boolean equalTo(ImmutableReplacements another) {
        return this.replacement.equals(another.replacement);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.replacement.hashCode();
        return h;
    }

    public String toString() {
        return "Replacements{replacement=" + this.replacement + "}";
    }

    public static ImmutableReplacements copyOf(Template.Replacements instance) {
        if (instance instanceof ImmutableReplacements) {
            return (ImmutableReplacements)instance;
        }
        return ImmutableReplacements.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private Map<String, String> replacement = new LinkedHashMap<String, String>();

        private Builder() {
        }

        public final Builder from(Template.Replacements instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllReplacement(instance.replacement());
            return this;
        }

        public final Builder putReplacement(String key, String value) {
            this.replacement.put(Objects.requireNonNull(key, "replacement key"), Objects.requireNonNull(value, "replacement value"));
            return this;
        }

        public final Builder putReplacement(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.replacement.put(Objects.requireNonNull(k, "replacement key"), Objects.requireNonNull(v, "replacement value"));
            return this;
        }

        public final Builder replacement(Map<String, ? extends String> replacement) {
            this.replacement.clear();
            return this.putAllReplacement(replacement);
        }

        public final Builder putAllReplacement(Map<String, ? extends String> replacement) {
            for (Map.Entry<String, ? extends String> entry : replacement.entrySet()) {
                String k = entry.getKey();
                String v = entry.getValue();
                this.replacement.put(Objects.requireNonNull(k, "replacement key"), Objects.requireNonNull(v, "replacement value"));
            }
            return this;
        }

        public ImmutableReplacements build() {
            return new ImmutableReplacements(ImmutableReplacements.createUnmodifiableMap(false, false, this.replacement));
        }
    }
}

