package de.flapdoodle.testdoc;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link End}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEnd.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableEnd.of()}.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "End"})
public final class ImmutableEnd implements End {
  private final Line line;

  private ImmutableEnd(Line line) {
    this.line = Objects.requireNonNull(line, "line");
  }

  private ImmutableEnd(ImmutableEnd original, Line line) {
    this.line = line;
  }

  /**
   * @return The value of the {@code line} attribute
   */
  @Override
  public Line line() {
    return line;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link End#line() line} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for line
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEnd withLine(Line value) {
    if (this.line == value) return this;
    Line newValue = Objects.requireNonNull(value, "line");
    return new ImmutableEnd(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEnd} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEnd
        && equalTo((ImmutableEnd) another);
  }

  private boolean equalTo(ImmutableEnd another) {
    return line.equals(another.line);
  }

  /**
   * Computes a hash code from attributes: {@code line}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + line.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code End} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "End{"
        + "line=" + line
        + "}";
  }

  /**
   * Construct a new immutable {@code End} instance.
   * @param line The value for the {@code line} attribute
   * @return An immutable End instance
   */
  public static ImmutableEnd of(Line line) {
    return new ImmutableEnd(line);
  }

  /**
   * Creates an immutable copy of a {@link End} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable End instance
   */
  public static ImmutableEnd copyOf(End instance) {
    if (instance instanceof ImmutableEnd) {
      return (ImmutableEnd) instance;
    }
    return ImmutableEnd.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEnd ImmutableEnd}.
   * @return A new ImmutableEnd builder
   */
  public static ImmutableEnd.Builder builder() {
    return new ImmutableEnd.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEnd ImmutableEnd}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_LINE = 0x1L;
    private long initBits = 0x1L;

    private Line line;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.testdoc.HasLine} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HasLine instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.testdoc.End} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(End instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof HasLine) {
        HasLine instance = (HasLine) object;
        if ((bits & 0x1L) == 0) {
          line(instance.line());
          bits |= 0x1L;
        }
      }
      if (object instanceof End) {
        End instance = (End) object;
        if ((bits & 0x1L) == 0) {
          line(instance.line());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link End#line() line} attribute.
     * @param line The value for line 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder line(Line line) {
      this.line = Objects.requireNonNull(line, "line");
      initBits &= ~INIT_BIT_LINE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableEnd ImmutableEnd}.
     * @return An immutable instance of End
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEnd build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableEnd(null, line);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_LINE) != 0) attributes.add("line");
      return "Cannot build End, some of required attributes are not set " + attributes;
    }
  }
}
