package de.flapdoodle.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Loop}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLoop.builder()}.
 */
@Generated(from = "Loop", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableLoop<V, E> implements Loop<V, E> {
  private final Set<Edge<V, E>> edges;

  private ImmutableLoop(Set<Edge<V, E>> edges) {
    this.edges = edges;
  }

  /**
   * @return The value of the {@code edges} attribute
   */
  @Override
  public Set<Edge<V, E>> edges() {
    return edges;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Loop#edges() edges}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableLoop<V, E> withEdges(Edge<V, E>... elements) {
    Set<Edge<V, E>> newValue = createUnmodifiableSet(createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableLoop<>(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Loop#edges() edges}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of edges elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLoop<V, E> withEdges(Iterable<? extends Edge<V, E>> elements) {
    if (this.edges == elements) return this;
    Set<Edge<V, E>> newValue = createUnmodifiableSet(createSafeList(elements, true, false));
    return new ImmutableLoop<>(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLoop} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLoop<?, ?>
        && equalTo((ImmutableLoop<?, ?>) another);
  }

  private boolean equalTo(ImmutableLoop<?, ?> another) {
    return edges.equals(another.edges);
  }

  /**
   * Computes a hash code from attributes: {@code edges}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + edges.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Loop} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Loop{"
        + "edges=" + edges
        + "}";
  }

  private transient volatile long lazyInitBitmap;

  private static final long VERTEX_SET_LAZY_INIT_BIT = 0x1L;

  private transient Set<V> vertexSet;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Loop#vertexSet() vertexSet} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code vertexSet} attribute
   */
  @Override
  public Set<V> vertexSet() {
    if ((lazyInitBitmap & VERTEX_SET_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & VERTEX_SET_LAZY_INIT_BIT) == 0) {
          this.vertexSet = Objects.requireNonNull(Loop.super.vertexSet(), "vertexSet");
          lazyInitBitmap |= VERTEX_SET_LAZY_INIT_BIT;
        }
      }
    }
    return vertexSet;
  }

  /**
   * Creates an immutable copy of a {@link Loop} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <V> generic parameter V
   * @param <E> generic parameter E
   * @param instance The instance to copy
   * @return A copied immutable Loop instance
   */
  public static <V, E> ImmutableLoop<V, E> copyOf(Loop<V, E> instance) {
    if (instance instanceof ImmutableLoop<?, ?>) {
      return (ImmutableLoop<V, E>) instance;
    }
    return ImmutableLoop.<V, E>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLoop ImmutableLoop}.
   * <pre>
   * ImmutableLoop.&amp;lt;V, E&amp;gt;builder()
   *    .addEdges|addAllEdges(de.flapdoodle.graph.Edge&amp;lt;V, E&amp;gt;) // {@link Loop#edges() edges} elements
   *    .build();
   * </pre>
   * @param <V> generic parameter V
   * @param <E> generic parameter E
   * @return A new ImmutableLoop builder
   */
  public static <V, E> ImmutableLoop.Builder<V, E> builder() {
    return new ImmutableLoop.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableLoop ImmutableLoop}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Loop", generator = "Immutables")
  public static final class Builder<V, E> {
    private List<Edge<V, E>> edges = new ArrayList<Edge<V, E>>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Loop} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<V, E> from(Loop<V, E> instance) {
      Objects.requireNonNull(instance, "instance");
      addAllEdges(instance.edges());
      return this;
    }

    /**
     * Adds one element to {@link Loop#edges() edges} set.
     * @param element A edges element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<V, E> addEdges(Edge<V, E> element) {
      this.edges.add(Objects.requireNonNull(element, "edges element"));
      return this;
    }

    /**
     * Adds elements to {@link Loop#edges() edges} set.
     * @param elements An array of edges elements
     * @return {@code this} builder for use in a chained invocation
     */
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder<V, E> addEdges(Edge<V, E>... elements) {
      for (Edge<V, E> element : elements) {
        this.edges.add(Objects.requireNonNull(element, "edges element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Loop#edges() edges} set.
     * @param elements An iterable of edges elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<V, E> edges(Iterable<? extends Edge<V, E>> elements) {
      this.edges.clear();
      return addAllEdges(elements);
    }

    /**
     * Adds elements to {@link Loop#edges() edges} set.
     * @param elements An iterable of edges elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<V, E> addAllEdges(Iterable<? extends Edge<V, E>> elements) {
      for (Edge<V, E> element : elements) {
        this.edges.add(Objects.requireNonNull(element, "edges element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableLoop ImmutableLoop}.
     * @return An immutable instance of Loop
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLoop<V, E> build() {
      return new ImmutableLoop<>(createUnmodifiableSet(edges));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  /** Unmodifiable set constructed from list to avoid rehashing. */
  private static <T> Set<T> createUnmodifiableSet(List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default:
      Set<T> set = new LinkedHashSet<>(list.size());
      set.addAll(list);
      return Collections.unmodifiableSet(set);
    }
  }
}
