/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.graph;

import de.flapdoodle.graph.ImmutableGraphAsDot;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.immutables.builder.Builder;
import org.immutables.value.Value;
import org.jgrapht.Graph;

@Value.Immutable
public interface GraphAsDot<T> {
    @Builder.Parameter
    public Function<T, String> nodeAsString();

    @Value.Default
    default public BiFunction<T, T, Map<String, String>> edgeAttributes() {
        return (a, b) -> Collections.emptyMap();
    }

    @Value.Default
    default public Function<T, Map<String, String>> nodeAttributes() {
        return a -> Collections.emptyMap();
    }

    @Value.Default
    default public String label() {
        return "graph";
    }

    @Value.Auxiliary
    default public <E> String asDot(Graph<T, E> graph) {
        StringBuilder sb = new StringBuilder();
        sb.append("digraph ").append(this.label()).append(" {\n").append("\trankdir=LR;\n").append("\n");
        graph.vertexSet().forEach(v -> sb.append("\t").append(this.quote(this.nodeAsString().apply(v))).append(this.asNodeAttributes(this.nodeAttributes().apply(v))).append(";\n"));
        sb.append("\n");
        graph.edgeSet().forEach(edge -> {
            Object a = graph.getEdgeSource(edge);
            Object b = graph.getEdgeTarget(edge);
            sb.append("\t").append(this.quote(this.nodeAsString().apply(a))).append(" -> ").append(this.quote(this.nodeAsString().apply(b))).append(this.asNodeAttributes(this.edgeAttributes().apply(a, b))).append(";\n");
        });
        sb.append("}\n");
        return sb.toString();
    }

    @Value.Auxiliary
    default public String asNodeAttributes(Map<String, String> map) {
        return map.isEmpty() ? "" : "[ " + map.entrySet().stream().map(e -> (String)e.getKey() + "=" + this.quote((String)e.getValue())).collect(Collectors.joining(", ")) + " ]";
    }

    @Value.Auxiliary
    default public String quote(String src) {
        return "\"" + src + "\"";
    }

    public static <T> ImmutableGraphAsDot.Builder<T> builder(Function<T, String> nodeAsString) {
        return ImmutableGraphAsDot.builder(nodeAsString);
    }
}

