/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.Size;
import com.sun.glass.ui.monocle.Framebuffer;
import com.sun.glass.ui.monocle.LinuxFrameBuffer;
import com.sun.glass.ui.monocle.NativeCursor;
import com.sun.glass.ui.monocle.NativePlatformFactory;
import com.sun.glass.ui.monocle.NativeScreen;
import com.sun.glass.ui.monocle.SoftwareCursor;
import com.sun.glass.ui.monocle.SysFS;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.AccessController;
import java.util.function.IntConsumer;

class FBDevScreen
implements NativeScreen {
    private int nativeFormat;
    private long nativeHandle;
    private FileChannel fbdev;
    private ByteBuffer mappedFB;
    private boolean isShutdown;
    private int consoleCursorBlink;
    private Framebuffer fb;
    private LinuxFrameBuffer linuxFB;
    private final String fbDevPath;

    FBDevScreen() {
        String tmp;
        this.fbDevPath = tmp = AccessController.doPrivileged(() -> System.getProperty("monocle.screen.fb", "/dev/fb0"));
        try {
            this.linuxFB = new LinuxFrameBuffer(this.fbDevPath);
            this.nativeHandle = 1L;
            this.nativeFormat = 1;
            try {
                this.consoleCursorBlink = SysFS.readInt("/sys/devices/virtual/graphics/fbcon/cursor_blink");
                if (this.consoleCursorBlink != 0) {
                    SysFS.write("/sys/devices/virtual/graphics/fbcon/cursor_blink", "0");
                }
            }
            catch (IOException e) {
                this.consoleCursorBlink = 0;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw (IllegalStateException)new IllegalStateException().initCause(e);
        }
    }

    @Override
    public int getDepth() {
        return this.linuxFB.getDepth();
    }

    @Override
    public int getNativeFormat() {
        return this.nativeFormat;
    }

    @Override
    public int getWidth() {
        return this.linuxFB.getWidth();
    }

    @Override
    public int getHeight() {
        return this.linuxFB.getHeight();
    }

    @Override
    public long getNativeHandle() {
        return this.nativeHandle;
    }

    @Override
    public float getScale() {
        return 1.0f;
    }

    @Override
    public int getDPI() {
        return 96;
    }

    private boolean isFBDevOpen() {
        return this.mappedFB != null || this.fbdev != null;
    }

    private void openFBDev() throws IOException {
        if (this.mappedFB == null) {
            Path fbdevPath = FileSystems.getDefault().getPath(this.fbDevPath, new String[0]);
            this.fbdev = FileChannel.open(fbdevPath, StandardOpenOption.WRITE);
        }
    }

    private void closeFBDev() {
        if (this.mappedFB != null) {
            this.linuxFB.releaseMappedBuffer(this.mappedFB);
            this.mappedFB = null;
        } else if (this.fbdev != null) {
            try {
                this.fbdev.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fbdev = null;
        }
        this.linuxFB.close();
    }

    private Framebuffer getFramebuffer() {
        if (this.fb == null) {
            if (this.linuxFB.getDepth() == 32 && this.linuxFB.canDoubleBuffer()) {
                this.mappedFB = this.linuxFB.getMappedBuffer();
            }
            ByteBuffer bb = this.mappedFB != null ? this.mappedFB : ByteBuffer.allocateDirect(this.getWidth() * this.getHeight() * 4);
            bb.order(ByteOrder.nativeOrder());
            this.fb = new Framebuffer(bb, this.getWidth(), this.getHeight(), this.getDepth(), true);
            this.fb.setStartAddress(this.linuxFB.getNextAddress());
        }
        return this.fb;
    }

    private void forEachPixelOffset(IntConsumer c) {
        int h = this.getHeight();
        int w = this.getWidth();
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                c.accept(i * w + j);
            }
        }
    }

    @Override
    public synchronized void shutdown() {
        this.getFramebuffer().clearBufferContents();
        try {
            if (this.isFBDevOpen()) {
                this.writeBuffer();
                this.closeFBDev();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.isShutdown = true;
        }
        if (this.consoleCursorBlink != 0) {
            try {
                SysFS.write("/sys/devices/virtual/graphics/fbcon/cursor_blink", String.valueOf(this.consoleCursorBlink));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public synchronized void uploadPixels(Buffer b, int pX, int pY, int pWidth, int pHeight, float alpha) {
        this.getFramebuffer().composePixels(b, pX, pY, pWidth, pHeight, alpha);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void swapBuffers() {
        try {
            if (this.isShutdown || this.fb == null || !this.getFramebuffer().hasReceivedData()) {
                return;
            }
            NativeCursor cursor = NativePlatformFactory.getNativePlatform().getCursor();
            if (cursor instanceof SoftwareCursor && cursor.getVisiblity()) {
                SoftwareCursor swCursor = (SoftwareCursor)cursor;
                Buffer b = swCursor.getCursorBuffer();
                Size size = swCursor.getBestSize();
                this.uploadPixels(b, swCursor.getRenderX(), swCursor.getRenderY(), size.width, size.height, 1.0f);
            }
            this.writeBuffer();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.getFramebuffer().reset();
        }
    }

    private synchronized void writeBuffer() throws IOException {
        if (!this.linuxFB.isDoubleBuffer()) {
            this.linuxFB.vSync();
        }
        if (this.mappedFB == null) {
            if (!this.isFBDevOpen()) {
                this.openFBDev();
            }
            this.fbdev.position(this.linuxFB.getNextAddress());
            this.getFramebuffer().write(this.fbdev);
        } else if (this.linuxFB.isDoubleBuffer()) {
            this.linuxFB.next();
            this.linuxFB.vSync();
            this.getFramebuffer().setStartAddress(this.linuxFB.getNextAddress());
        }
    }

    @Override
    public synchronized ByteBuffer getScreenCapture() {
        ByteBuffer ret = null;
        ByteBuffer bb = this.linuxFB.getMappedBuffer();
        if (bb != null) {
            bb.position(this.linuxFB.getNativeOffset());
            bb.order(ByteOrder.nativeOrder());
            ret = ByteBuffer.allocate(this.getHeight() * this.getWidth() * 4);
            IntBuffer dst = ret.asIntBuffer();
            if (this.getDepth() == 32) {
                IntBuffer src = bb.asIntBuffer();
                this.forEachPixelOffset(offset -> dst.put(src.get(offset)));
            } else {
                ShortBuffer src = bb.asShortBuffer();
                this.forEachPixelOffset(offset -> {
                    short p = src.get(offset);
                    int pi = 0xFF000000 | (p & 0xF800) << 8 | (p & 0x7E0) << 5 | (p & 0x1F) << 3;
                    dst.put(pi);
                });
            }
            this.linuxFB.releaseMappedBuffer(bb);
        }
        return ret;
    }
}

