/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.InputDeviceRegistry;
import com.sun.glass.ui.monocle.LinuxInputDevice;
import com.sun.glass.ui.monocle.LinuxInputProcessor;
import com.sun.glass.ui.monocle.LinuxKeyProcessor;
import com.sun.glass.ui.monocle.LinuxSimpleTouchProcessor;
import com.sun.glass.ui.monocle.LinuxSystem;
import com.sun.glass.ui.monocle.SysFS;
import com.sun.glass.ui.monocle.Udev;
import com.sun.glass.ui.monocle.UdevListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

class EPDInputDeviceRegistry
extends InputDeviceRegistry {
    private static final String KEYPAD_FILENAME = "event0";
    private static final String TOUCH_FILENAME = "event1";

    EPDInputDeviceRegistry(boolean headless) {
        if (headless) {
            return;
        }
        HashMap deviceMap = new HashMap();
        UdevListener udevListener = (action, event) -> {
            String subsystem = (String)event.get("SUBSYSTEM");
            String devPath = (String)event.get("DEVPATH");
            String devName = (String)event.get("DEVNAME");
            if (subsystem != null && subsystem.equals("input") && devPath != null && devName != null) {
                try {
                    File sysPath = new File("/sys", devPath);
                    if (action.equals("add") || action.equals("change") && !deviceMap.containsKey(sysPath)) {
                        File devNode = new File(devName);
                        LinuxInputDevice device = this.createDevice(devNode, sysPath, event);
                        if (device != null) {
                            deviceMap.put(sysPath, device);
                        }
                    } else if (action.equals("remove")) {
                        LinuxInputDevice device = (LinuxInputDevice)deviceMap.get(sysPath);
                        deviceMap.remove(sysPath);
                        if (device != null) {
                            this.devices.remove((Object)device);
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        Udev.getInstance().addListener(udevListener);
        SysFS.triggerUdevNotification("input");
    }

    private LinuxInputDevice createDevice(File devNode, File sysPath, Map<String, String> udevManifest) throws IOException {
        LinuxSystem system = LinuxSystem.getLinuxSystem();
        system.open(devNode.getPath(), 0);
        LinuxInputDevice device = new LinuxInputDevice(devNode, sysPath, udevManifest);
        return this.addDeviceInternal(device, "Linux input: " + devNode.toString());
    }

    private LinuxInputDevice addDeviceInternal(LinuxInputDevice device, String name) {
        LinuxInputProcessor processor = null;
        if (name.endsWith(KEYPAD_FILENAME)) {
            processor = new LinuxKeyProcessor();
        } else if (name.endsWith(TOUCH_FILENAME)) {
            processor = new LinuxSimpleTouchProcessor(device);
        }
        if (processor == null) {
            return null;
        }
        device.setInputProcessor(processor);
        Thread thread = new Thread(device);
        thread.setName(name);
        thread.setDaemon(true);
        thread.start();
        this.devices.add((Object)device);
        return device;
    }

    public String toString() {
        return MessageFormat.format("{0}[devices={1}]", this.getClass().getName(), this.devices);
    }
}

