/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embedmongo.distribution;

import de.flapdoodle.embedmongo.distribution.BitSize;
import de.flapdoodle.embedmongo.distribution.Platform;
import de.flapdoodle.embedmongo.distribution.Version;

public class Distribution {
    private final Version _version;
    private final Platform _platform;
    private final BitSize _bitsize;

    public Distribution(Version version, Platform platform, BitSize bitsize) {
        this._version = version;
        this._platform = platform;
        this._bitsize = bitsize;
    }

    public Version getVersion() {
        return this._version;
    }

    public Platform getPlatform() {
        return this._platform;
    }

    public BitSize getBitsize() {
        return this._bitsize;
    }

    public String toString() {
        return "" + (Object)((Object)this._version) + ":" + (Object)((Object)this._platform) + ":" + (Object)((Object)this._bitsize);
    }

    public static Distribution detectFor(Version version) {
        BitSize bitSize = BitSize.B32;
        String osArch = System.getProperty("os.arch");
        if (osArch.equals("i686_64") || osArch.equals("x86_64")) {
            bitSize = BitSize.B64;
        }
        String osName = System.getProperty("os.name");
        Platform platform = null;
        if (osName.equals("Linux")) {
            platform = Platform.Linux;
        }
        if (osName.startsWith("Windows", 0)) {
            platform = Platform.Windows;
        }
        if (osName.equals("Mac OS X")) {
            platform = Platform.OS_X;
        }
        if (platform == null) {
            throw new IllegalArgumentException("Could not detect Platform: os.name=" + osName);
        }
        return new Distribution(version, platform, bitSize);
    }
}

