/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embedmongo.extract;

import de.flapdoodle.embedmongo.Files;
import de.flapdoodle.embedmongo.config.RuntimeConfig;
import de.flapdoodle.embedmongo.extract.IExtractor;
import de.flapdoodle.embedmongo.output.IProgressListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;

public class ZipExtractor
implements IExtractor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extract(RuntimeConfig runtime, File source, File destination, Pattern file) throws IOException {
        IProgressListener progressListener = runtime.getProgressListener();
        String progressLabel = "Extract " + source;
        progressListener.start(progressLabel);
        FileInputStream fin = new FileInputStream(source);
        BufferedInputStream in = new BufferedInputStream(fin);
        ZipArchiveInputStream zipIn = new ZipArchiveInputStream((InputStream)in);
        try {
            ZipArchiveEntry entry;
            while ((entry = zipIn.getNextZipEntry()) != null) {
                if (!file.matcher(entry.getName()).matches()) continue;
                if (zipIn.canReadEntryData((ArchiveEntry)entry)) {
                    long size = entry.getSize();
                    Files.write((InputStream)zipIn, size, destination);
                    destination.setExecutable(true);
                    progressListener.done(progressLabel);
                }
                break;
            }
        }
        finally {
            zipIn.close();
        }
    }
}

