/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embedmongo;

import de.flapdoodle.embedmongo.Downloader;
import de.flapdoodle.embedmongo.Files;
import de.flapdoodle.embedmongo.LocalArtifactStore;
import de.flapdoodle.embedmongo.MongodExecutable;
import de.flapdoodle.embedmongo.Paths;
import de.flapdoodle.embedmongo.config.MongodConfig;
import de.flapdoodle.embedmongo.config.RuntimeConfig;
import de.flapdoodle.embedmongo.distribution.Distribution;
import de.flapdoodle.embedmongo.extract.Extractors;
import de.flapdoodle.embedmongo.extract.IExtractor;
import de.flapdoodle.embedmongo.output.IProgressListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MongoDBRuntime {
    private static final Logger _logger = Logger.getLogger(MongoDBRuntime.class.getName());
    private final RuntimeConfig _runtime;

    private MongoDBRuntime(RuntimeConfig config) {
        this._runtime = config;
    }

    public static MongoDBRuntime getInstance(RuntimeConfig config) {
        return new MongoDBRuntime(config);
    }

    public static MongoDBRuntime getDefaultInstance() {
        return MongoDBRuntime.getInstance(new RuntimeConfig());
    }

    public boolean checkDistribution(Distribution distribution) throws IOException {
        if (!LocalArtifactStore.checkArtifact(this._runtime, distribution)) {
            return LocalArtifactStore.store(this._runtime, distribution, Downloader.download(this._runtime, distribution));
        }
        return true;
    }

    public MongodExecutable prepare(MongodConfig mongodConfig) {
        try {
            IProgressListener progress = this._runtime.getProgressListener();
            Distribution distribution = Distribution.detectFor(mongodConfig.getVersion());
            progress.done("Detect Distribution");
            if (this.checkDistribution(distribution)) {
                progress.done("Check Distribution");
                File mongodExe = this.extractMongod(distribution);
                return new MongodExecutable(mongodConfig, mongodExe);
            }
        }
        catch (IOException iox) {
            _logger.log(Level.SEVERE, "start", iox);
        }
        return null;
    }

    protected File extractMongod(Distribution distribution) throws IOException {
        File artifact = LocalArtifactStore.getArtifact(this._runtime, distribution);
        IExtractor extractor = Extractors.getExtractor(distribution);
        File mongodExe = Files.createTempFile("extract", Paths.getMongodExecutable(distribution));
        extractor.extract(this._runtime, artifact, mongodExe, Paths.getMongodExecutablePattern(distribution));
        return mongodExe;
    }
}

