/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embedmongo.io;

import de.flapdoodle.embedmongo.io.IBlockProcessor;
import java.util.logging.Logger;

public class BlockLogWatchProcessor
implements IBlockProcessor {
    private static final Logger _logger = Logger.getLogger(BlockLogWatchProcessor.class.getName());
    private final StringBuilder _output = new StringBuilder();
    private final String _success;
    private final String _failure;
    private boolean _initWithSuccess = false;
    private final IBlockProcessor _destination;

    public BlockLogWatchProcessor(String success, String failure, IBlockProcessor destination) {
        this._success = success;
        this._failure = failure;
        this._destination = destination;
    }

    @Override
    public void process(String block) {
        this._destination.process(block);
        String line = block;
        this._output.append((CharSequence)line);
        if (this._output.indexOf(this._success) != -1) {
            this._initWithSuccess = true;
            this.gotResult();
        }
        if (this._output.indexOf(this._failure) != -1) {
            this._initWithSuccess = false;
            this.gotResult();
        }
    }

    @Override
    public void onProcessed() {
        this.gotResult();
    }

    private synchronized void gotResult() {
        this.notify();
    }

    public synchronized void waitForResult(long timeout) {
        try {
            this.wait(timeout);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean isInitWithSuccess() {
        return this._initWithSuccess;
    }

    public String getOutput() {
        return this._output.toString();
    }
}

