/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.transitions;

import de.flapdoodle.embed.process.archives.ExtractFileSet;
import de.flapdoodle.embed.process.archives.ExtractedFileSet;
import de.flapdoodle.embed.process.config.store.Package;
import de.flapdoodle.embed.process.io.Files;
import de.flapdoodle.embed.process.io.directories.TempDir;
import de.flapdoodle.embed.process.store.ExtractedFileSetStore;
import de.flapdoodle.embed.process.transitions.ImmutableExtractPackage;
import de.flapdoodle.embed.process.types.Archive;
import de.flapdoodle.embed.process.types.Name;
import de.flapdoodle.reverse.State;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.StateLookup;
import de.flapdoodle.reverse.TearDown;
import de.flapdoodle.reverse.Transition;
import de.flapdoodle.reverse.naming.HasLabel;
import de.flapdoodle.types.Try;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.Set;
import org.immutables.value.Value;

@Value.Immutable
public abstract class ExtractPackage
implements Transition<ExtractedFileSet>,
HasLabel {
    @Value.Default
    public String transitionLabel() {
        return "ExtractPackage";
    }

    @Value.Default
    protected StateID<Name> name() {
        return StateID.of(Name.class);
    }

    @Value.Default
    public StateID<ExtractedFileSet> destination() {
        return StateID.of(ExtractedFileSet.class);
    }

    @Value.Default
    protected StateID<Archive> archive() {
        return StateID.of(Archive.class);
    }

    @Value.Default
    protected StateID<Package> distPackage() {
        return StateID.of(Package.class);
    }

    @Value.Default
    protected StateID<TempDir> tempDir() {
        return StateID.of(TempDir.class);
    }

    protected abstract Optional<StateID<ExtractedFileSetStore>> extractedFileSetStore();

    public Set<StateID<?>> sources() {
        return this.extractedFileSetStore().isPresent() ? StateID.setOf((StateID[])new StateID[]{this.archive(), this.distPackage(), this.name(), this.tempDir(), this.extractedFileSetStore().get()}) : StateID.setOf((StateID[])new StateID[]{this.archive(), this.distPackage(), this.name(), this.tempDir()});
    }

    public State<ExtractedFileSet> result(StateLookup lookup) {
        Package dist = (Package)lookup.of(this.distPackage());
        Archive archive = (Archive)lookup.of(this.archive());
        Name name = (Name)lookup.of(this.name());
        TempDir tempDir = (TempDir)lookup.of(this.tempDir());
        Optional<ExtractedFileSetStore> store = this.extractedFileSetStore().map(arg_0 -> ((StateLookup)lookup).of(arg_0));
        Path destination = (Path)Try.apply(x$0 -> tempDir.createDirectory((String)x$0, new FileAttribute[0]), (Object)name.value());
        return this.extractedFileSet(dist, archive, destination, store);
    }

    private State<ExtractedFileSet> extractedFileSet(Package dist, Archive archive, Path destination, Optional<ExtractedFileSetStore> extractedFileSetStore) {
        if (extractedFileSetStore.isPresent()) {
            ExtractedFileSetStore store = extractedFileSetStore.get();
            Optional<ExtractedFileSet> cachedExtractedFileSet = store.extractedFileSet(archive.value(), dist.fileSet());
            if (cachedExtractedFileSet.isPresent()) {
                return State.of((Object)cachedExtractedFileSet.get(), (TearDown[])new TearDown[0]);
            }
            ExtractFileSet extractor = dist.archiveType().extractor();
            ExtractedFileSet extractedFileSet = (ExtractedFileSet)Try.get(() -> extractor.extract(destination, archive.value(), dist.fileSet()));
            return (State)Try.supplier(() -> ExtractPackage.cachedFileSet(store.store(archive.value(), dist.fileSet(), extractedFileSet))).fallbackTo(ex -> ExtractPackage.temporaryFileSet(extractedFileSet)).get();
        }
        ExtractFileSet extractor = dist.archiveType().extractor();
        return ExtractPackage.temporaryFileSet((ExtractedFileSet)Try.get(() -> extractor.extract(destination, archive.value(), dist.fileSet())));
    }

    private static State<ExtractedFileSet> temporaryFileSet(ExtractedFileSet current) {
        return State.of((Object)current, (TearDown[])new TearDown[]{fileSet -> Try.run(() -> Files.deleteAll(fileSet.baseDir()))});
    }

    private static State<ExtractedFileSet> cachedFileSet(ExtractedFileSet current) {
        return State.of((Object)current, (TearDown[])new TearDown[0]);
    }

    public static ImmutableExtractPackage.Builder builder() {
        return ImmutableExtractPackage.builder();
    }

    public static ImmutableExtractPackage withDefaults() {
        return ExtractPackage.builder().build();
    }
}

