/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.io.directories;

import de.flapdoodle.checks.Preconditions;
import de.flapdoodle.embed.process.io.directories.ImmutablePersistentDir;
import de.flapdoodle.embed.process.types.Wrapper;
import de.flapdoodle.types.ThrowingSupplier;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Function;
import java.util.function.Supplier;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Value.Immutable
public abstract class PersistentDir
extends Wrapper<Path> {
    private static Logger logger = LoggerFactory.getLogger(PersistentDir.class);

    @Value.Check
    protected void check() {
        Preconditions.checkArgument((boolean)Files.exists((Path)this.value(), new LinkOption[0]), (String)"does not exist: %s", (Object[])new Object[]{this.value()});
        Preconditions.checkArgument((boolean)Files.isDirectory((Path)this.value(), new LinkOption[0]), (String)"is not a directory: %s", (Object[])new Object[]{this.value()});
    }

    public static PersistentDir of(Path path) {
        return ImmutablePersistentDir.of(path);
    }

    public static Path userHome() {
        return PersistentDir.userHome(System::getProperty);
    }

    public static ThrowingSupplier<PersistentDir, IOException> inUserHome(String subDir) {
        return PersistentDir.inUserHome(System::getProperty, subDir);
    }

    public static ThrowingSupplier<PersistentDir, IOException> inWorkingDir(String subDir) {
        return PersistentDir.relativeTo(Paths.get("", new String[0]), subDir);
    }

    @Deprecated
    public static Supplier<PersistentDir> userHome(String subDir) {
        return () -> ((ThrowingSupplier)PersistentDir.inUserHome(subDir).mapCheckedException(RuntimeException::new)).get();
    }

    static ThrowingSupplier<PersistentDir, IOException> relativeTo(Path base, String subDir) {
        return () -> {
            Path current = base.resolve(subDir);
            if (!Files.exists(current, new LinkOption[0])) {
                Files.createDirectory(current, new FileAttribute[0]);
            }
            return PersistentDir.of(current);
        };
    }

    static ThrowingSupplier<PersistentDir, IOException> inUserHome(Function<String, String> systemGetProperty, String subDir) {
        return () -> {
            Path resolved = PersistentDir.userHome(systemGetProperty).resolve(subDir);
            if (!Files.exists(resolved, new LinkOption[0])) {
                Files.createDirectory(resolved, new FileAttribute[0]);
            }
            return PersistentDir.of(resolved);
        };
    }

    static Path userHome(Function<String, String> systemGetProperty) {
        String userHome = (String)Preconditions.checkNotNull((Object)systemGetProperty.apply("user.home"), (String)"user.home is null", (Object[])new Object[0]);
        if ("?".equals(userHome)) {
            logger.warn("user.home is set to '?', maybe this is running inside a docker container");
            logger.warn("use fallback to user.dir");
            String userDir = (String)Preconditions.checkNotNull((Object)systemGetProperty.apply("user.dir"), (String)"user.dir is null", (Object[])new Object[0]);
            Preconditions.checkArgument((!userDir.equals("?") ? 1 : 0) != 0, (String)"user.dir is set to '?'", (Object[])new Object[0]);
            logger.warn("use user.dir('{}') as fallback for user.home('{}')", (Object)userDir, (Object)userHome);
            userHome = userDir;
        }
        Path path = Paths.get(userHome, new String[0]);
        Preconditions.checkArgument((boolean)Files.isDirectory(path, new LinkOption[0]), (String)"%s is not a directory", (Object[])new Object[]{path});
        return path;
    }
}

