package de.flapdoodle.embed.process.types;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ProcessConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProcessConfig.builder()}.
 */
@Generated(from = "ProcessConfig", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutableProcessConfig implements ProcessConfig {
  private final boolean daemonProcess;
  private final long stopTimeoutInMillis;

  private ImmutableProcessConfig(ImmutableProcessConfig.Builder builder) {
    if (builder.daemonProcessIsSet()) {
      initShim.daemonProcess(builder.daemonProcess);
    }
    if (builder.stopTimeoutInMillisIsSet()) {
      initShim.stopTimeoutInMillis(builder.stopTimeoutInMillis);
    }
    this.daemonProcess = initShim.daemonProcess();
    this.stopTimeoutInMillis = initShim.stopTimeoutInMillis();
    this.initShim = null;
  }

  private ImmutableProcessConfig(boolean daemonProcess, long stopTimeoutInMillis) {
    this.daemonProcess = daemonProcess;
    this.stopTimeoutInMillis = stopTimeoutInMillis;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "ProcessConfig", generator = "Immutables")
  private final class InitShim {
    private byte daemonProcessBuildStage = STAGE_UNINITIALIZED;
    private boolean daemonProcess;

    boolean daemonProcess() {
      if (daemonProcessBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (daemonProcessBuildStage == STAGE_UNINITIALIZED) {
        daemonProcessBuildStage = STAGE_INITIALIZING;
        this.daemonProcess = daemonProcessInitialize();
        daemonProcessBuildStage = STAGE_INITIALIZED;
      }
      return this.daemonProcess;
    }

    void daemonProcess(boolean daemonProcess) {
      this.daemonProcess = daemonProcess;
      daemonProcessBuildStage = STAGE_INITIALIZED;
    }

    private byte stopTimeoutInMillisBuildStage = STAGE_UNINITIALIZED;
    private long stopTimeoutInMillis;

    long stopTimeoutInMillis() {
      if (stopTimeoutInMillisBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (stopTimeoutInMillisBuildStage == STAGE_UNINITIALIZED) {
        stopTimeoutInMillisBuildStage = STAGE_INITIALIZING;
        this.stopTimeoutInMillis = stopTimeoutInMillisInitialize();
        stopTimeoutInMillisBuildStage = STAGE_INITIALIZED;
      }
      return this.stopTimeoutInMillis;
    }

    void stopTimeoutInMillis(long stopTimeoutInMillis) {
      this.stopTimeoutInMillis = stopTimeoutInMillis;
      stopTimeoutInMillisBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (daemonProcessBuildStage == STAGE_INITIALIZING) attributes.add("daemonProcess");
      if (stopTimeoutInMillisBuildStage == STAGE_INITIALIZING) attributes.add("stopTimeoutInMillis");
      return "Cannot build ProcessConfig, attribute initializers form cycle " + attributes;
    }
  }

  private boolean daemonProcessInitialize() {
    return ProcessConfig.super.daemonProcess();
  }

  private long stopTimeoutInMillisInitialize() {
    return ProcessConfig.super.stopTimeoutInMillis();
  }

  /**
   * @return The value of the {@code daemonProcess} attribute
   */
  @Override
  public boolean daemonProcess() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.daemonProcess()
        : this.daemonProcess;
  }

  /**
   * @return The value of the {@code stopTimeoutInMillis} attribute
   */
  @Override
  public long stopTimeoutInMillis() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.stopTimeoutInMillis()
        : this.stopTimeoutInMillis;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessConfig#daemonProcess() daemonProcess} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for daemonProcess
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessConfig withDaemonProcess(boolean value) {
    if (this.daemonProcess == value) return this;
    return new ImmutableProcessConfig(value, this.stopTimeoutInMillis);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessConfig#stopTimeoutInMillis() stopTimeoutInMillis} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for stopTimeoutInMillis
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessConfig withStopTimeoutInMillis(long value) {
    if (this.stopTimeoutInMillis == value) return this;
    return new ImmutableProcessConfig(this.daemonProcess, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProcessConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProcessConfig
        && equalTo(0, (ImmutableProcessConfig) another);
  }

  private boolean equalTo(int synthetic, ImmutableProcessConfig another) {
    return daemonProcess == another.daemonProcess
        && stopTimeoutInMillis == another.stopTimeoutInMillis;
  }

  /**
   * Computes a hash code from attributes: {@code daemonProcess}, {@code stopTimeoutInMillis}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Boolean.hashCode(daemonProcess);
    h += (h << 5) + Long.hashCode(stopTimeoutInMillis);
    return h;
  }

  /**
   * Prints the immutable value {@code ProcessConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ProcessConfig{"
        + "daemonProcess=" + daemonProcess
        + ", stopTimeoutInMillis=" + stopTimeoutInMillis
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ProcessConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ProcessConfig instance
   */
  public static ImmutableProcessConfig copyOf(ProcessConfig instance) {
    if (instance instanceof ImmutableProcessConfig) {
      return (ImmutableProcessConfig) instance;
    }
    return ImmutableProcessConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProcessConfig ImmutableProcessConfig}.
   * <pre>
   * ImmutableProcessConfig.builder()
   *    .daemonProcess(boolean) // optional {@link ProcessConfig#daemonProcess() daemonProcess}
   *    .stopTimeoutInMillis(long) // optional {@link ProcessConfig#stopTimeoutInMillis() stopTimeoutInMillis}
   *    .build();
   * </pre>
   * @return A new ImmutableProcessConfig builder
   */
  public static ImmutableProcessConfig.Builder builder() {
    return new ImmutableProcessConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProcessConfig ImmutableProcessConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ProcessConfig", generator = "Immutables")
  public static final class Builder {
    private static final long OPT_BIT_DAEMON_PROCESS = 0x1L;
    private static final long OPT_BIT_STOP_TIMEOUT_IN_MILLIS = 0x2L;
    private long optBits;

    private boolean daemonProcess;
    private long stopTimeoutInMillis;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ProcessConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessConfig instance) {
      Objects.requireNonNull(instance, "instance");
      daemonProcess(instance.daemonProcess());
      stopTimeoutInMillis(instance.stopTimeoutInMillis());
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessConfig#daemonProcess() daemonProcess} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ProcessConfig#daemonProcess() daemonProcess}.</em>
     * @param daemonProcess The value for daemonProcess 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder daemonProcess(boolean daemonProcess) {
      this.daemonProcess = daemonProcess;
      optBits |= OPT_BIT_DAEMON_PROCESS;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessConfig#stopTimeoutInMillis() stopTimeoutInMillis} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ProcessConfig#stopTimeoutInMillis() stopTimeoutInMillis}.</em>
     * @param stopTimeoutInMillis The value for stopTimeoutInMillis 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stopTimeoutInMillis(long stopTimeoutInMillis) {
      this.stopTimeoutInMillis = stopTimeoutInMillis;
      optBits |= OPT_BIT_STOP_TIMEOUT_IN_MILLIS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableProcessConfig ImmutableProcessConfig}.
     * @return An immutable instance of ProcessConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProcessConfig build() {
      return new ImmutableProcessConfig(this);
    }

    private boolean daemonProcessIsSet() {
      return (optBits & OPT_BIT_DAEMON_PROCESS) != 0;
    }

    private boolean stopTimeoutInMillisIsSet() {
      return (optBits & OPT_BIT_STOP_TIMEOUT_IN_MILLIS) != 0;
    }
  }
}
