/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.transitions;

import de.flapdoodle.embed.process.config.DownloadConfig;
import de.flapdoodle.embed.process.config.store.Package;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.io.directories.TempDir;
import de.flapdoodle.embed.process.io.progress.ProgressListener;
import de.flapdoodle.embed.process.net.DownloadToPath;
import de.flapdoodle.embed.process.store.DownloadCache;
import de.flapdoodle.embed.process.transitions.DownloadPackage;
import de.flapdoodle.embed.process.types.Archive;
import de.flapdoodle.embed.process.types.Name;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.naming.HasLabel;
import java.util.ArrayList;
import java.util.Objects;

public final class ImmutableDownloadPackage
extends DownloadPackage {
    private final String transitionLabel;
    private final StateID<Name> name;
    private final StateID<DownloadCache> downloadCache;
    private final StateID<ProgressListener> progressListener;
    private final DownloadConfig downloadConfig;
    private final StateID<Distribution> distribution;
    private final StateID<Package> distPackage;
    private final StateID<TempDir> tempDirectory;
    private final StateID<Archive> destination;
    private final DownloadToPath downloadToPath;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableDownloadPackage(Builder builder) {
        if (builder.transitionLabel != null) {
            this.initShim.transitionLabel(builder.transitionLabel);
        }
        if (builder.name != null) {
            this.initShim.name((StateID<Name>)builder.name);
        }
        if (builder.downloadCache != null) {
            this.initShim.downloadCache((StateID<DownloadCache>)builder.downloadCache);
        }
        if (builder.progressListener != null) {
            this.initShim.progressListener((StateID<ProgressListener>)builder.progressListener);
        }
        if (builder.downloadConfig != null) {
            this.initShim.downloadConfig(builder.downloadConfig);
        }
        if (builder.distribution != null) {
            this.initShim.distribution((StateID<Distribution>)builder.distribution);
        }
        if (builder.distPackage != null) {
            this.initShim.distPackage((StateID<Package>)builder.distPackage);
        }
        if (builder.tempDirectory != null) {
            this.initShim.tempDirectory((StateID<TempDir>)builder.tempDirectory);
        }
        if (builder.destination != null) {
            this.initShim.destination((StateID<Archive>)builder.destination);
        }
        if (builder.downloadToPath != null) {
            this.initShim.downloadToPath(builder.downloadToPath);
        }
        this.transitionLabel = this.initShim.transitionLabel();
        this.name = this.initShim.name();
        this.downloadCache = this.initShim.downloadCache();
        this.progressListener = this.initShim.progressListener();
        this.downloadConfig = this.initShim.downloadConfig();
        this.distribution = this.initShim.distribution();
        this.distPackage = this.initShim.distPackage();
        this.tempDirectory = this.initShim.tempDirectory();
        this.destination = this.initShim.destination();
        this.downloadToPath = this.initShim.downloadToPath();
        this.initShim = null;
    }

    private ImmutableDownloadPackage(String transitionLabel, StateID<Name> name, StateID<DownloadCache> downloadCache, StateID<ProgressListener> progressListener, DownloadConfig downloadConfig, StateID<Distribution> distribution, StateID<Package> distPackage, StateID<TempDir> tempDirectory, StateID<Archive> destination, DownloadToPath downloadToPath) {
        this.transitionLabel = transitionLabel;
        this.name = name;
        this.downloadCache = downloadCache;
        this.progressListener = progressListener;
        this.downloadConfig = downloadConfig;
        this.distribution = distribution;
        this.distPackage = distPackage;
        this.tempDirectory = tempDirectory;
        this.destination = destination;
        this.downloadToPath = downloadToPath;
        this.initShim = null;
    }

    @Override
    public String transitionLabel() {
        InitShim shim = this.initShim;
        return shim != null ? shim.transitionLabel() : this.transitionLabel;
    }

    @Override
    protected StateID<Name> name() {
        InitShim shim = this.initShim;
        return shim != null ? shim.name() : this.name;
    }

    @Override
    protected StateID<DownloadCache> downloadCache() {
        InitShim shim = this.initShim;
        return shim != null ? shim.downloadCache() : this.downloadCache;
    }

    @Override
    protected StateID<ProgressListener> progressListener() {
        InitShim shim = this.initShim;
        return shim != null ? shim.progressListener() : this.progressListener;
    }

    @Override
    protected DownloadConfig downloadConfig() {
        InitShim shim = this.initShim;
        return shim != null ? shim.downloadConfig() : this.downloadConfig;
    }

    @Override
    protected StateID<Distribution> distribution() {
        InitShim shim = this.initShim;
        return shim != null ? shim.distribution() : this.distribution;
    }

    @Override
    protected StateID<Package> distPackage() {
        InitShim shim = this.initShim;
        return shim != null ? shim.distPackage() : this.distPackage;
    }

    @Override
    protected StateID<TempDir> tempDirectory() {
        InitShim shim = this.initShim;
        return shim != null ? shim.tempDirectory() : this.tempDirectory;
    }

    @Override
    public StateID<Archive> destination() {
        InitShim shim = this.initShim;
        return shim != null ? shim.destination() : this.destination;
    }

    @Override
    public DownloadToPath downloadToPath() {
        InitShim shim = this.initShim;
        return shim != null ? shim.downloadToPath() : this.downloadToPath;
    }

    public final ImmutableDownloadPackage withTransitionLabel(String value) {
        String newValue = Objects.requireNonNull(value, "transitionLabel");
        if (this.transitionLabel.equals(newValue)) {
            return this;
        }
        return new ImmutableDownloadPackage(newValue, this.name, this.downloadCache, this.progressListener, this.downloadConfig, this.distribution, this.distPackage, this.tempDirectory, this.destination, this.downloadToPath);
    }

    public final ImmutableDownloadPackage withName(StateID<Name> value) {
        if (this.name == value) {
            return this;
        }
        StateID<Name> newValue = Objects.requireNonNull(value, "name");
        return new ImmutableDownloadPackage(this.transitionLabel, newValue, this.downloadCache, this.progressListener, this.downloadConfig, this.distribution, this.distPackage, this.tempDirectory, this.destination, this.downloadToPath);
    }

    public final ImmutableDownloadPackage withDownloadCache(StateID<DownloadCache> value) {
        if (this.downloadCache == value) {
            return this;
        }
        StateID<DownloadCache> newValue = Objects.requireNonNull(value, "downloadCache");
        return new ImmutableDownloadPackage(this.transitionLabel, this.name, newValue, this.progressListener, this.downloadConfig, this.distribution, this.distPackage, this.tempDirectory, this.destination, this.downloadToPath);
    }

    public final ImmutableDownloadPackage withProgressListener(StateID<ProgressListener> value) {
        if (this.progressListener == value) {
            return this;
        }
        StateID<ProgressListener> newValue = Objects.requireNonNull(value, "progressListener");
        return new ImmutableDownloadPackage(this.transitionLabel, this.name, this.downloadCache, newValue, this.downloadConfig, this.distribution, this.distPackage, this.tempDirectory, this.destination, this.downloadToPath);
    }

    public final ImmutableDownloadPackage withDownloadConfig(DownloadConfig value) {
        if (this.downloadConfig == value) {
            return this;
        }
        DownloadConfig newValue = Objects.requireNonNull(value, "downloadConfig");
        return new ImmutableDownloadPackage(this.transitionLabel, this.name, this.downloadCache, this.progressListener, newValue, this.distribution, this.distPackage, this.tempDirectory, this.destination, this.downloadToPath);
    }

    public final ImmutableDownloadPackage withDistribution(StateID<Distribution> value) {
        if (this.distribution == value) {
            return this;
        }
        StateID<Distribution> newValue = Objects.requireNonNull(value, "distribution");
        return new ImmutableDownloadPackage(this.transitionLabel, this.name, this.downloadCache, this.progressListener, this.downloadConfig, newValue, this.distPackage, this.tempDirectory, this.destination, this.downloadToPath);
    }

    public final ImmutableDownloadPackage withDistPackage(StateID<Package> value) {
        if (this.distPackage == value) {
            return this;
        }
        StateID<Package> newValue = Objects.requireNonNull(value, "distPackage");
        return new ImmutableDownloadPackage(this.transitionLabel, this.name, this.downloadCache, this.progressListener, this.downloadConfig, this.distribution, newValue, this.tempDirectory, this.destination, this.downloadToPath);
    }

    public final ImmutableDownloadPackage withTempDirectory(StateID<TempDir> value) {
        if (this.tempDirectory == value) {
            return this;
        }
        StateID<TempDir> newValue = Objects.requireNonNull(value, "tempDirectory");
        return new ImmutableDownloadPackage(this.transitionLabel, this.name, this.downloadCache, this.progressListener, this.downloadConfig, this.distribution, this.distPackage, newValue, this.destination, this.downloadToPath);
    }

    public final ImmutableDownloadPackage withDestination(StateID<Archive> value) {
        if (this.destination == value) {
            return this;
        }
        StateID<Archive> newValue = Objects.requireNonNull(value, "destination");
        return new ImmutableDownloadPackage(this.transitionLabel, this.name, this.downloadCache, this.progressListener, this.downloadConfig, this.distribution, this.distPackage, this.tempDirectory, newValue, this.downloadToPath);
    }

    public final ImmutableDownloadPackage withDownloadToPath(DownloadToPath value) {
        if (this.downloadToPath == value) {
            return this;
        }
        DownloadToPath newValue = Objects.requireNonNull(value, "downloadToPath");
        return new ImmutableDownloadPackage(this.transitionLabel, this.name, this.downloadCache, this.progressListener, this.downloadConfig, this.distribution, this.distPackage, this.tempDirectory, this.destination, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDownloadPackage && this.equalTo(0, (ImmutableDownloadPackage)another);
    }

    private boolean equalTo(int synthetic, ImmutableDownloadPackage another) {
        return this.transitionLabel.equals(another.transitionLabel) && this.name.equals(another.name) && this.downloadCache.equals(another.downloadCache) && this.progressListener.equals(another.progressListener) && this.downloadConfig.equals(another.downloadConfig) && this.distribution.equals(another.distribution) && this.distPackage.equals(another.distPackage) && this.tempDirectory.equals(another.tempDirectory) && this.destination.equals(another.destination) && this.downloadToPath.equals(another.downloadToPath);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.transitionLabel.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.downloadCache.hashCode();
        h += (h << 5) + this.progressListener.hashCode();
        h += (h << 5) + this.downloadConfig.hashCode();
        h += (h << 5) + this.distribution.hashCode();
        h += (h << 5) + this.distPackage.hashCode();
        h += (h << 5) + this.tempDirectory.hashCode();
        h += (h << 5) + this.destination.hashCode();
        h += (h << 5) + this.downloadToPath.hashCode();
        return h;
    }

    public String toString() {
        return "DownloadPackage{transitionLabel=" + this.transitionLabel + ", name=" + this.name + ", downloadCache=" + this.downloadCache + ", progressListener=" + this.progressListener + ", downloadConfig=" + this.downloadConfig + ", distribution=" + this.distribution + ", distPackage=" + this.distPackage + ", tempDirectory=" + this.tempDirectory + ", destination=" + this.destination + ", downloadToPath=" + this.downloadToPath + "}";
    }

    public static ImmutableDownloadPackage copyOf(DownloadPackage instance) {
        if (instance instanceof ImmutableDownloadPackage) {
            return (ImmutableDownloadPackage)instance;
        }
        return ImmutableDownloadPackage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String transitionLabel;
        private StateID<Name> name;
        private StateID<DownloadCache> downloadCache;
        private StateID<ProgressListener> progressListener;
        private DownloadConfig downloadConfig;
        private StateID<Distribution> distribution;
        private StateID<Package> distPackage;
        private StateID<TempDir> tempDirectory;
        private StateID<Archive> destination;
        private DownloadToPath downloadToPath;

        private Builder() {
        }

        public final Builder from(DownloadPackage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(HasLabel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            DownloadPackage instance;
            long bits = 0L;
            if (object instanceof DownloadPackage) {
                instance = (DownloadPackage)object;
                this.progressListener(instance.progressListener());
                this.tempDirectory(instance.tempDirectory());
                this.downloadConfig(instance.downloadConfig());
                this.downloadToPath(instance.downloadToPath());
                if ((bits & 1L) == 0L) {
                    this.transitionLabel(instance.transitionLabel());
                    bits |= 1L;
                }
                this.destination(instance.destination());
                this.name(instance.name());
                this.downloadCache(instance.downloadCache());
                this.distPackage(instance.distPackage());
                this.distribution(instance.distribution());
            }
            if (object instanceof HasLabel) {
                instance = (HasLabel)object;
                if ((bits & 1L) == 0L) {
                    this.transitionLabel(instance.transitionLabel());
                    bits |= 1L;
                }
            }
        }

        public final Builder transitionLabel(String transitionLabel) {
            this.transitionLabel = Objects.requireNonNull(transitionLabel, "transitionLabel");
            return this;
        }

        public final Builder name(StateID<Name> name) {
            this.name = Objects.requireNonNull(name, "name");
            return this;
        }

        public final Builder downloadCache(StateID<DownloadCache> downloadCache) {
            this.downloadCache = Objects.requireNonNull(downloadCache, "downloadCache");
            return this;
        }

        public final Builder progressListener(StateID<ProgressListener> progressListener) {
            this.progressListener = Objects.requireNonNull(progressListener, "progressListener");
            return this;
        }

        public final Builder downloadConfig(DownloadConfig downloadConfig) {
            this.downloadConfig = Objects.requireNonNull(downloadConfig, "downloadConfig");
            return this;
        }

        public final Builder distribution(StateID<Distribution> distribution) {
            this.distribution = Objects.requireNonNull(distribution, "distribution");
            return this;
        }

        public final Builder distPackage(StateID<Package> distPackage) {
            this.distPackage = Objects.requireNonNull(distPackage, "distPackage");
            return this;
        }

        public final Builder tempDirectory(StateID<TempDir> tempDirectory) {
            this.tempDirectory = Objects.requireNonNull(tempDirectory, "tempDirectory");
            return this;
        }

        public final Builder destination(StateID<Archive> destination) {
            this.destination = Objects.requireNonNull(destination, "destination");
            return this;
        }

        public final Builder downloadToPath(DownloadToPath downloadToPath) {
            this.downloadToPath = Objects.requireNonNull(downloadToPath, "downloadToPath");
            return this;
        }

        public ImmutableDownloadPackage build() {
            return new ImmutableDownloadPackage(this);
        }
    }

    private final class InitShim {
        private byte transitionLabelBuildStage = 0;
        private String transitionLabel;
        private byte nameBuildStage = 0;
        private StateID<Name> name;
        private byte downloadCacheBuildStage = 0;
        private StateID<DownloadCache> downloadCache;
        private byte progressListenerBuildStage = 0;
        private StateID<ProgressListener> progressListener;
        private byte downloadConfigBuildStage = 0;
        private DownloadConfig downloadConfig;
        private byte distributionBuildStage = 0;
        private StateID<Distribution> distribution;
        private byte distPackageBuildStage = 0;
        private StateID<Package> distPackage;
        private byte tempDirectoryBuildStage = 0;
        private StateID<TempDir> tempDirectory;
        private byte destinationBuildStage = 0;
        private StateID<Archive> destination;
        private byte downloadToPathBuildStage = 0;
        private DownloadToPath downloadToPath;

        private InitShim() {
        }

        String transitionLabel() {
            if (this.transitionLabelBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.transitionLabelBuildStage == 0) {
                this.transitionLabelBuildStage = (byte)-1;
                this.transitionLabel = Objects.requireNonNull(ImmutableDownloadPackage.super.transitionLabel(), "transitionLabel");
                this.transitionLabelBuildStage = 1;
            }
            return this.transitionLabel;
        }

        void transitionLabel(String transitionLabel) {
            this.transitionLabel = transitionLabel;
            this.transitionLabelBuildStage = 1;
        }

        StateID<Name> name() {
            if (this.nameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nameBuildStage == 0) {
                this.nameBuildStage = (byte)-1;
                this.name = Objects.requireNonNull(ImmutableDownloadPackage.super.name(), "name");
                this.nameBuildStage = 1;
            }
            return this.name;
        }

        void name(StateID<Name> name) {
            this.name = name;
            this.nameBuildStage = 1;
        }

        StateID<DownloadCache> downloadCache() {
            if (this.downloadCacheBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.downloadCacheBuildStage == 0) {
                this.downloadCacheBuildStage = (byte)-1;
                this.downloadCache = Objects.requireNonNull(ImmutableDownloadPackage.super.downloadCache(), "downloadCache");
                this.downloadCacheBuildStage = 1;
            }
            return this.downloadCache;
        }

        void downloadCache(StateID<DownloadCache> downloadCache) {
            this.downloadCache = downloadCache;
            this.downloadCacheBuildStage = 1;
        }

        StateID<ProgressListener> progressListener() {
            if (this.progressListenerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.progressListenerBuildStage == 0) {
                this.progressListenerBuildStage = (byte)-1;
                this.progressListener = Objects.requireNonNull(ImmutableDownloadPackage.super.progressListener(), "progressListener");
                this.progressListenerBuildStage = 1;
            }
            return this.progressListener;
        }

        void progressListener(StateID<ProgressListener> progressListener) {
            this.progressListener = progressListener;
            this.progressListenerBuildStage = 1;
        }

        DownloadConfig downloadConfig() {
            if (this.downloadConfigBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.downloadConfigBuildStage == 0) {
                this.downloadConfigBuildStage = (byte)-1;
                this.downloadConfig = Objects.requireNonNull(ImmutableDownloadPackage.super.downloadConfig(), "downloadConfig");
                this.downloadConfigBuildStage = 1;
            }
            return this.downloadConfig;
        }

        void downloadConfig(DownloadConfig downloadConfig) {
            this.downloadConfig = downloadConfig;
            this.downloadConfigBuildStage = 1;
        }

        StateID<Distribution> distribution() {
            if (this.distributionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.distributionBuildStage == 0) {
                this.distributionBuildStage = (byte)-1;
                this.distribution = Objects.requireNonNull(ImmutableDownloadPackage.super.distribution(), "distribution");
                this.distributionBuildStage = 1;
            }
            return this.distribution;
        }

        void distribution(StateID<Distribution> distribution) {
            this.distribution = distribution;
            this.distributionBuildStage = 1;
        }

        StateID<Package> distPackage() {
            if (this.distPackageBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.distPackageBuildStage == 0) {
                this.distPackageBuildStage = (byte)-1;
                this.distPackage = Objects.requireNonNull(ImmutableDownloadPackage.super.distPackage(), "distPackage");
                this.distPackageBuildStage = 1;
            }
            return this.distPackage;
        }

        void distPackage(StateID<Package> distPackage) {
            this.distPackage = distPackage;
            this.distPackageBuildStage = 1;
        }

        StateID<TempDir> tempDirectory() {
            if (this.tempDirectoryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tempDirectoryBuildStage == 0) {
                this.tempDirectoryBuildStage = (byte)-1;
                this.tempDirectory = Objects.requireNonNull(ImmutableDownloadPackage.super.tempDirectory(), "tempDirectory");
                this.tempDirectoryBuildStage = 1;
            }
            return this.tempDirectory;
        }

        void tempDirectory(StateID<TempDir> tempDirectory) {
            this.tempDirectory = tempDirectory;
            this.tempDirectoryBuildStage = 1;
        }

        StateID<Archive> destination() {
            if (this.destinationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.destinationBuildStage == 0) {
                this.destinationBuildStage = (byte)-1;
                this.destination = Objects.requireNonNull(ImmutableDownloadPackage.super.destination(), "destination");
                this.destinationBuildStage = 1;
            }
            return this.destination;
        }

        void destination(StateID<Archive> destination) {
            this.destination = destination;
            this.destinationBuildStage = 1;
        }

        DownloadToPath downloadToPath() {
            if (this.downloadToPathBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.downloadToPathBuildStage == 0) {
                this.downloadToPathBuildStage = (byte)-1;
                this.downloadToPath = Objects.requireNonNull(ImmutableDownloadPackage.super.downloadToPath(), "downloadToPath");
                this.downloadToPathBuildStage = 1;
            }
            return this.downloadToPath;
        }

        void downloadToPath(DownloadToPath downloadToPath) {
            this.downloadToPath = downloadToPath;
            this.downloadToPathBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.transitionLabelBuildStage == -1) {
                attributes.add("transitionLabel");
            }
            if (this.nameBuildStage == -1) {
                attributes.add("name");
            }
            if (this.downloadCacheBuildStage == -1) {
                attributes.add("downloadCache");
            }
            if (this.progressListenerBuildStage == -1) {
                attributes.add("progressListener");
            }
            if (this.downloadConfigBuildStage == -1) {
                attributes.add("downloadConfig");
            }
            if (this.distributionBuildStage == -1) {
                attributes.add("distribution");
            }
            if (this.distPackageBuildStage == -1) {
                attributes.add("distPackage");
            }
            if (this.tempDirectoryBuildStage == -1) {
                attributes.add("tempDirectory");
            }
            if (this.destinationBuildStage == -1) {
                attributes.add("destination");
            }
            if (this.downloadToPathBuildStage == -1) {
                attributes.add("downloadToPath");
            }
            return "Cannot build DownloadPackage, attribute initializers form cycle " + attributes;
        }
    }
}

