package de.flapdoodle.embed.process.transitions;

import de.flapdoodle.embed.process.io.directories.TempDir;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link InitTempDirectory}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableInitTempDirectory.builder()}.
 */
@Generated(from = "InitTempDirectory", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutableInitTempDirectory
    extends InitTempDirectory {
  private final TempDir tempDir;

  private ImmutableInitTempDirectory(ImmutableInitTempDirectory.Builder builder) {
    this.tempDir = builder.tempDir != null
        ? builder.tempDir
        : Objects.requireNonNull(super.tempDir(), "tempDir");
  }

  private ImmutableInitTempDirectory(TempDir tempDir) {
    this.tempDir = tempDir;
  }

  /**
   * @return The value of the {@code tempDir} attribute
   */
  @Override
  protected TempDir tempDir() {
    return tempDir;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InitTempDirectory#tempDir() tempDir} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tempDir
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInitTempDirectory withTempDir(TempDir value) {
    if (this.tempDir == value) return this;
    TempDir newValue = Objects.requireNonNull(value, "tempDir");
    return new ImmutableInitTempDirectory(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableInitTempDirectory} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableInitTempDirectory
        && equalTo(0, (ImmutableInitTempDirectory) another);
  }

  private boolean equalTo(int synthetic, ImmutableInitTempDirectory another) {
    return tempDir.equals(another.tempDir);
  }

  /**
   * Computes a hash code from attributes: {@code tempDir}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + tempDir.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code InitTempDirectory} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "InitTempDirectory{"
        + "tempDir=" + tempDir
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link InitTempDirectory} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable InitTempDirectory instance
   */
  public static ImmutableInitTempDirectory copyOf(InitTempDirectory instance) {
    if (instance instanceof ImmutableInitTempDirectory) {
      return (ImmutableInitTempDirectory) instance;
    }
    return ImmutableInitTempDirectory.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableInitTempDirectory ImmutableInitTempDirectory}.
   * <pre>
   * ImmutableInitTempDirectory.builder()
   *    .tempDir(de.flapdoodle.embed.process.io.directories.TempDir) // optional {@link InitTempDirectory#tempDir() tempDir}
   *    .build();
   * </pre>
   * @return A new ImmutableInitTempDirectory builder
   */
  public static ImmutableInitTempDirectory.Builder builder() {
    return new ImmutableInitTempDirectory.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableInitTempDirectory ImmutableInitTempDirectory}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "InitTempDirectory", generator = "Immutables")
  public static final class Builder {
    private TempDir tempDir;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code InitTempDirectory} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(InitTempDirectory instance) {
      Objects.requireNonNull(instance, "instance");
      tempDir(instance.tempDir());
      return this;
    }

    /**
     * Initializes the value for the {@link InitTempDirectory#tempDir() tempDir} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link InitTempDirectory#tempDir() tempDir}.</em>
     * @param tempDir The value for tempDir 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tempDir(TempDir tempDir) {
      this.tempDir = Objects.requireNonNull(tempDir, "tempDir");
      return this;
    }

    /**
     * Builds a new {@link ImmutableInitTempDirectory ImmutableInitTempDirectory}.
     * @return An immutable instance of InitTempDirectory
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableInitTempDirectory build() {
      return new ImmutableInitTempDirectory(this);
    }
  }
}
