/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.transitions;

import de.flapdoodle.embed.process.archives.ExtractedFileSet;
import de.flapdoodle.embed.process.config.SupportConfig;
import de.flapdoodle.embed.process.config.store.Package;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.distribution.Version;
import de.flapdoodle.embed.process.io.ProcessOutput;
import de.flapdoodle.embed.process.io.directories.PersistentDir;
import de.flapdoodle.embed.process.io.directories.TempDir;
import de.flapdoodle.embed.process.io.progress.ProgressListener;
import de.flapdoodle.embed.process.store.DownloadCache;
import de.flapdoodle.embed.process.store.ExtractedFileSetStore;
import de.flapdoodle.embed.process.transitions.ProcessFactory;
import de.flapdoodle.embed.process.types.Archive;
import de.flapdoodle.embed.process.types.ExecutedProcess;
import de.flapdoodle.embed.process.types.Name;
import de.flapdoodle.embed.process.types.ProcessArguments;
import de.flapdoodle.embed.process.types.ProcessConfig;
import de.flapdoodle.embed.process.types.ProcessEnv;
import de.flapdoodle.embed.process.types.ProcessWorkingDir;
import de.flapdoodle.reverse.Transition;
import de.flapdoodle.reverse.transitions.Start;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;
import org.immutables.value.Generated;

@Generated(from="ProcessFactory", generator="Immutables")
public final class ImmutableProcessFactory
extends ProcessFactory {
    private final Version version;
    private final Transition<Name> name;
    private final Transition<TempDir> initTempDirectory;
    private final Transition<ProcessWorkingDir> processWorkingDir;
    private final Start<ProcessConfig> processConfig;
    private final Transition<ProcessEnv> processEnv;
    private final Transition<ProcessArguments> processArguments;
    private final Transition<ProcessOutput> processOutput;
    private final Transition<ProgressListener> progressListener;
    private final Transition<SupportConfig> supportConfig;
    private final Transition<PersistentDir> persistentBaseDir;
    private final Transition<DownloadCache> downloadCache;
    private final Transition<ExtractedFileSetStore> extractedFileSetStore;
    private final Transition<ExtractedFileSet> extractPackage;
    private final Transition<Archive> downloadPackage;
    private final Transition<Distribution> distribution;
    private final Function<Distribution, Package> packageInformation;
    private final Transition<ExecutedProcess> executer;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableProcessFactory(Builder builder) {
        this.version = builder.version;
        this.name = builder.name;
        this.processArguments = builder.processArguments;
        this.persistentBaseDir = builder.persistentBaseDir;
        this.packageInformation = builder.packageInformation;
        if (builder.initTempDirectory != null) {
            this.initShim.initTempDirectory((Transition<TempDir>)builder.initTempDirectory);
        }
        if (builder.processWorkingDir != null) {
            this.initShim.processWorkingDir((Transition<ProcessWorkingDir>)builder.processWorkingDir);
        }
        if (builder.processConfig != null) {
            this.initShim.processConfig((Start<ProcessConfig>)builder.processConfig);
        }
        if (builder.processEnv != null) {
            this.initShim.processEnv((Transition<ProcessEnv>)builder.processEnv);
        }
        if (builder.processOutput != null) {
            this.initShim.processOutput((Transition<ProcessOutput>)builder.processOutput);
        }
        if (builder.progressListener != null) {
            this.initShim.progressListener((Transition<ProgressListener>)builder.progressListener);
        }
        if (builder.supportConfig != null) {
            this.initShim.supportConfig((Transition<SupportConfig>)builder.supportConfig);
        }
        if (builder.downloadCache != null) {
            this.initShim.downloadCache((Transition<DownloadCache>)builder.downloadCache);
        }
        if (builder.extractedFileSetStore != null) {
            this.initShim.extractedFileSetStore((Transition<ExtractedFileSetStore>)builder.extractedFileSetStore);
        }
        if (builder.extractPackage != null) {
            this.initShim.extractPackage((Transition<ExtractedFileSet>)builder.extractPackage);
        }
        if (builder.downloadPackage != null) {
            this.initShim.downloadPackage((Transition<Archive>)builder.downloadPackage);
        }
        if (builder.distribution != null) {
            this.initShim.distribution((Transition<Distribution>)builder.distribution);
        }
        if (builder.executer != null) {
            this.initShim.executer((Transition<ExecutedProcess>)builder.executer);
        }
        this.initTempDirectory = this.initShim.initTempDirectory();
        this.processWorkingDir = this.initShim.processWorkingDir();
        this.processConfig = this.initShim.processConfig();
        this.processEnv = this.initShim.processEnv();
        this.processOutput = this.initShim.processOutput();
        this.progressListener = this.initShim.progressListener();
        this.supportConfig = this.initShim.supportConfig();
        this.downloadCache = this.initShim.downloadCache();
        this.extractedFileSetStore = this.initShim.extractedFileSetStore();
        this.extractPackage = this.initShim.extractPackage();
        this.downloadPackage = this.initShim.downloadPackage();
        this.distribution = this.initShim.distribution();
        this.executer = this.initShim.executer();
        this.initShim = null;
    }

    private ImmutableProcessFactory(Version version, Transition<Name> name, Transition<TempDir> initTempDirectory, Transition<ProcessWorkingDir> processWorkingDir, Start<ProcessConfig> processConfig, Transition<ProcessEnv> processEnv, Transition<ProcessArguments> processArguments, Transition<ProcessOutput> processOutput, Transition<ProgressListener> progressListener, Transition<SupportConfig> supportConfig, Transition<PersistentDir> persistentBaseDir, Transition<DownloadCache> downloadCache, Transition<ExtractedFileSetStore> extractedFileSetStore, Transition<ExtractedFileSet> extractPackage, Transition<Archive> downloadPackage, Transition<Distribution> distribution, Function<Distribution, Package> packageInformation, Transition<ExecutedProcess> executer) {
        this.version = version;
        this.name = name;
        this.initTempDirectory = initTempDirectory;
        this.processWorkingDir = processWorkingDir;
        this.processConfig = processConfig;
        this.processEnv = processEnv;
        this.processArguments = processArguments;
        this.processOutput = processOutput;
        this.progressListener = progressListener;
        this.supportConfig = supportConfig;
        this.persistentBaseDir = persistentBaseDir;
        this.downloadCache = downloadCache;
        this.extractedFileSetStore = extractedFileSetStore;
        this.extractPackage = extractPackage;
        this.downloadPackage = downloadPackage;
        this.distribution = distribution;
        this.packageInformation = packageInformation;
        this.executer = executer;
        this.initShim = null;
    }

    @Override
    public Version version() {
        return this.version;
    }

    @Override
    protected Transition<Name> name() {
        return this.name;
    }

    @Override
    protected Transition<TempDir> initTempDirectory() {
        InitShim shim = this.initShim;
        return shim != null ? shim.initTempDirectory() : this.initTempDirectory;
    }

    @Override
    protected Transition<ProcessWorkingDir> processWorkingDir() {
        InitShim shim = this.initShim;
        return shim != null ? shim.processWorkingDir() : this.processWorkingDir;
    }

    @Override
    protected Start<ProcessConfig> processConfig() {
        InitShim shim = this.initShim;
        return shim != null ? shim.processConfig() : this.processConfig;
    }

    @Override
    protected Transition<ProcessEnv> processEnv() {
        InitShim shim = this.initShim;
        return shim != null ? shim.processEnv() : this.processEnv;
    }

    @Override
    protected Transition<ProcessArguments> processArguments() {
        return this.processArguments;
    }

    @Override
    protected Transition<ProcessOutput> processOutput() {
        InitShim shim = this.initShim;
        return shim != null ? shim.processOutput() : this.processOutput;
    }

    @Override
    protected Transition<ProgressListener> progressListener() {
        InitShim shim = this.initShim;
        return shim != null ? shim.progressListener() : this.progressListener;
    }

    @Override
    protected Transition<SupportConfig> supportConfig() {
        InitShim shim = this.initShim;
        return shim != null ? shim.supportConfig() : this.supportConfig;
    }

    @Override
    protected Transition<PersistentDir> persistentBaseDir() {
        return this.persistentBaseDir;
    }

    @Override
    protected Transition<DownloadCache> downloadCache() {
        InitShim shim = this.initShim;
        return shim != null ? shim.downloadCache() : this.downloadCache;
    }

    @Override
    protected Transition<ExtractedFileSetStore> extractedFileSetStore() {
        InitShim shim = this.initShim;
        return shim != null ? shim.extractedFileSetStore() : this.extractedFileSetStore;
    }

    @Override
    protected Transition<ExtractedFileSet> extractPackage() {
        InitShim shim = this.initShim;
        return shim != null ? shim.extractPackage() : this.extractPackage;
    }

    @Override
    protected Transition<Archive> downloadPackage() {
        InitShim shim = this.initShim;
        return shim != null ? shim.downloadPackage() : this.downloadPackage;
    }

    @Override
    protected Transition<Distribution> distribution() {
        InitShim shim = this.initShim;
        return shim != null ? shim.distribution() : this.distribution;
    }

    @Override
    protected Function<Distribution, Package> packageInformation() {
        return this.packageInformation;
    }

    @Override
    protected Transition<ExecutedProcess> executer() {
        InitShim shim = this.initShim;
        return shim != null ? shim.executer() : this.executer;
    }

    public final ImmutableProcessFactory withVersion(Version value) {
        if (this.version == value) {
            return this;
        }
        Version newValue = Objects.requireNonNull(value, "version");
        return new ImmutableProcessFactory(newValue, this.name, this.initTempDirectory, this.processWorkingDir, this.processConfig, this.processEnv, this.processArguments, this.processOutput, this.progressListener, this.supportConfig, this.persistentBaseDir, this.downloadCache, this.extractedFileSetStore, this.extractPackage, this.downloadPackage, this.distribution, this.packageInformation, this.executer);
    }

    public final ImmutableProcessFactory withName(Transition<Name> value) {
        if (this.name == value) {
            return this;
        }
        Transition<Name> newValue = Objects.requireNonNull(value, "name");
        return new ImmutableProcessFactory(this.version, newValue, this.initTempDirectory, this.processWorkingDir, this.processConfig, this.processEnv, this.processArguments, this.processOutput, this.progressListener, this.supportConfig, this.persistentBaseDir, this.downloadCache, this.extractedFileSetStore, this.extractPackage, this.downloadPackage, this.distribution, this.packageInformation, this.executer);
    }

    public final ImmutableProcessFactory withInitTempDirectory(Transition<TempDir> value) {
        if (this.initTempDirectory == value) {
            return this;
        }
        Transition<TempDir> newValue = Objects.requireNonNull(value, "initTempDirectory");
        return new ImmutableProcessFactory(this.version, this.name, newValue, this.processWorkingDir, this.processConfig, this.processEnv, this.processArguments, this.processOutput, this.progressListener, this.supportConfig, this.persistentBaseDir, this.downloadCache, this.extractedFileSetStore, this.extractPackage, this.downloadPackage, this.distribution, this.packageInformation, this.executer);
    }

    public final ImmutableProcessFactory withProcessWorkingDir(Transition<ProcessWorkingDir> value) {
        if (this.processWorkingDir == value) {
            return this;
        }
        Transition<ProcessWorkingDir> newValue = Objects.requireNonNull(value, "processWorkingDir");
        return new ImmutableProcessFactory(this.version, this.name, this.initTempDirectory, newValue, this.processConfig, this.processEnv, this.processArguments, this.processOutput, this.progressListener, this.supportConfig, this.persistentBaseDir, this.downloadCache, this.extractedFileSetStore, this.extractPackage, this.downloadPackage, this.distribution, this.packageInformation, this.executer);
    }

    public final ImmutableProcessFactory withProcessConfig(Start<ProcessConfig> value) {
        if (this.processConfig == value) {
            return this;
        }
        Start<ProcessConfig> newValue = Objects.requireNonNull(value, "processConfig");
        return new ImmutableProcessFactory(this.version, this.name, this.initTempDirectory, this.processWorkingDir, newValue, this.processEnv, this.processArguments, this.processOutput, this.progressListener, this.supportConfig, this.persistentBaseDir, this.downloadCache, this.extractedFileSetStore, this.extractPackage, this.downloadPackage, this.distribution, this.packageInformation, this.executer);
    }

    public final ImmutableProcessFactory withProcessEnv(Transition<ProcessEnv> value) {
        if (this.processEnv == value) {
            return this;
        }
        Transition<ProcessEnv> newValue = Objects.requireNonNull(value, "processEnv");
        return new ImmutableProcessFactory(this.version, this.name, this.initTempDirectory, this.processWorkingDir, this.processConfig, newValue, this.processArguments, this.processOutput, this.progressListener, this.supportConfig, this.persistentBaseDir, this.downloadCache, this.extractedFileSetStore, this.extractPackage, this.downloadPackage, this.distribution, this.packageInformation, this.executer);
    }

    public final ImmutableProcessFactory withProcessArguments(Transition<ProcessArguments> value) {
        if (this.processArguments == value) {
            return this;
        }
        Transition<ProcessArguments> newValue = Objects.requireNonNull(value, "processArguments");
        return new ImmutableProcessFactory(this.version, this.name, this.initTempDirectory, this.processWorkingDir, this.processConfig, this.processEnv, newValue, this.processOutput, this.progressListener, this.supportConfig, this.persistentBaseDir, this.downloadCache, this.extractedFileSetStore, this.extractPackage, this.downloadPackage, this.distribution, this.packageInformation, this.executer);
    }

    public final ImmutableProcessFactory withProcessOutput(Transition<ProcessOutput> value) {
        if (this.processOutput == value) {
            return this;
        }
        Transition<ProcessOutput> newValue = Objects.requireNonNull(value, "processOutput");
        return new ImmutableProcessFactory(this.version, this.name, this.initTempDirectory, this.processWorkingDir, this.processConfig, this.processEnv, this.processArguments, newValue, this.progressListener, this.supportConfig, this.persistentBaseDir, this.downloadCache, this.extractedFileSetStore, this.extractPackage, this.downloadPackage, this.distribution, this.packageInformation, this.executer);
    }

    public final ImmutableProcessFactory withProgressListener(Transition<ProgressListener> value) {
        if (this.progressListener == value) {
            return this;
        }
        Transition<ProgressListener> newValue = Objects.requireNonNull(value, "progressListener");
        return new ImmutableProcessFactory(this.version, this.name, this.initTempDirectory, this.processWorkingDir, this.processConfig, this.processEnv, this.processArguments, this.processOutput, newValue, this.supportConfig, this.persistentBaseDir, this.downloadCache, this.extractedFileSetStore, this.extractPackage, this.downloadPackage, this.distribution, this.packageInformation, this.executer);
    }

    public final ImmutableProcessFactory withSupportConfig(Transition<SupportConfig> value) {
        if (this.supportConfig == value) {
            return this;
        }
        Transition<SupportConfig> newValue = Objects.requireNonNull(value, "supportConfig");
        return new ImmutableProcessFactory(this.version, this.name, this.initTempDirectory, this.processWorkingDir, this.processConfig, this.processEnv, this.processArguments, this.processOutput, this.progressListener, newValue, this.persistentBaseDir, this.downloadCache, this.extractedFileSetStore, this.extractPackage, this.downloadPackage, this.distribution, this.packageInformation, this.executer);
    }

    public final ImmutableProcessFactory withPersistentBaseDir(Transition<PersistentDir> value) {
        if (this.persistentBaseDir == value) {
            return this;
        }
        Transition<PersistentDir> newValue = Objects.requireNonNull(value, "persistentBaseDir");
        return new ImmutableProcessFactory(this.version, this.name, this.initTempDirectory, this.processWorkingDir, this.processConfig, this.processEnv, this.processArguments, this.processOutput, this.progressListener, this.supportConfig, newValue, this.downloadCache, this.extractedFileSetStore, this.extractPackage, this.downloadPackage, this.distribution, this.packageInformation, this.executer);
    }

    public final ImmutableProcessFactory withDownloadCache(Transition<DownloadCache> value) {
        if (this.downloadCache == value) {
            return this;
        }
        Transition<DownloadCache> newValue = Objects.requireNonNull(value, "downloadCache");
        return new ImmutableProcessFactory(this.version, this.name, this.initTempDirectory, this.processWorkingDir, this.processConfig, this.processEnv, this.processArguments, this.processOutput, this.progressListener, this.supportConfig, this.persistentBaseDir, newValue, this.extractedFileSetStore, this.extractPackage, this.downloadPackage, this.distribution, this.packageInformation, this.executer);
    }

    public final ImmutableProcessFactory withExtractedFileSetStore(Transition<ExtractedFileSetStore> value) {
        if (this.extractedFileSetStore == value) {
            return this;
        }
        Transition<ExtractedFileSetStore> newValue = Objects.requireNonNull(value, "extractedFileSetStore");
        return new ImmutableProcessFactory(this.version, this.name, this.initTempDirectory, this.processWorkingDir, this.processConfig, this.processEnv, this.processArguments, this.processOutput, this.progressListener, this.supportConfig, this.persistentBaseDir, this.downloadCache, newValue, this.extractPackage, this.downloadPackage, this.distribution, this.packageInformation, this.executer);
    }

    public final ImmutableProcessFactory withExtractPackage(Transition<ExtractedFileSet> value) {
        if (this.extractPackage == value) {
            return this;
        }
        Transition<ExtractedFileSet> newValue = Objects.requireNonNull(value, "extractPackage");
        return new ImmutableProcessFactory(this.version, this.name, this.initTempDirectory, this.processWorkingDir, this.processConfig, this.processEnv, this.processArguments, this.processOutput, this.progressListener, this.supportConfig, this.persistentBaseDir, this.downloadCache, this.extractedFileSetStore, newValue, this.downloadPackage, this.distribution, this.packageInformation, this.executer);
    }

    public final ImmutableProcessFactory withDownloadPackage(Transition<Archive> value) {
        if (this.downloadPackage == value) {
            return this;
        }
        Transition<Archive> newValue = Objects.requireNonNull(value, "downloadPackage");
        return new ImmutableProcessFactory(this.version, this.name, this.initTempDirectory, this.processWorkingDir, this.processConfig, this.processEnv, this.processArguments, this.processOutput, this.progressListener, this.supportConfig, this.persistentBaseDir, this.downloadCache, this.extractedFileSetStore, this.extractPackage, newValue, this.distribution, this.packageInformation, this.executer);
    }

    public final ImmutableProcessFactory withDistribution(Transition<Distribution> value) {
        if (this.distribution == value) {
            return this;
        }
        Transition<Distribution> newValue = Objects.requireNonNull(value, "distribution");
        return new ImmutableProcessFactory(this.version, this.name, this.initTempDirectory, this.processWorkingDir, this.processConfig, this.processEnv, this.processArguments, this.processOutput, this.progressListener, this.supportConfig, this.persistentBaseDir, this.downloadCache, this.extractedFileSetStore, this.extractPackage, this.downloadPackage, newValue, this.packageInformation, this.executer);
    }

    public final ImmutableProcessFactory withPackageInformation(Function<Distribution, Package> value) {
        if (this.packageInformation == value) {
            return this;
        }
        Function<Distribution, Package> newValue = Objects.requireNonNull(value, "packageInformation");
        return new ImmutableProcessFactory(this.version, this.name, this.initTempDirectory, this.processWorkingDir, this.processConfig, this.processEnv, this.processArguments, this.processOutput, this.progressListener, this.supportConfig, this.persistentBaseDir, this.downloadCache, this.extractedFileSetStore, this.extractPackage, this.downloadPackage, this.distribution, newValue, this.executer);
    }

    public final ImmutableProcessFactory withExecuter(Transition<ExecutedProcess> value) {
        if (this.executer == value) {
            return this;
        }
        Transition<ExecutedProcess> newValue = Objects.requireNonNull(value, "executer");
        return new ImmutableProcessFactory(this.version, this.name, this.initTempDirectory, this.processWorkingDir, this.processConfig, this.processEnv, this.processArguments, this.processOutput, this.progressListener, this.supportConfig, this.persistentBaseDir, this.downloadCache, this.extractedFileSetStore, this.extractPackage, this.downloadPackage, this.distribution, this.packageInformation, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProcessFactory && this.equalTo((ImmutableProcessFactory)another);
    }

    private boolean equalTo(ImmutableProcessFactory another) {
        return this.version.equals(another.version) && this.name.equals(another.name) && this.initTempDirectory.equals(another.initTempDirectory) && this.processWorkingDir.equals(another.processWorkingDir) && this.processConfig.equals(another.processConfig) && this.processEnv.equals(another.processEnv) && this.processArguments.equals(another.processArguments) && this.processOutput.equals(another.processOutput) && this.progressListener.equals(another.progressListener) && this.supportConfig.equals(another.supportConfig) && this.persistentBaseDir.equals(another.persistentBaseDir) && this.downloadCache.equals(another.downloadCache) && this.extractedFileSetStore.equals(another.extractedFileSetStore) && this.extractPackage.equals(another.extractPackage) && this.downloadPackage.equals(another.downloadPackage) && this.distribution.equals(another.distribution) && this.packageInformation.equals(another.packageInformation) && this.executer.equals(another.executer);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.initTempDirectory.hashCode();
        h += (h << 5) + this.processWorkingDir.hashCode();
        h += (h << 5) + this.processConfig.hashCode();
        h += (h << 5) + this.processEnv.hashCode();
        h += (h << 5) + this.processArguments.hashCode();
        h += (h << 5) + this.processOutput.hashCode();
        h += (h << 5) + this.progressListener.hashCode();
        h += (h << 5) + this.supportConfig.hashCode();
        h += (h << 5) + this.persistentBaseDir.hashCode();
        h += (h << 5) + this.downloadCache.hashCode();
        h += (h << 5) + this.extractedFileSetStore.hashCode();
        h += (h << 5) + this.extractPackage.hashCode();
        h += (h << 5) + this.downloadPackage.hashCode();
        h += (h << 5) + this.distribution.hashCode();
        h += (h << 5) + this.packageInformation.hashCode();
        h += (h << 5) + this.executer.hashCode();
        return h;
    }

    public String toString() {
        return "ProcessFactory{version=" + this.version + ", name=" + this.name + ", initTempDirectory=" + this.initTempDirectory + ", processWorkingDir=" + this.processWorkingDir + ", processConfig=" + this.processConfig + ", processEnv=" + this.processEnv + ", processArguments=" + this.processArguments + ", processOutput=" + this.processOutput + ", progressListener=" + this.progressListener + ", supportConfig=" + this.supportConfig + ", persistentBaseDir=" + this.persistentBaseDir + ", downloadCache=" + this.downloadCache + ", extractedFileSetStore=" + this.extractedFileSetStore + ", extractPackage=" + this.extractPackage + ", downloadPackage=" + this.downloadPackage + ", distribution=" + this.distribution + ", packageInformation=" + this.packageInformation + ", executer=" + this.executer + "}";
    }

    public static ImmutableProcessFactory copyOf(ProcessFactory instance) {
        if (instance instanceof ImmutableProcessFactory) {
            return (ImmutableProcessFactory)instance;
        }
        return ImmutableProcessFactory.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ProcessFactory", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_VERSION = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_PROCESS_ARGUMENTS = 4L;
        private static final long INIT_BIT_PERSISTENT_BASE_DIR = 8L;
        private static final long INIT_BIT_PACKAGE_INFORMATION = 16L;
        private long initBits = 31L;
        private Version version;
        private Transition<Name> name;
        private Transition<TempDir> initTempDirectory;
        private Transition<ProcessWorkingDir> processWorkingDir;
        private Start<ProcessConfig> processConfig;
        private Transition<ProcessEnv> processEnv;
        private Transition<ProcessArguments> processArguments;
        private Transition<ProcessOutput> processOutput;
        private Transition<ProgressListener> progressListener;
        private Transition<SupportConfig> supportConfig;
        private Transition<PersistentDir> persistentBaseDir;
        private Transition<DownloadCache> downloadCache;
        private Transition<ExtractedFileSetStore> extractedFileSetStore;
        private Transition<ExtractedFileSet> extractPackage;
        private Transition<Archive> downloadPackage;
        private Transition<Distribution> distribution;
        private Function<Distribution, Package> packageInformation;
        private Transition<ExecutedProcess> executer;

        private Builder() {
        }

        public final Builder from(ProcessFactory instance) {
            Objects.requireNonNull(instance, "instance");
            this.version(instance.version());
            this.name(instance.name());
            this.initTempDirectory(instance.initTempDirectory());
            this.processWorkingDir(instance.processWorkingDir());
            this.processConfig(instance.processConfig());
            this.processEnv(instance.processEnv());
            this.processArguments(instance.processArguments());
            this.processOutput(instance.processOutput());
            this.progressListener(instance.progressListener());
            this.supportConfig(instance.supportConfig());
            this.persistentBaseDir(instance.persistentBaseDir());
            this.downloadCache(instance.downloadCache());
            this.extractedFileSetStore(instance.extractedFileSetStore());
            this.extractPackage(instance.extractPackage());
            this.downloadPackage(instance.downloadPackage());
            this.distribution(instance.distribution());
            this.packageInformation(instance.packageInformation());
            this.executer(instance.executer());
            return this;
        }

        public final Builder version(Version version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(Transition<Name> name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder initTempDirectory(Transition<TempDir> initTempDirectory) {
            this.initTempDirectory = Objects.requireNonNull(initTempDirectory, "initTempDirectory");
            return this;
        }

        public final Builder processWorkingDir(Transition<ProcessWorkingDir> processWorkingDir) {
            this.processWorkingDir = Objects.requireNonNull(processWorkingDir, "processWorkingDir");
            return this;
        }

        public final Builder processConfig(Start<ProcessConfig> processConfig) {
            this.processConfig = Objects.requireNonNull(processConfig, "processConfig");
            return this;
        }

        public final Builder processEnv(Transition<ProcessEnv> processEnv) {
            this.processEnv = Objects.requireNonNull(processEnv, "processEnv");
            return this;
        }

        public final Builder processArguments(Transition<ProcessArguments> processArguments) {
            this.processArguments = Objects.requireNonNull(processArguments, "processArguments");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder processOutput(Transition<ProcessOutput> processOutput) {
            this.processOutput = Objects.requireNonNull(processOutput, "processOutput");
            return this;
        }

        public final Builder progressListener(Transition<ProgressListener> progressListener) {
            this.progressListener = Objects.requireNonNull(progressListener, "progressListener");
            return this;
        }

        public final Builder supportConfig(Transition<SupportConfig> supportConfig) {
            this.supportConfig = Objects.requireNonNull(supportConfig, "supportConfig");
            return this;
        }

        public final Builder persistentBaseDir(Transition<PersistentDir> persistentBaseDir) {
            this.persistentBaseDir = Objects.requireNonNull(persistentBaseDir, "persistentBaseDir");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder downloadCache(Transition<DownloadCache> downloadCache) {
            this.downloadCache = Objects.requireNonNull(downloadCache, "downloadCache");
            return this;
        }

        public final Builder extractedFileSetStore(Transition<ExtractedFileSetStore> extractedFileSetStore) {
            this.extractedFileSetStore = Objects.requireNonNull(extractedFileSetStore, "extractedFileSetStore");
            return this;
        }

        public final Builder extractPackage(Transition<ExtractedFileSet> extractPackage) {
            this.extractPackage = Objects.requireNonNull(extractPackage, "extractPackage");
            return this;
        }

        public final Builder downloadPackage(Transition<Archive> downloadPackage) {
            this.downloadPackage = Objects.requireNonNull(downloadPackage, "downloadPackage");
            return this;
        }

        public final Builder distribution(Transition<Distribution> distribution) {
            this.distribution = Objects.requireNonNull(distribution, "distribution");
            return this;
        }

        public final Builder packageInformation(Function<Distribution, Package> packageInformation) {
            this.packageInformation = Objects.requireNonNull(packageInformation, "packageInformation");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder executer(Transition<ExecutedProcess> executer) {
            this.executer = Objects.requireNonNull(executer, "executer");
            return this;
        }

        public ImmutableProcessFactory build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableProcessFactory(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("version");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("processArguments");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("persistentBaseDir");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("packageInformation");
            }
            return "Cannot build ProcessFactory, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="ProcessFactory", generator="Immutables")
    private final class InitShim {
        private byte initTempDirectoryBuildStage = 0;
        private Transition<TempDir> initTempDirectory;
        private byte processWorkingDirBuildStage = 0;
        private Transition<ProcessWorkingDir> processWorkingDir;
        private byte processConfigBuildStage = 0;
        private Start<ProcessConfig> processConfig;
        private byte processEnvBuildStage = 0;
        private Transition<ProcessEnv> processEnv;
        private byte processOutputBuildStage = 0;
        private Transition<ProcessOutput> processOutput;
        private byte progressListenerBuildStage = 0;
        private Transition<ProgressListener> progressListener;
        private byte supportConfigBuildStage = 0;
        private Transition<SupportConfig> supportConfig;
        private byte downloadCacheBuildStage = 0;
        private Transition<DownloadCache> downloadCache;
        private byte extractedFileSetStoreBuildStage = 0;
        private Transition<ExtractedFileSetStore> extractedFileSetStore;
        private byte extractPackageBuildStage = 0;
        private Transition<ExtractedFileSet> extractPackage;
        private byte downloadPackageBuildStage = 0;
        private Transition<Archive> downloadPackage;
        private byte distributionBuildStage = 0;
        private Transition<Distribution> distribution;
        private byte executerBuildStage = 0;
        private Transition<ExecutedProcess> executer;

        private InitShim() {
        }

        Transition<TempDir> initTempDirectory() {
            if (this.initTempDirectoryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.initTempDirectoryBuildStage == 0) {
                this.initTempDirectoryBuildStage = (byte)-1;
                this.initTempDirectory = Objects.requireNonNull(ImmutableProcessFactory.super.initTempDirectory(), "initTempDirectory");
                this.initTempDirectoryBuildStage = 1;
            }
            return this.initTempDirectory;
        }

        void initTempDirectory(Transition<TempDir> initTempDirectory) {
            this.initTempDirectory = initTempDirectory;
            this.initTempDirectoryBuildStage = 1;
        }

        Transition<ProcessWorkingDir> processWorkingDir() {
            if (this.processWorkingDirBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.processWorkingDirBuildStage == 0) {
                this.processWorkingDirBuildStage = (byte)-1;
                this.processWorkingDir = Objects.requireNonNull(ImmutableProcessFactory.super.processWorkingDir(), "processWorkingDir");
                this.processWorkingDirBuildStage = 1;
            }
            return this.processWorkingDir;
        }

        void processWorkingDir(Transition<ProcessWorkingDir> processWorkingDir) {
            this.processWorkingDir = processWorkingDir;
            this.processWorkingDirBuildStage = 1;
        }

        Start<ProcessConfig> processConfig() {
            if (this.processConfigBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.processConfigBuildStage == 0) {
                this.processConfigBuildStage = (byte)-1;
                this.processConfig = Objects.requireNonNull(ImmutableProcessFactory.super.processConfig(), "processConfig");
                this.processConfigBuildStage = 1;
            }
            return this.processConfig;
        }

        void processConfig(Start<ProcessConfig> processConfig) {
            this.processConfig = processConfig;
            this.processConfigBuildStage = 1;
        }

        Transition<ProcessEnv> processEnv() {
            if (this.processEnvBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.processEnvBuildStage == 0) {
                this.processEnvBuildStage = (byte)-1;
                this.processEnv = Objects.requireNonNull(ImmutableProcessFactory.super.processEnv(), "processEnv");
                this.processEnvBuildStage = 1;
            }
            return this.processEnv;
        }

        void processEnv(Transition<ProcessEnv> processEnv) {
            this.processEnv = processEnv;
            this.processEnvBuildStage = 1;
        }

        Transition<ProcessOutput> processOutput() {
            if (this.processOutputBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.processOutputBuildStage == 0) {
                this.processOutputBuildStage = (byte)-1;
                this.processOutput = Objects.requireNonNull(ImmutableProcessFactory.super.processOutput(), "processOutput");
                this.processOutputBuildStage = 1;
            }
            return this.processOutput;
        }

        void processOutput(Transition<ProcessOutput> processOutput) {
            this.processOutput = processOutput;
            this.processOutputBuildStage = 1;
        }

        Transition<ProgressListener> progressListener() {
            if (this.progressListenerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.progressListenerBuildStage == 0) {
                this.progressListenerBuildStage = (byte)-1;
                this.progressListener = Objects.requireNonNull(ImmutableProcessFactory.super.progressListener(), "progressListener");
                this.progressListenerBuildStage = 1;
            }
            return this.progressListener;
        }

        void progressListener(Transition<ProgressListener> progressListener) {
            this.progressListener = progressListener;
            this.progressListenerBuildStage = 1;
        }

        Transition<SupportConfig> supportConfig() {
            if (this.supportConfigBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.supportConfigBuildStage == 0) {
                this.supportConfigBuildStage = (byte)-1;
                this.supportConfig = Objects.requireNonNull(ImmutableProcessFactory.super.supportConfig(), "supportConfig");
                this.supportConfigBuildStage = 1;
            }
            return this.supportConfig;
        }

        void supportConfig(Transition<SupportConfig> supportConfig) {
            this.supportConfig = supportConfig;
            this.supportConfigBuildStage = 1;
        }

        Transition<DownloadCache> downloadCache() {
            if (this.downloadCacheBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.downloadCacheBuildStage == 0) {
                this.downloadCacheBuildStage = (byte)-1;
                this.downloadCache = Objects.requireNonNull(ImmutableProcessFactory.super.downloadCache(), "downloadCache");
                this.downloadCacheBuildStage = 1;
            }
            return this.downloadCache;
        }

        void downloadCache(Transition<DownloadCache> downloadCache) {
            this.downloadCache = downloadCache;
            this.downloadCacheBuildStage = 1;
        }

        Transition<ExtractedFileSetStore> extractedFileSetStore() {
            if (this.extractedFileSetStoreBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.extractedFileSetStoreBuildStage == 0) {
                this.extractedFileSetStoreBuildStage = (byte)-1;
                this.extractedFileSetStore = Objects.requireNonNull(ImmutableProcessFactory.super.extractedFileSetStore(), "extractedFileSetStore");
                this.extractedFileSetStoreBuildStage = 1;
            }
            return this.extractedFileSetStore;
        }

        void extractedFileSetStore(Transition<ExtractedFileSetStore> extractedFileSetStore) {
            this.extractedFileSetStore = extractedFileSetStore;
            this.extractedFileSetStoreBuildStage = 1;
        }

        Transition<ExtractedFileSet> extractPackage() {
            if (this.extractPackageBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.extractPackageBuildStage == 0) {
                this.extractPackageBuildStage = (byte)-1;
                this.extractPackage = Objects.requireNonNull(ImmutableProcessFactory.super.extractPackage(), "extractPackage");
                this.extractPackageBuildStage = 1;
            }
            return this.extractPackage;
        }

        void extractPackage(Transition<ExtractedFileSet> extractPackage) {
            this.extractPackage = extractPackage;
            this.extractPackageBuildStage = 1;
        }

        Transition<Archive> downloadPackage() {
            if (this.downloadPackageBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.downloadPackageBuildStage == 0) {
                this.downloadPackageBuildStage = (byte)-1;
                this.downloadPackage = Objects.requireNonNull(ImmutableProcessFactory.super.downloadPackage(), "downloadPackage");
                this.downloadPackageBuildStage = 1;
            }
            return this.downloadPackage;
        }

        void downloadPackage(Transition<Archive> downloadPackage) {
            this.downloadPackage = downloadPackage;
            this.downloadPackageBuildStage = 1;
        }

        Transition<Distribution> distribution() {
            if (this.distributionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.distributionBuildStage == 0) {
                this.distributionBuildStage = (byte)-1;
                this.distribution = Objects.requireNonNull(ImmutableProcessFactory.super.distribution(), "distribution");
                this.distributionBuildStage = 1;
            }
            return this.distribution;
        }

        void distribution(Transition<Distribution> distribution) {
            this.distribution = distribution;
            this.distributionBuildStage = 1;
        }

        Transition<ExecutedProcess> executer() {
            if (this.executerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.executerBuildStage == 0) {
                this.executerBuildStage = (byte)-1;
                this.executer = Objects.requireNonNull(ImmutableProcessFactory.super.executer(), "executer");
                this.executerBuildStage = 1;
            }
            return this.executer;
        }

        void executer(Transition<ExecutedProcess> executer) {
            this.executer = executer;
            this.executerBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.initTempDirectoryBuildStage == -1) {
                attributes.add("initTempDirectory");
            }
            if (this.processWorkingDirBuildStage == -1) {
                attributes.add("processWorkingDir");
            }
            if (this.processConfigBuildStage == -1) {
                attributes.add("processConfig");
            }
            if (this.processEnvBuildStage == -1) {
                attributes.add("processEnv");
            }
            if (this.processOutputBuildStage == -1) {
                attributes.add("processOutput");
            }
            if (this.progressListenerBuildStage == -1) {
                attributes.add("progressListener");
            }
            if (this.supportConfigBuildStage == -1) {
                attributes.add("supportConfig");
            }
            if (this.downloadCacheBuildStage == -1) {
                attributes.add("downloadCache");
            }
            if (this.extractedFileSetStoreBuildStage == -1) {
                attributes.add("extractedFileSetStore");
            }
            if (this.extractPackageBuildStage == -1) {
                attributes.add("extractPackage");
            }
            if (this.downloadPackageBuildStage == -1) {
                attributes.add("downloadPackage");
            }
            if (this.distributionBuildStage == -1) {
                attributes.add("distribution");
            }
            if (this.executerBuildStage == -1) {
                attributes.add("executer");
            }
            return "Cannot build ProcessFactory, attribute initializers form cycle " + attributes;
        }
    }
}

