/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.io;

import de.flapdoodle.embed.process.io.ProcessOutput;
import de.flapdoodle.embed.process.io.StreamProcessor;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="ProcessOutput", generator="Immutables")
public final class ImmutableProcessOutput
implements ProcessOutput {
    private final StreamProcessor output;
    private final StreamProcessor error;
    private final StreamProcessor commands;

    private ImmutableProcessOutput(StreamProcessor output, StreamProcessor error, StreamProcessor commands) {
        this.output = output;
        this.error = error;
        this.commands = commands;
    }

    @Override
    public StreamProcessor output() {
        return this.output;
    }

    @Override
    public StreamProcessor error() {
        return this.error;
    }

    @Override
    public StreamProcessor commands() {
        return this.commands;
    }

    public final ImmutableProcessOutput withOutput(StreamProcessor value) {
        if (this.output == value) {
            return this;
        }
        StreamProcessor newValue = Objects.requireNonNull(value, "output");
        return new ImmutableProcessOutput(newValue, this.error, this.commands);
    }

    public final ImmutableProcessOutput withError(StreamProcessor value) {
        if (this.error == value) {
            return this;
        }
        StreamProcessor newValue = Objects.requireNonNull(value, "error");
        return new ImmutableProcessOutput(this.output, newValue, this.commands);
    }

    public final ImmutableProcessOutput withCommands(StreamProcessor value) {
        if (this.commands == value) {
            return this;
        }
        StreamProcessor newValue = Objects.requireNonNull(value, "commands");
        return new ImmutableProcessOutput(this.output, this.error, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProcessOutput && this.equalTo((ImmutableProcessOutput)another);
    }

    private boolean equalTo(ImmutableProcessOutput another) {
        return this.output.equals(another.output) && this.error.equals(another.error) && this.commands.equals(another.commands);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.output.hashCode();
        h += (h << 5) + this.error.hashCode();
        h += (h << 5) + this.commands.hashCode();
        return h;
    }

    public String toString() {
        return "ProcessOutput{output=" + this.output + ", error=" + this.error + ", commands=" + this.commands + "}";
    }

    public static ImmutableProcessOutput copyOf(ProcessOutput instance) {
        if (instance instanceof ImmutableProcessOutput) {
            return (ImmutableProcessOutput)instance;
        }
        return ImmutableProcessOutput.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ProcessOutput", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_OUTPUT = 1L;
        private static final long INIT_BIT_ERROR = 2L;
        private static final long INIT_BIT_COMMANDS = 4L;
        private long initBits = 7L;
        private StreamProcessor output;
        private StreamProcessor error;
        private StreamProcessor commands;

        private Builder() {
        }

        public final Builder from(ProcessOutput instance) {
            Objects.requireNonNull(instance, "instance");
            this.output(instance.output());
            this.error(instance.error());
            this.commands(instance.commands());
            return this;
        }

        public final Builder output(StreamProcessor output) {
            this.output = Objects.requireNonNull(output, "output");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder error(StreamProcessor error) {
            this.error = Objects.requireNonNull(error, "error");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder commands(StreamProcessor commands) {
            this.commands = Objects.requireNonNull(commands, "commands");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableProcessOutput build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableProcessOutput(this.output, this.error, this.commands);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("output");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("error");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("commands");
            }
            return "Cannot build ProcessOutput, some of required attributes are not set " + attributes;
        }
    }
}

