package de.flapdoodle.embed.process.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _ProcessArguments}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ProcessArguments.of()}.
 */
@Generated(from = "_ProcessArguments", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ProcessArguments extends de.flapdoodle.embed.process.types._ProcessArguments {
  private final List<String> value;

  private ProcessArguments(Iterable<String> value) {
    this.value = createUnmodifiableList(false, createSafeList(value, true, false));
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public List<String> value() {
    return value;
  }

  /**
   * This instance is equal to all instances of {@code ProcessArguments} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ProcessArguments
        && equalTo((ProcessArguments) another);
  }

  private boolean equalTo(ProcessArguments another) {
    return value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Construct a new immutable {@code ProcessArguments} instance.
   * @param value The value for the {@code value} attribute
   * @return An immutable ProcessArguments instance
   */
  public static ProcessArguments of(List<String> value) {
    return of((Iterable<String>) value);
  }

  /**
   * Construct a new immutable {@code ProcessArguments} instance.
   * @param value The value for the {@code value} attribute
   * @return An immutable ProcessArguments instance
   */
  public static ProcessArguments of(Iterable<String> value) {
    return new ProcessArguments(value);
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
