package de.flapdoodle.embed.process.archives;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ExtractedFileSet}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExtractedFileSet.builder()}.
 */
@Generated(from = "ExtractedFileSet", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutableExtractedFileSet extends ExtractedFileSet {
  private final Path baseDir;
  private final Path executable;
  private final Set<Path> libraryFiles;

  private ImmutableExtractedFileSet(
      Path baseDir,
      Path executable,
      Set<Path> libraryFiles) {
    this.baseDir = baseDir;
    this.executable = executable;
    this.libraryFiles = libraryFiles;
  }

  /**
   * @return The value of the {@code baseDir} attribute
   */
  @Override
  public Path baseDir() {
    return baseDir;
  }

  /**
   * @return The value of the {@code executable} attribute
   */
  @Override
  public Path executable() {
    return executable;
  }

  /**
   * @return The value of the {@code libraryFiles} attribute
   */
  @Override
  public Set<Path> libraryFiles() {
    return libraryFiles;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExtractedFileSet#baseDir() baseDir} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for baseDir
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExtractedFileSet withBaseDir(Path value) {
    if (this.baseDir == value) return this;
    Path newValue = Objects.requireNonNull(value, "baseDir");
    return new ImmutableExtractedFileSet(newValue, this.executable, this.libraryFiles);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExtractedFileSet#executable() executable} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for executable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExtractedFileSet withExecutable(Path value) {
    if (this.executable == value) return this;
    Path newValue = Objects.requireNonNull(value, "executable");
    return new ImmutableExtractedFileSet(this.baseDir, newValue, this.libraryFiles);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ExtractedFileSet#libraryFiles() libraryFiles}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableExtractedFileSet withLibraryFiles(Path... elements) {
    Set<Path> newValue = createUnmodifiableSet(createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableExtractedFileSet(this.baseDir, this.executable, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ExtractedFileSet#libraryFiles() libraryFiles}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of libraryFiles elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableExtractedFileSet withLibraryFiles(Iterable<? extends Path> elements) {
    if (this.libraryFiles == elements) return this;
    Set<Path> newValue = createUnmodifiableSet(createSafeList(elements, true, false));
    return new ImmutableExtractedFileSet(this.baseDir, this.executable, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExtractedFileSet} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExtractedFileSet
        && equalTo((ImmutableExtractedFileSet) another);
  }

  private boolean equalTo(ImmutableExtractedFileSet another) {
    return baseDir.equals(another.baseDir)
        && executable.equals(another.executable)
        && libraryFiles.equals(another.libraryFiles);
  }

  /**
   * Computes a hash code from attributes: {@code baseDir}, {@code executable}, {@code libraryFiles}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + baseDir.hashCode();
    h += (h << 5) + executable.hashCode();
    h += (h << 5) + libraryFiles.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ExtractedFileSet} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ExtractedFileSet{"
        + "baseDir=" + baseDir
        + ", executable=" + executable
        + ", libraryFiles=" + libraryFiles
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ExtractedFileSet} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExtractedFileSet instance
   */
  public static ImmutableExtractedFileSet copyOf(ExtractedFileSet instance) {
    if (instance instanceof ImmutableExtractedFileSet) {
      return (ImmutableExtractedFileSet) instance;
    }
    return ImmutableExtractedFileSet.builder()
        .baseDir(instance.baseDir())
        .executable(instance.executable())
        .addAllLibraryFiles(instance.libraryFiles())
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExtractedFileSet ImmutableExtractedFileSet}.
   * <pre>
   * ImmutableExtractedFileSet.builder()
   *    .baseDir(java.nio.file.Path) // required {@link ExtractedFileSet#baseDir() baseDir}
   *    .executable(java.nio.file.Path) // required {@link ExtractedFileSet#executable() executable}
   *    .addLibraryFiles|addAllLibraryFiles(java.nio.file.Path) // {@link ExtractedFileSet#libraryFiles() libraryFiles} elements
   *    .build();
   * </pre>
   * @param baseDir {@code baseDir} parameter
   * @return A new ImmutableExtractedFileSet builder
   */
  public static ImmutableExtractedFileSet.Builder builder(Path baseDir) {
    return new ImmutableExtractedFileSet.Builder(baseDir);
  }

  static ImmutableExtractedFileSet.Builder builder() {
    return new ImmutableExtractedFileSet.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableExtractedFileSet ImmutableExtractedFileSet}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ExtractedFileSet", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_BASE_DIR = 0x1L;
    private static final long INIT_BIT_EXECUTABLE = 0x2L;
    private long initBits = 0x3L;

    private Path baseDir;
    private Path executable;
    private final List<Path> libraryFiles = new ArrayList<Path>();

    private Builder(Path baseDir) {
      baseDir(baseDir);
    }

    private Builder() {
    }

    /**
     * Initializes the value for the {@link ExtractedFileSet#baseDir() baseDir} attribute.
     * @param baseDir The value for baseDir 
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder baseDir(Path baseDir) {
      checkNotIsSet(baseDirIsSet(), "baseDir");
      this.baseDir = Objects.requireNonNull(baseDir, "baseDir");
      initBits &= ~INIT_BIT_BASE_DIR;
      return this;
    }

    /**
     * Initializes the value for the {@link ExtractedFileSet#executable() executable} attribute.
     * @param executable The value for executable 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder executable(Path executable) {
      checkNotIsSet(executableIsSet(), "executable");
      this.executable = Objects.requireNonNull(executable, "executable");
      initBits &= ~INIT_BIT_EXECUTABLE;
      return this;
    }

    /**
     * Adds one element to {@link ExtractedFileSet#libraryFiles() libraryFiles} set.
     * @param element A libraryFiles element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addLibraryFiles(Path element) {
      this.libraryFiles.add(Objects.requireNonNull(element, "libraryFiles element"));
      return this;
    }

    /**
     * Adds elements to {@link ExtractedFileSet#libraryFiles() libraryFiles} set.
     * @param elements An array of libraryFiles elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addLibraryFiles(Path... elements) {
      for (Path element : elements) {
        this.libraryFiles.add(Objects.requireNonNull(element, "libraryFiles element"));
      }
      return this;
    }


    /**
     * Adds elements to {@link ExtractedFileSet#libraryFiles() libraryFiles} set.
     * @param elements An iterable of libraryFiles elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllLibraryFiles(Iterable<? extends Path> elements) {
      for (Path element : elements) {
        this.libraryFiles.add(Objects.requireNonNull(element, "libraryFiles element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableExtractedFileSet ImmutableExtractedFileSet}.
     * @return An immutable instance of ExtractedFileSet
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExtractedFileSet build() {
      checkRequiredAttributes();
      return new ImmutableExtractedFileSet(baseDir, executable, createUnmodifiableSet(libraryFiles));
    }

    private boolean baseDirIsSet() {
      return (initBits & INIT_BIT_BASE_DIR) == 0;
    }

    private boolean executableIsSet() {
      return (initBits & INIT_BIT_EXECUTABLE) == 0;
    }

    private static void checkNotIsSet(boolean isSet, String name) {
      if (isSet) throw new IllegalStateException("Builder of ExtractedFileSet is strict, attribute is already set: ".concat(name));
    }

    private void checkRequiredAttributes() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if (!baseDirIsSet()) attributes.add("baseDir");
      if (!executableIsSet()) attributes.add("executable");
      return "Cannot build ExtractedFileSet, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  /** Unmodifiable set constructed from list to avoid rehashing. */
  private static <T> Set<T> createUnmodifiableSet(List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default:
      Set<T> set = new LinkedHashSet<>(list.size());
      set.addAll(list);
      return Collections.unmodifiableSet(set);
    }
  }
}
