package de.flapdoodle.embed.process.config.store;

import de.flapdoodle.embed.process.distribution.ArchiveType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DistributionPackage}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDistributionPackage.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableDistributionPackage.of()}.
 */
@Generated(from = "DistributionPackage", generator = "Immutables")
@SuppressWarnings({"all"})
@Deprecated
public final class ImmutableDistributionPackage
    implements DistributionPackage {
  private final ArchiveType archiveType;
  private final FileSet fileSet;
  private final String archivePath;

  private ImmutableDistributionPackage(
      ArchiveType archiveType,
      FileSet fileSet,
      String archivePath) {
    this.archiveType = Objects.requireNonNull(archiveType, "archiveType");
    this.fileSet = Objects.requireNonNull(fileSet, "fileSet");
    this.archivePath = Objects.requireNonNull(archivePath, "archivePath");
  }

  private ImmutableDistributionPackage(
      ImmutableDistributionPackage original,
      ArchiveType archiveType,
      FileSet fileSet,
      String archivePath) {
    this.archiveType = archiveType;
    this.fileSet = fileSet;
    this.archivePath = archivePath;
  }

  /**
   * @return The value of the {@code archiveType} attribute
   */
  @Override
  public ArchiveType archiveType() {
    return archiveType;
  }

  /**
   * @return The value of the {@code fileSet} attribute
   */
  @Override
  public FileSet fileSet() {
    return fileSet;
  }

  /**
   * @return The value of the {@code archivePath} attribute
   */
  @Override
  public String archivePath() {
    return archivePath;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DistributionPackage#archiveType() archiveType} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for archiveType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDistributionPackage withArchiveType(ArchiveType value) {
    if (this.archiveType == value) return this;
    ArchiveType newValue = Objects.requireNonNull(value, "archiveType");
    if (this.archiveType.equals(newValue)) return this;
    return new ImmutableDistributionPackage(this, newValue, this.fileSet, this.archivePath);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DistributionPackage#fileSet() fileSet} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for fileSet
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDistributionPackage withFileSet(FileSet value) {
    if (this.fileSet == value) return this;
    FileSet newValue = Objects.requireNonNull(value, "fileSet");
    return new ImmutableDistributionPackage(this, this.archiveType, newValue, this.archivePath);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DistributionPackage#archivePath() archivePath} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for archivePath
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDistributionPackage withArchivePath(String value) {
    String newValue = Objects.requireNonNull(value, "archivePath");
    if (this.archivePath.equals(newValue)) return this;
    return new ImmutableDistributionPackage(this, this.archiveType, this.fileSet, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDistributionPackage} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDistributionPackage
        && equalTo((ImmutableDistributionPackage) another);
  }

  private boolean equalTo(ImmutableDistributionPackage another) {
    return archiveType.equals(another.archiveType)
        && fileSet.equals(another.fileSet)
        && archivePath.equals(another.archivePath);
  }

  /**
   * Computes a hash code from attributes: {@code archiveType}, {@code fileSet}, {@code archivePath}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + archiveType.hashCode();
    h += (h << 5) + fileSet.hashCode();
    h += (h << 5) + archivePath.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DistributionPackage} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DistributionPackage{"
        + "archiveType=" + archiveType
        + ", fileSet=" + fileSet
        + ", archivePath=" + archivePath
        + "}";
  }

  /**
   * Construct a new immutable {@code DistributionPackage} instance.
   * @param archiveType The value for the {@code archiveType} attribute
   * @param fileSet The value for the {@code fileSet} attribute
   * @param archivePath The value for the {@code archivePath} attribute
   * @return An immutable DistributionPackage instance
   */
  public static ImmutableDistributionPackage of(ArchiveType archiveType, FileSet fileSet, String archivePath) {
    return new ImmutableDistributionPackage(archiveType, fileSet, archivePath);
  }

  /**
   * Creates an immutable copy of a {@link DistributionPackage} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DistributionPackage instance
   */
  public static ImmutableDistributionPackage copyOf(DistributionPackage instance) {
    if (instance instanceof ImmutableDistributionPackage) {
      return (ImmutableDistributionPackage) instance;
    }
    return ImmutableDistributionPackage.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDistributionPackage ImmutableDistributionPackage}.
   * <pre>
   * ImmutableDistributionPackage.builder()
   *    .archiveType(de.flapdoodle.embed.process.distribution.ArchiveType) // required {@link DistributionPackage#archiveType() archiveType}
   *    .fileSet(de.flapdoodle.embed.process.config.store.FileSet) // required {@link DistributionPackage#fileSet() fileSet}
   *    .archivePath(String) // required {@link DistributionPackage#archivePath() archivePath}
   *    .build();
   * </pre>
   * @return A new ImmutableDistributionPackage builder
   */
  public static ImmutableDistributionPackage.Builder builder() {
    return new ImmutableDistributionPackage.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDistributionPackage ImmutableDistributionPackage}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DistributionPackage", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ARCHIVE_TYPE = 0x1L;
    private static final long INIT_BIT_FILE_SET = 0x2L;
    private static final long INIT_BIT_ARCHIVE_PATH = 0x4L;
    private long initBits = 0x7L;

    private ArchiveType archiveType;
    private FileSet fileSet;
    private String archivePath;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DistributionPackage} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DistributionPackage instance) {
      Objects.requireNonNull(instance, "instance");
      archiveType(instance.archiveType());
      fileSet(instance.fileSet());
      archivePath(instance.archivePath());
      return this;
    }

    /**
     * Initializes the value for the {@link DistributionPackage#archiveType() archiveType} attribute.
     * @param archiveType The value for archiveType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder archiveType(ArchiveType archiveType) {
      this.archiveType = Objects.requireNonNull(archiveType, "archiveType");
      initBits &= ~INIT_BIT_ARCHIVE_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link DistributionPackage#fileSet() fileSet} attribute.
     * @param fileSet The value for fileSet 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder fileSet(FileSet fileSet) {
      this.fileSet = Objects.requireNonNull(fileSet, "fileSet");
      initBits &= ~INIT_BIT_FILE_SET;
      return this;
    }

    /**
     * Initializes the value for the {@link DistributionPackage#archivePath() archivePath} attribute.
     * @param archivePath The value for archivePath 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder archivePath(String archivePath) {
      this.archivePath = Objects.requireNonNull(archivePath, "archivePath");
      initBits &= ~INIT_BIT_ARCHIVE_PATH;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDistributionPackage ImmutableDistributionPackage}.
     * @return An immutable instance of DistributionPackage
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDistributionPackage build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDistributionPackage(null, archiveType, fileSet, archivePath);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ARCHIVE_TYPE) != 0) attributes.add("archiveType");
      if ((initBits & INIT_BIT_FILE_SET) != 0) attributes.add("fileSet");
      if ((initBits & INIT_BIT_ARCHIVE_PATH) != 0) attributes.add("archivePath");
      return "Cannot build DistributionPackage, some of required attributes are not set " + attributes;
    }
  }
}
