package de.flapdoodle.embed.process.transitions;

import de.flapdoodle.embed.process.config.DownloadConfig;
import de.flapdoodle.embed.process.config.store.Package;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.io.directories.TempDir;
import de.flapdoodle.embed.process.net.UrlStreams;
import de.flapdoodle.embed.process.store.DownloadCache;
import de.flapdoodle.embed.process.types.Archive;
import de.flapdoodle.embed.process.types.Name;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.naming.HasLabel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DownloadPackage}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDownloadPackage.builder()}.
 */
@Generated(from = "DownloadPackage", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutableDownloadPackage extends DownloadPackage {
  private final String transitionLabel;
  private final StateID<Name> name;
  private final StateID<DownloadCache> downloadCache;
  private final UrlStreams.DownloadCopyListener downloadCopyListener;
  private final DownloadConfig downloadConfig;
  private final StateID<Distribution> distribution;
  private final StateID<Package> distPackage;
  private final StateID<TempDir> tempDirectory;
  private final StateID<Archive> destination;

  private ImmutableDownloadPackage(ImmutableDownloadPackage.Builder builder) {
    if (builder.transitionLabel != null) {
      initShim.transitionLabel(builder.transitionLabel);
    }
    if (builder.name != null) {
      initShim.name(builder.name);
    }
    if (builder.downloadCache != null) {
      initShim.downloadCache(builder.downloadCache);
    }
    if (builder.downloadCopyListener != null) {
      initShim.downloadCopyListener(builder.downloadCopyListener);
    }
    if (builder.downloadConfig != null) {
      initShim.downloadConfig(builder.downloadConfig);
    }
    if (builder.distribution != null) {
      initShim.distribution(builder.distribution);
    }
    if (builder.distPackage != null) {
      initShim.distPackage(builder.distPackage);
    }
    if (builder.tempDirectory != null) {
      initShim.tempDirectory(builder.tempDirectory);
    }
    if (builder.destination != null) {
      initShim.destination(builder.destination);
    }
    this.transitionLabel = initShim.transitionLabel();
    this.name = initShim.name();
    this.downloadCache = initShim.downloadCache();
    this.downloadCopyListener = initShim.downloadCopyListener();
    this.downloadConfig = initShim.downloadConfig();
    this.distribution = initShim.distribution();
    this.distPackage = initShim.distPackage();
    this.tempDirectory = initShim.tempDirectory();
    this.destination = initShim.destination();
    this.initShim = null;
  }

  private ImmutableDownloadPackage(
      String transitionLabel,
      StateID<Name> name,
      StateID<DownloadCache> downloadCache,
      UrlStreams.DownloadCopyListener downloadCopyListener,
      DownloadConfig downloadConfig,
      StateID<Distribution> distribution,
      StateID<Package> distPackage,
      StateID<TempDir> tempDirectory,
      StateID<Archive> destination) {
    this.transitionLabel = transitionLabel;
    this.name = name;
    this.downloadCache = downloadCache;
    this.downloadCopyListener = downloadCopyListener;
    this.downloadConfig = downloadConfig;
    this.distribution = distribution;
    this.distPackage = distPackage;
    this.tempDirectory = tempDirectory;
    this.destination = destination;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "DownloadPackage", generator = "Immutables")
  private final class InitShim {
    private byte transitionLabelBuildStage = STAGE_UNINITIALIZED;
    private String transitionLabel;

    String transitionLabel() {
      if (transitionLabelBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (transitionLabelBuildStage == STAGE_UNINITIALIZED) {
        transitionLabelBuildStage = STAGE_INITIALIZING;
        this.transitionLabel = Objects.requireNonNull(ImmutableDownloadPackage.super.transitionLabel(), "transitionLabel");
        transitionLabelBuildStage = STAGE_INITIALIZED;
      }
      return this.transitionLabel;
    }

    void transitionLabel(String transitionLabel) {
      this.transitionLabel = transitionLabel;
      transitionLabelBuildStage = STAGE_INITIALIZED;
    }

    private byte nameBuildStage = STAGE_UNINITIALIZED;
    private StateID<Name> name;

    StateID<Name> name() {
      if (nameBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (nameBuildStage == STAGE_UNINITIALIZED) {
        nameBuildStage = STAGE_INITIALIZING;
        this.name = Objects.requireNonNull(ImmutableDownloadPackage.super.name(), "name");
        nameBuildStage = STAGE_INITIALIZED;
      }
      return this.name;
    }

    void name(StateID<Name> name) {
      this.name = name;
      nameBuildStage = STAGE_INITIALIZED;
    }

    private byte downloadCacheBuildStage = STAGE_UNINITIALIZED;
    private StateID<DownloadCache> downloadCache;

    StateID<DownloadCache> downloadCache() {
      if (downloadCacheBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (downloadCacheBuildStage == STAGE_UNINITIALIZED) {
        downloadCacheBuildStage = STAGE_INITIALIZING;
        this.downloadCache = Objects.requireNonNull(ImmutableDownloadPackage.super.downloadCache(), "downloadCache");
        downloadCacheBuildStage = STAGE_INITIALIZED;
      }
      return this.downloadCache;
    }

    void downloadCache(StateID<DownloadCache> downloadCache) {
      this.downloadCache = downloadCache;
      downloadCacheBuildStage = STAGE_INITIALIZED;
    }

    private byte downloadCopyListenerBuildStage = STAGE_UNINITIALIZED;
    private UrlStreams.DownloadCopyListener downloadCopyListener;

    UrlStreams.DownloadCopyListener downloadCopyListener() {
      if (downloadCopyListenerBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (downloadCopyListenerBuildStage == STAGE_UNINITIALIZED) {
        downloadCopyListenerBuildStage = STAGE_INITIALIZING;
        this.downloadCopyListener = Objects.requireNonNull(ImmutableDownloadPackage.super.downloadCopyListener(), "downloadCopyListener");
        downloadCopyListenerBuildStage = STAGE_INITIALIZED;
      }
      return this.downloadCopyListener;
    }

    void downloadCopyListener(UrlStreams.DownloadCopyListener downloadCopyListener) {
      this.downloadCopyListener = downloadCopyListener;
      downloadCopyListenerBuildStage = STAGE_INITIALIZED;
    }

    private byte downloadConfigBuildStage = STAGE_UNINITIALIZED;
    private DownloadConfig downloadConfig;

    DownloadConfig downloadConfig() {
      if (downloadConfigBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (downloadConfigBuildStage == STAGE_UNINITIALIZED) {
        downloadConfigBuildStage = STAGE_INITIALIZING;
        this.downloadConfig = Objects.requireNonNull(ImmutableDownloadPackage.super.downloadConfig(), "downloadConfig");
        downloadConfigBuildStage = STAGE_INITIALIZED;
      }
      return this.downloadConfig;
    }

    void downloadConfig(DownloadConfig downloadConfig) {
      this.downloadConfig = downloadConfig;
      downloadConfigBuildStage = STAGE_INITIALIZED;
    }

    private byte distributionBuildStage = STAGE_UNINITIALIZED;
    private StateID<Distribution> distribution;

    StateID<Distribution> distribution() {
      if (distributionBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (distributionBuildStage == STAGE_UNINITIALIZED) {
        distributionBuildStage = STAGE_INITIALIZING;
        this.distribution = Objects.requireNonNull(ImmutableDownloadPackage.super.distribution(), "distribution");
        distributionBuildStage = STAGE_INITIALIZED;
      }
      return this.distribution;
    }

    void distribution(StateID<Distribution> distribution) {
      this.distribution = distribution;
      distributionBuildStage = STAGE_INITIALIZED;
    }

    private byte distPackageBuildStage = STAGE_UNINITIALIZED;
    private StateID<Package> distPackage;

    StateID<Package> distPackage() {
      if (distPackageBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (distPackageBuildStage == STAGE_UNINITIALIZED) {
        distPackageBuildStage = STAGE_INITIALIZING;
        this.distPackage = Objects.requireNonNull(ImmutableDownloadPackage.super.distPackage(), "distPackage");
        distPackageBuildStage = STAGE_INITIALIZED;
      }
      return this.distPackage;
    }

    void distPackage(StateID<Package> distPackage) {
      this.distPackage = distPackage;
      distPackageBuildStage = STAGE_INITIALIZED;
    }

    private byte tempDirectoryBuildStage = STAGE_UNINITIALIZED;
    private StateID<TempDir> tempDirectory;

    StateID<TempDir> tempDirectory() {
      if (tempDirectoryBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (tempDirectoryBuildStage == STAGE_UNINITIALIZED) {
        tempDirectoryBuildStage = STAGE_INITIALIZING;
        this.tempDirectory = Objects.requireNonNull(ImmutableDownloadPackage.super.tempDirectory(), "tempDirectory");
        tempDirectoryBuildStage = STAGE_INITIALIZED;
      }
      return this.tempDirectory;
    }

    void tempDirectory(StateID<TempDir> tempDirectory) {
      this.tempDirectory = tempDirectory;
      tempDirectoryBuildStage = STAGE_INITIALIZED;
    }

    private byte destinationBuildStage = STAGE_UNINITIALIZED;
    private StateID<Archive> destination;

    StateID<Archive> destination() {
      if (destinationBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (destinationBuildStage == STAGE_UNINITIALIZED) {
        destinationBuildStage = STAGE_INITIALIZING;
        this.destination = Objects.requireNonNull(ImmutableDownloadPackage.super.destination(), "destination");
        destinationBuildStage = STAGE_INITIALIZED;
      }
      return this.destination;
    }

    void destination(StateID<Archive> destination) {
      this.destination = destination;
      destinationBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (transitionLabelBuildStage == STAGE_INITIALIZING) attributes.add("transitionLabel");
      if (nameBuildStage == STAGE_INITIALIZING) attributes.add("name");
      if (downloadCacheBuildStage == STAGE_INITIALIZING) attributes.add("downloadCache");
      if (downloadCopyListenerBuildStage == STAGE_INITIALIZING) attributes.add("downloadCopyListener");
      if (downloadConfigBuildStage == STAGE_INITIALIZING) attributes.add("downloadConfig");
      if (distributionBuildStage == STAGE_INITIALIZING) attributes.add("distribution");
      if (distPackageBuildStage == STAGE_INITIALIZING) attributes.add("distPackage");
      if (tempDirectoryBuildStage == STAGE_INITIALIZING) attributes.add("tempDirectory");
      if (destinationBuildStage == STAGE_INITIALIZING) attributes.add("destination");
      return "Cannot build DownloadPackage, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code transitionLabel} attribute
   */
  @Override
  public String transitionLabel() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.transitionLabel()
        : this.transitionLabel;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  protected StateID<Name> name() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.name()
        : this.name;
  }

  /**
   * @return The value of the {@code downloadCache} attribute
   */
  @Override
  protected StateID<DownloadCache> downloadCache() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.downloadCache()
        : this.downloadCache;
  }

  /**
   * @return The value of the {@code downloadCopyListener} attribute
   */
  @Override
  protected UrlStreams.DownloadCopyListener downloadCopyListener() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.downloadCopyListener()
        : this.downloadCopyListener;
  }

  /**
   * @return The value of the {@code downloadConfig} attribute
   */
  @Override
  protected DownloadConfig downloadConfig() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.downloadConfig()
        : this.downloadConfig;
  }

  /**
   * @return The value of the {@code distribution} attribute
   */
  @Override
  protected StateID<Distribution> distribution() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.distribution()
        : this.distribution;
  }

  /**
   * @return The value of the {@code distPackage} attribute
   */
  @Override
  protected StateID<Package> distPackage() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.distPackage()
        : this.distPackage;
  }

  /**
   * @return The value of the {@code tempDirectory} attribute
   */
  @Override
  protected StateID<TempDir> tempDirectory() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.tempDirectory()
        : this.tempDirectory;
  }

  /**
   * @return The value of the {@code destination} attribute
   */
  @Override
  public StateID<Archive> destination() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.destination()
        : this.destination;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DownloadPackage#transitionLabel() transitionLabel} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for transitionLabel
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDownloadPackage withTransitionLabel(String value) {
    String newValue = Objects.requireNonNull(value, "transitionLabel");
    if (this.transitionLabel.equals(newValue)) return this;
    return new ImmutableDownloadPackage(
        newValue,
        this.name,
        this.downloadCache,
        this.downloadCopyListener,
        this.downloadConfig,
        this.distribution,
        this.distPackage,
        this.tempDirectory,
        this.destination);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DownloadPackage#name() name} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDownloadPackage withName(StateID<Name> value) {
    if (this.name == value) return this;
    StateID<Name> newValue = Objects.requireNonNull(value, "name");
    return new ImmutableDownloadPackage(
        this.transitionLabel,
        newValue,
        this.downloadCache,
        this.downloadCopyListener,
        this.downloadConfig,
        this.distribution,
        this.distPackage,
        this.tempDirectory,
        this.destination);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DownloadPackage#downloadCache() downloadCache} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for downloadCache
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDownloadPackage withDownloadCache(StateID<DownloadCache> value) {
    if (this.downloadCache == value) return this;
    StateID<DownloadCache> newValue = Objects.requireNonNull(value, "downloadCache");
    return new ImmutableDownloadPackage(
        this.transitionLabel,
        this.name,
        newValue,
        this.downloadCopyListener,
        this.downloadConfig,
        this.distribution,
        this.distPackage,
        this.tempDirectory,
        this.destination);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DownloadPackage#downloadCopyListener() downloadCopyListener} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for downloadCopyListener
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDownloadPackage withDownloadCopyListener(UrlStreams.DownloadCopyListener value) {
    if (this.downloadCopyListener == value) return this;
    UrlStreams.DownloadCopyListener newValue = Objects.requireNonNull(value, "downloadCopyListener");
    return new ImmutableDownloadPackage(
        this.transitionLabel,
        this.name,
        this.downloadCache,
        newValue,
        this.downloadConfig,
        this.distribution,
        this.distPackage,
        this.tempDirectory,
        this.destination);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DownloadPackage#downloadConfig() downloadConfig} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for downloadConfig
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDownloadPackage withDownloadConfig(DownloadConfig value) {
    if (this.downloadConfig == value) return this;
    DownloadConfig newValue = Objects.requireNonNull(value, "downloadConfig");
    return new ImmutableDownloadPackage(
        this.transitionLabel,
        this.name,
        this.downloadCache,
        this.downloadCopyListener,
        newValue,
        this.distribution,
        this.distPackage,
        this.tempDirectory,
        this.destination);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DownloadPackage#distribution() distribution} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for distribution
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDownloadPackage withDistribution(StateID<Distribution> value) {
    if (this.distribution == value) return this;
    StateID<Distribution> newValue = Objects.requireNonNull(value, "distribution");
    return new ImmutableDownloadPackage(
        this.transitionLabel,
        this.name,
        this.downloadCache,
        this.downloadCopyListener,
        this.downloadConfig,
        newValue,
        this.distPackage,
        this.tempDirectory,
        this.destination);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DownloadPackage#distPackage() distPackage} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for distPackage
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDownloadPackage withDistPackage(StateID<Package> value) {
    if (this.distPackage == value) return this;
    StateID<Package> newValue = Objects.requireNonNull(value, "distPackage");
    return new ImmutableDownloadPackage(
        this.transitionLabel,
        this.name,
        this.downloadCache,
        this.downloadCopyListener,
        this.downloadConfig,
        this.distribution,
        newValue,
        this.tempDirectory,
        this.destination);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DownloadPackage#tempDirectory() tempDirectory} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tempDirectory
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDownloadPackage withTempDirectory(StateID<TempDir> value) {
    if (this.tempDirectory == value) return this;
    StateID<TempDir> newValue = Objects.requireNonNull(value, "tempDirectory");
    return new ImmutableDownloadPackage(
        this.transitionLabel,
        this.name,
        this.downloadCache,
        this.downloadCopyListener,
        this.downloadConfig,
        this.distribution,
        this.distPackage,
        newValue,
        this.destination);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DownloadPackage#destination() destination} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for destination
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDownloadPackage withDestination(StateID<Archive> value) {
    if (this.destination == value) return this;
    StateID<Archive> newValue = Objects.requireNonNull(value, "destination");
    return new ImmutableDownloadPackage(
        this.transitionLabel,
        this.name,
        this.downloadCache,
        this.downloadCopyListener,
        this.downloadConfig,
        this.distribution,
        this.distPackage,
        this.tempDirectory,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDownloadPackage} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDownloadPackage
        && equalTo((ImmutableDownloadPackage) another);
  }

  private boolean equalTo(ImmutableDownloadPackage another) {
    return transitionLabel.equals(another.transitionLabel)
        && name.equals(another.name)
        && downloadCache.equals(another.downloadCache)
        && downloadCopyListener.equals(another.downloadCopyListener)
        && downloadConfig.equals(another.downloadConfig)
        && distribution.equals(another.distribution)
        && distPackage.equals(another.distPackage)
        && tempDirectory.equals(another.tempDirectory)
        && destination.equals(another.destination);
  }

  /**
   * Computes a hash code from attributes: {@code transitionLabel}, {@code name}, {@code downloadCache}, {@code downloadCopyListener}, {@code downloadConfig}, {@code distribution}, {@code distPackage}, {@code tempDirectory}, {@code destination}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + transitionLabel.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + downloadCache.hashCode();
    h += (h << 5) + downloadCopyListener.hashCode();
    h += (h << 5) + downloadConfig.hashCode();
    h += (h << 5) + distribution.hashCode();
    h += (h << 5) + distPackage.hashCode();
    h += (h << 5) + tempDirectory.hashCode();
    h += (h << 5) + destination.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DownloadPackage} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DownloadPackage{"
        + "transitionLabel=" + transitionLabel
        + ", name=" + name
        + ", downloadCache=" + downloadCache
        + ", downloadCopyListener=" + downloadCopyListener
        + ", downloadConfig=" + downloadConfig
        + ", distribution=" + distribution
        + ", distPackage=" + distPackage
        + ", tempDirectory=" + tempDirectory
        + ", destination=" + destination
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link DownloadPackage} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DownloadPackage instance
   */
  public static ImmutableDownloadPackage copyOf(DownloadPackage instance) {
    if (instance instanceof ImmutableDownloadPackage) {
      return (ImmutableDownloadPackage) instance;
    }
    return ImmutableDownloadPackage.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDownloadPackage ImmutableDownloadPackage}.
   * <pre>
   * ImmutableDownloadPackage.builder()
   *    .transitionLabel(String) // optional {@link DownloadPackage#transitionLabel() transitionLabel}
   *    .name(de.flapdoodle.reverse.StateID&amp;lt;de.flapdoodle.embed.process.types.Name&amp;gt;) // optional {@link DownloadPackage#name() name}
   *    .downloadCache(de.flapdoodle.reverse.StateID&amp;lt;de.flapdoodle.embed.process.store.DownloadCache&amp;gt;) // optional {@link DownloadPackage#downloadCache() downloadCache}
   *    .downloadCopyListener(de.flapdoodle.embed.process.net.UrlStreams.DownloadCopyListener) // optional {@link DownloadPackage#downloadCopyListener() downloadCopyListener}
   *    .downloadConfig(de.flapdoodle.embed.process.config.DownloadConfig) // optional {@link DownloadPackage#downloadConfig() downloadConfig}
   *    .distribution(de.flapdoodle.reverse.StateID&amp;lt;de.flapdoodle.embed.process.distribution.Distribution&amp;gt;) // optional {@link DownloadPackage#distribution() distribution}
   *    .distPackage(de.flapdoodle.reverse.StateID&amp;lt;de.flapdoodle.embed.process.config.store.Package&amp;gt;) // optional {@link DownloadPackage#distPackage() distPackage}
   *    .tempDirectory(de.flapdoodle.reverse.StateID&amp;lt;de.flapdoodle.embed.process.io.directories.TempDir&amp;gt;) // optional {@link DownloadPackage#tempDirectory() tempDirectory}
   *    .destination(de.flapdoodle.reverse.StateID&amp;lt;de.flapdoodle.embed.process.types.Archive&amp;gt;) // optional {@link DownloadPackage#destination() destination}
   *    .build();
   * </pre>
   * @return A new ImmutableDownloadPackage builder
   */
  public static ImmutableDownloadPackage.Builder builder() {
    return new ImmutableDownloadPackage.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDownloadPackage ImmutableDownloadPackage}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DownloadPackage", generator = "Immutables")
  public static final class Builder {
    private String transitionLabel;
    private StateID<Name> name;
    private StateID<DownloadCache> downloadCache;
    private UrlStreams.DownloadCopyListener downloadCopyListener;
    private DownloadConfig downloadConfig;
    private StateID<Distribution> distribution;
    private StateID<Package> distPackage;
    private StateID<TempDir> tempDirectory;
    private StateID<Archive> destination;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.embed.process.transitions.DownloadPackage} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DownloadPackage instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.reverse.naming.HasLabel} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HasLabel instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof DownloadPackage) {
        DownloadPackage instance = (DownloadPackage) object;
        tempDirectory(instance.tempDirectory());
        downloadCopyListener(instance.downloadCopyListener());
        downloadConfig(instance.downloadConfig());
        if ((bits & 0x1L) == 0) {
          transitionLabel(instance.transitionLabel());
          bits |= 0x1L;
        }
        name(instance.name());
        destination(instance.destination());
        downloadCache(instance.downloadCache());
        distPackage(instance.distPackage());
        distribution(instance.distribution());
      }
      if (object instanceof HasLabel) {
        HasLabel instance = (HasLabel) object;
        if ((bits & 0x1L) == 0) {
          transitionLabel(instance.transitionLabel());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link DownloadPackage#transitionLabel() transitionLabel} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DownloadPackage#transitionLabel() transitionLabel}.</em>
     * @param transitionLabel The value for transitionLabel 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder transitionLabel(String transitionLabel) {
      this.transitionLabel = Objects.requireNonNull(transitionLabel, "transitionLabel");
      return this;
    }

    /**
     * Initializes the value for the {@link DownloadPackage#name() name} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DownloadPackage#name() name}.</em>
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(StateID<Name> name) {
      this.name = Objects.requireNonNull(name, "name");
      return this;
    }

    /**
     * Initializes the value for the {@link DownloadPackage#downloadCache() downloadCache} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DownloadPackage#downloadCache() downloadCache}.</em>
     * @param downloadCache The value for downloadCache 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder downloadCache(StateID<DownloadCache> downloadCache) {
      this.downloadCache = Objects.requireNonNull(downloadCache, "downloadCache");
      return this;
    }

    /**
     * Initializes the value for the {@link DownloadPackage#downloadCopyListener() downloadCopyListener} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DownloadPackage#downloadCopyListener() downloadCopyListener}.</em>
     * @param downloadCopyListener The value for downloadCopyListener 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder downloadCopyListener(UrlStreams.DownloadCopyListener downloadCopyListener) {
      this.downloadCopyListener = Objects.requireNonNull(downloadCopyListener, "downloadCopyListener");
      return this;
    }

    /**
     * Initializes the value for the {@link DownloadPackage#downloadConfig() downloadConfig} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DownloadPackage#downloadConfig() downloadConfig}.</em>
     * @param downloadConfig The value for downloadConfig 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder downloadConfig(DownloadConfig downloadConfig) {
      this.downloadConfig = Objects.requireNonNull(downloadConfig, "downloadConfig");
      return this;
    }

    /**
     * Initializes the value for the {@link DownloadPackage#distribution() distribution} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DownloadPackage#distribution() distribution}.</em>
     * @param distribution The value for distribution 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder distribution(StateID<Distribution> distribution) {
      this.distribution = Objects.requireNonNull(distribution, "distribution");
      return this;
    }

    /**
     * Initializes the value for the {@link DownloadPackage#distPackage() distPackage} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DownloadPackage#distPackage() distPackage}.</em>
     * @param distPackage The value for distPackage 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder distPackage(StateID<Package> distPackage) {
      this.distPackage = Objects.requireNonNull(distPackage, "distPackage");
      return this;
    }

    /**
     * Initializes the value for the {@link DownloadPackage#tempDirectory() tempDirectory} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DownloadPackage#tempDirectory() tempDirectory}.</em>
     * @param tempDirectory The value for tempDirectory 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tempDirectory(StateID<TempDir> tempDirectory) {
      this.tempDirectory = Objects.requireNonNull(tempDirectory, "tempDirectory");
      return this;
    }

    /**
     * Initializes the value for the {@link DownloadPackage#destination() destination} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DownloadPackage#destination() destination}.</em>
     * @param destination The value for destination 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder destination(StateID<Archive> destination) {
      this.destination = Objects.requireNonNull(destination, "destination");
      return this;
    }

    /**
     * Builds a new {@link ImmutableDownloadPackage ImmutableDownloadPackage}.
     * @return An immutable instance of DownloadPackage
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDownloadPackage build() {
      return new ImmutableDownloadPackage(this);
    }
  }
}
