package de.flapdoodle.embed.process.config.process;

import de.flapdoodle.embed.process.io.StreamProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ProcessConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProcessConfig.builder()}.
 */
@Generated(from = "ProcessConfig", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutableProcessConfig implements ProcessConfig {
  private final List<String> commandLine;
  private final StreamProcessor output;
  private final StreamProcessor error;

  private ImmutableProcessConfig(ImmutableProcessConfig.Builder builder) {
    this.commandLine = createUnmodifiableList(true, builder.commandLine);
    this.output = builder.output;
    this.error = builder.error != null
        ? builder.error
        : Objects.requireNonNull(ProcessConfig.super.error(), "error");
  }

  private ImmutableProcessConfig(
      List<String> commandLine,
      StreamProcessor output,
      StreamProcessor error) {
    this.commandLine = commandLine;
    this.output = output;
    this.error = error;
  }

  /**
   * @return The value of the {@code commandLine} attribute
   */
  @Override
  public List<String> commandLine() {
    return commandLine;
  }

  /**
   * @return The value of the {@code output} attribute
   */
  @Override
  public StreamProcessor output() {
    return output;
  }

  /**
   * @return The value of the {@code error} attribute
   */
  @Override
  public StreamProcessor error() {
    return error;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ProcessConfig#commandLine() commandLine}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProcessConfig withCommandLine(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableProcessConfig(newValue, this.output, this.error);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ProcessConfig#commandLine() commandLine}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of commandLine elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProcessConfig withCommandLine(Iterable<String> elements) {
    if (this.commandLine == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableProcessConfig(newValue, this.output, this.error);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessConfig#output() output} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for output
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessConfig withOutput(StreamProcessor value) {
    if (this.output == value) return this;
    StreamProcessor newValue = Objects.requireNonNull(value, "output");
    return new ImmutableProcessConfig(this.commandLine, newValue, this.error);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessConfig#error() error} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for error
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessConfig withError(StreamProcessor value) {
    if (this.error == value) return this;
    StreamProcessor newValue = Objects.requireNonNull(value, "error");
    return new ImmutableProcessConfig(this.commandLine, this.output, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProcessConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProcessConfig
        && equalTo((ImmutableProcessConfig) another);
  }

  private boolean equalTo(ImmutableProcessConfig another) {
    return commandLine.equals(another.commandLine)
        && output.equals(another.output)
        && error.equals(another.error);
  }

  /**
   * Computes a hash code from attributes: {@code commandLine}, {@code output}, {@code error}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + commandLine.hashCode();
    h += (h << 5) + output.hashCode();
    h += (h << 5) + error.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ProcessConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ProcessConfig{"
        + "commandLine=" + commandLine
        + ", output=" + output
        + ", error=" + error
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ProcessConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ProcessConfig instance
   */
  public static ImmutableProcessConfig copyOf(ProcessConfig instance) {
    if (instance instanceof ImmutableProcessConfig) {
      return (ImmutableProcessConfig) instance;
    }
    return ImmutableProcessConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProcessConfig ImmutableProcessConfig}.
   * <pre>
   * ImmutableProcessConfig.builder()
   *    .addCommandLine|addAllCommandLine(String) // {@link ProcessConfig#commandLine() commandLine} elements
   *    .output(de.flapdoodle.embed.process.io.StreamProcessor) // required {@link ProcessConfig#output() output}
   *    .error(de.flapdoodle.embed.process.io.StreamProcessor) // optional {@link ProcessConfig#error() error}
   *    .build();
   * </pre>
   * @return A new ImmutableProcessConfig builder
   */
  public static ImmutableProcessConfig.Builder builder() {
    return new ImmutableProcessConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProcessConfig ImmutableProcessConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ProcessConfig", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_OUTPUT = 0x1L;
    private long initBits = 0x1L;

    private List<String> commandLine = new ArrayList<String>();
    private StreamProcessor output;
    private StreamProcessor error;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ProcessConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessConfig instance) {
      Objects.requireNonNull(instance, "instance");
      addAllCommandLine(instance.commandLine());
      output(instance.output());
      error(instance.error());
      return this;
    }

    /**
     * Adds one element to {@link ProcessConfig#commandLine() commandLine} list.
     * @param element A commandLine element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addCommandLine(String element) {
      this.commandLine.add(Objects.requireNonNull(element, "commandLine element"));
      return this;
    }

    /**
     * Adds elements to {@link ProcessConfig#commandLine() commandLine} list.
     * @param elements An array of commandLine elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addCommandLine(String... elements) {
      for (String element : elements) {
        this.commandLine.add(Objects.requireNonNull(element, "commandLine element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ProcessConfig#commandLine() commandLine} list.
     * @param elements An iterable of commandLine elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder commandLine(Iterable<String> elements) {
      this.commandLine.clear();
      return addAllCommandLine(elements);
    }

    /**
     * Adds elements to {@link ProcessConfig#commandLine() commandLine} list.
     * @param elements An iterable of commandLine elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllCommandLine(Iterable<String> elements) {
      for (String element : elements) {
        this.commandLine.add(Objects.requireNonNull(element, "commandLine element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessConfig#output() output} attribute.
     * @param output The value for output 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder output(StreamProcessor output) {
      this.output = Objects.requireNonNull(output, "output");
      initBits &= ~INIT_BIT_OUTPUT;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessConfig#error() error} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ProcessConfig#error() error}.</em>
     * @param error The value for error 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder error(StreamProcessor error) {
      this.error = Objects.requireNonNull(error, "error");
      return this;
    }

    /**
     * Builds a new {@link ImmutableProcessConfig ImmutableProcessConfig}.
     * @return An immutable instance of ProcessConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProcessConfig build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableProcessConfig(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_OUTPUT) != 0) attributes.add("output");
      return "Cannot build ProcessConfig, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
