package de.flapdoodle.embed.process.store;

import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.extract.ExtractedFileSet;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StaticArtifactStore}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStaticArtifactStore.builder()}.
 */
@Generated(from = "StaticArtifactStore", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableStaticArtifactStore extends StaticArtifactStore {
  private final Map<Distribution, ExtractedFileSet> fileSet;

  private ImmutableStaticArtifactStore(
      Map<Distribution, ExtractedFileSet> fileSet) {
    this.fileSet = fileSet;
  }

  /**
   * @return The value of the {@code fileSet} attribute
   */
  @Override
  protected Map<Distribution, ExtractedFileSet> fileSet() {
    return fileSet;
  }

  /**
   * Copy the current immutable object by replacing the {@link StaticArtifactStore#fileSet() fileSet} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the fileSet map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStaticArtifactStore withFileSet(Map<? extends Distribution, ? extends ExtractedFileSet> entries) {
    if (this.fileSet == entries) return this;
    Map<Distribution, ExtractedFileSet> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableStaticArtifactStore(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStaticArtifactStore} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStaticArtifactStore
        && equalTo((ImmutableStaticArtifactStore) another);
  }

  private boolean equalTo(ImmutableStaticArtifactStore another) {
    return fileSet.equals(another.fileSet);
  }

  /**
   * Computes a hash code from attributes: {@code fileSet}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + fileSet.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code StaticArtifactStore} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "StaticArtifactStore{"
        + "fileSet=" + fileSet
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link StaticArtifactStore} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StaticArtifactStore instance
   */
  public static ImmutableStaticArtifactStore copyOf(StaticArtifactStore instance) {
    if (instance instanceof ImmutableStaticArtifactStore) {
      return (ImmutableStaticArtifactStore) instance;
    }
    return ImmutableStaticArtifactStore.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStaticArtifactStore ImmutableStaticArtifactStore}.
   * <pre>
   * ImmutableStaticArtifactStore.builder()
   *    .putFileSet|putAllFileSet(de.flapdoodle.embed.process.distribution.Distribution =&gt; de.flapdoodle.embed.process.extract.ExtractedFileSet) // {@link StaticArtifactStore#fileSet() fileSet} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableStaticArtifactStore builder
   */
  public static ImmutableStaticArtifactStore.Builder builder() {
    return new ImmutableStaticArtifactStore.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableStaticArtifactStore ImmutableStaticArtifactStore}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StaticArtifactStore", generator = "Immutables")
  public static final class Builder {
    private Map<Distribution, ExtractedFileSet> fileSet = new LinkedHashMap<Distribution, ExtractedFileSet>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code StaticArtifactStore} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(StaticArtifactStore instance) {
      Objects.requireNonNull(instance, "instance");
      putAllFileSet(instance.fileSet());
      return this;
    }

    /**
     * Put one entry to the {@link StaticArtifactStore#fileSet() fileSet} map.
     * @param key The key in the fileSet map
     * @param value The associated value in the fileSet map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putFileSet(Distribution key, ExtractedFileSet value) {
      this.fileSet.put(
          Objects.requireNonNull(key, "fileSet key"),
          Objects.requireNonNull(value, "fileSet value"));
      return this;
    }

    /**
     * Put one entry to the {@link StaticArtifactStore#fileSet() fileSet} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putFileSet(Map.Entry<? extends Distribution, ? extends ExtractedFileSet> entry) {
      Distribution k = entry.getKey();
      ExtractedFileSet v = entry.getValue();
      this.fileSet.put(
          Objects.requireNonNull(k, "fileSet key"),
          Objects.requireNonNull(v, "fileSet value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link StaticArtifactStore#fileSet() fileSet} map. Nulls are not permitted
     * @param entries The entries that will be added to the fileSet map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder fileSet(Map<? extends Distribution, ? extends ExtractedFileSet> entries) {
      this.fileSet.clear();
      return putAllFileSet(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link StaticArtifactStore#fileSet() fileSet} map. Nulls are not permitted
     * @param entries The entries that will be added to the fileSet map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllFileSet(Map<? extends Distribution, ? extends ExtractedFileSet> entries) {
      for (Map.Entry<? extends Distribution, ? extends ExtractedFileSet> e : entries.entrySet()) {
        Distribution k = e.getKey();
        ExtractedFileSet v = e.getValue();
        this.fileSet.put(
            Objects.requireNonNull(k, "fileSet key"),
            Objects.requireNonNull(v, "fileSet value"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableStaticArtifactStore ImmutableStaticArtifactStore}.
     * @return An immutable instance of StaticArtifactStore
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStaticArtifactStore build() {
      return new ImmutableStaticArtifactStore(createUnmodifiableMap(false, false, fileSet));
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
