package de.flapdoodle.embed.process.distribution;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Distribution}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDistribution.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableDistribution.of()}.
 */
@Generated(from = "Distribution", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableDistribution extends Distribution {
  private final Version version;
  private final Platform platform;
  private final BitSize bitsize;

  private ImmutableDistribution(
      Version version,
      Platform platform,
      BitSize bitsize) {
    this.version = Objects.requireNonNull(version, "version");
    this.platform = Objects.requireNonNull(platform, "platform");
    this.bitsize = Objects.requireNonNull(bitsize, "bitsize");
  }

  private ImmutableDistribution(
      ImmutableDistribution original,
      Version version,
      Platform platform,
      BitSize bitsize) {
    this.version = version;
    this.platform = platform;
    this.bitsize = bitsize;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @Override
  public Version version() {
    return version;
  }

  /**
   * @return The value of the {@code platform} attribute
   */
  @Override
  public Platform platform() {
    return platform;
  }

  /**
   * @return The value of the {@code bitsize} attribute
   */
  @Override
  public BitSize bitsize() {
    return bitsize;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Distribution#version() version} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDistribution withVersion(Version value) {
    if (this.version == value) return this;
    Version newValue = Objects.requireNonNull(value, "version");
    return new ImmutableDistribution(this, newValue, this.platform, this.bitsize);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Distribution#platform() platform} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for platform
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDistribution withPlatform(Platform value) {
    if (this.platform == value) return this;
    Platform newValue = Objects.requireNonNull(value, "platform");
    if (this.platform.equals(newValue)) return this;
    return new ImmutableDistribution(this, this.version, newValue, this.bitsize);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Distribution#bitsize() bitsize} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bitsize
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDistribution withBitsize(BitSize value) {
    if (this.bitsize == value) return this;
    BitSize newValue = Objects.requireNonNull(value, "bitsize");
    if (this.bitsize.equals(newValue)) return this;
    return new ImmutableDistribution(this, this.version, this.platform, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDistribution} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDistribution
        && equalTo((ImmutableDistribution) another);
  }

  private boolean equalTo(ImmutableDistribution another) {
    return version.equals(another.version)
        && platform.equals(another.platform)
        && bitsize.equals(another.bitsize);
  }

  /**
   * Computes a hash code from attributes: {@code version}, {@code platform}, {@code bitsize}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + version.hashCode();
    h += (h << 5) + platform.hashCode();
    h += (h << 5) + bitsize.hashCode();
    return h;
  }

  /**
   * Construct a new immutable {@code Distribution} instance.
   * @param version The value for the {@code version} attribute
   * @param platform The value for the {@code platform} attribute
   * @param bitsize The value for the {@code bitsize} attribute
   * @return An immutable Distribution instance
   */
  public static ImmutableDistribution of(Version version, Platform platform, BitSize bitsize) {
    return new ImmutableDistribution(version, platform, bitsize);
  }

  /**
   * Creates an immutable copy of a {@link Distribution} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Distribution instance
   */
  public static ImmutableDistribution copyOf(Distribution instance) {
    if (instance instanceof ImmutableDistribution) {
      return (ImmutableDistribution) instance;
    }
    return ImmutableDistribution.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDistribution ImmutableDistribution}.
   * <pre>
   * ImmutableDistribution.builder()
   *    .version(de.flapdoodle.embed.process.distribution.Version) // required {@link Distribution#version() version}
   *    .platform(de.flapdoodle.embed.process.distribution.Platform) // required {@link Distribution#platform() platform}
   *    .bitsize(de.flapdoodle.embed.process.distribution.BitSize) // required {@link Distribution#bitsize() bitsize}
   *    .build();
   * </pre>
   * @return A new ImmutableDistribution builder
   */
  public static ImmutableDistribution.Builder builder() {
    return new ImmutableDistribution.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDistribution ImmutableDistribution}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Distribution", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_VERSION = 0x1L;
    private static final long INIT_BIT_PLATFORM = 0x2L;
    private static final long INIT_BIT_BITSIZE = 0x4L;
    private long initBits = 0x7L;

    private Version version;
    private Platform platform;
    private BitSize bitsize;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Distribution} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Distribution instance) {
      Objects.requireNonNull(instance, "instance");
      version(instance.version());
      platform(instance.platform());
      bitsize(instance.bitsize());
      return this;
    }

    /**
     * Initializes the value for the {@link Distribution#version() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder version(Version version) {
      this.version = Objects.requireNonNull(version, "version");
      initBits &= ~INIT_BIT_VERSION;
      return this;
    }

    /**
     * Initializes the value for the {@link Distribution#platform() platform} attribute.
     * @param platform The value for platform 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder platform(Platform platform) {
      this.platform = Objects.requireNonNull(platform, "platform");
      initBits &= ~INIT_BIT_PLATFORM;
      return this;
    }

    /**
     * Initializes the value for the {@link Distribution#bitsize() bitsize} attribute.
     * @param bitsize The value for bitsize 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder bitsize(BitSize bitsize) {
      this.bitsize = Objects.requireNonNull(bitsize, "bitsize");
      initBits &= ~INIT_BIT_BITSIZE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDistribution ImmutableDistribution}.
     * @return An immutable instance of Distribution
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDistribution build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDistribution(null, version, platform, bitsize);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
      if ((initBits & INIT_BIT_PLATFORM) != 0) attributes.add("platform");
      if ((initBits & INIT_BIT_BITSIZE) != 0) attributes.add("bitsize");
      return "Cannot build Distribution, some of required attributes are not set " + attributes;
    }
  }
}
