package de.flapdoodle.embed.process.config.store;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FileSet}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new FileSet.Builder()}.
 */
@Generated(from = "FileSet", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableFileSet implements FileSet {
  private final List<FileSet.Entry> entries;

  private ImmutableFileSet(List<FileSet.Entry> entries) {
    this.entries = entries;
  }

  /**
   * @return The value of the {@code entries} attribute
   */
  @Override
  public List<FileSet.Entry> entries() {
    return entries;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FileSet#entries() entries}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFileSet withEntries(FileSet.Entry... elements) {
    List<FileSet.Entry> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableFileSet(newValue));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FileSet#entries() entries}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of entries elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFileSet withEntries(Iterable<? extends FileSet.Entry> elements) {
    if (this.entries == elements) return this;
    List<FileSet.Entry> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableFileSet(newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFileSet} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFileSet
        && equalTo((ImmutableFileSet) another);
  }

  private boolean equalTo(ImmutableFileSet another) {
    return entries.equals(another.entries);
  }

  /**
   * Computes a hash code from attributes: {@code entries}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + entries.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FileSet} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "FileSet{"
        + "entries=" + entries
        + "}";
  }

  private static ImmutableFileSet validate(ImmutableFileSet instance) {
    instance.shouldContainOneMoreExecutable();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link FileSet} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FileSet instance
   */
  public static ImmutableFileSet copyOf(FileSet instance) {
    if (instance instanceof ImmutableFileSet) {
      return (ImmutableFileSet) instance;
    }
    return new FileSet.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableFileSet ImmutableFileSet}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FileSet", generator = "Immutables")
  public static class Builder {
    private List<FileSet.Entry> entries = new ArrayList<FileSet.Entry>();

    /**
     * Creates a builder for {@link ImmutableFileSet ImmutableFileSet} instances.
     * <pre>
     * new FileSet.Builder()
     *    .addEntries|addAllEntries(de.flapdoodle.embed.process.config.store.FileSet.Entry) // {@link FileSet#entries() entries} elements
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof FileSet.Builder)) {
        throw new UnsupportedOperationException("Use: new FileSet.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code FileSet} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final FileSet.Builder from(FileSet instance) {
      Objects.requireNonNull(instance, "instance");
      addAllEntries(instance.entries());
      return (FileSet.Builder) this;
    }

    /**
     * Adds one element to {@link FileSet#entries() entries} list.
     * @param element A entries element
     * @return {@code this} builder for use in a chained invocation
     */
    public final FileSet.Builder addEntries(FileSet.Entry element) {
      this.entries.add(Objects.requireNonNull(element, "entries element"));
      return (FileSet.Builder) this;
    }

    /**
     * Adds elements to {@link FileSet#entries() entries} list.
     * @param elements An array of entries elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final FileSet.Builder addEntries(FileSet.Entry... elements) {
      for (FileSet.Entry element : elements) {
        this.entries.add(Objects.requireNonNull(element, "entries element"));
      }
      return (FileSet.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link FileSet#entries() entries} list.
     * @param elements An iterable of entries elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final FileSet.Builder entries(Iterable<? extends FileSet.Entry> elements) {
      this.entries.clear();
      return addAllEntries(elements);
    }

    /**
     * Adds elements to {@link FileSet#entries() entries} list.
     * @param elements An iterable of entries elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final FileSet.Builder addAllEntries(Iterable<? extends FileSet.Entry> elements) {
      for (FileSet.Entry element : elements) {
        this.entries.add(Objects.requireNonNull(element, "entries element"));
      }
      return (FileSet.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableFileSet ImmutableFileSet}.
     * @return An immutable instance of FileSet
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFileSet build() {
      return ImmutableFileSet.validate(new ImmutableFileSet(createUnmodifiableList(true, entries)));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
