/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.store;

import de.flapdoodle.embed.process.builder.AbstractBuilder;
import de.flapdoodle.embed.process.builder.IProperty;
import de.flapdoodle.embed.process.builder.TypedProperty;
import de.flapdoodle.embed.process.config.store.IDownloadConfig;
import de.flapdoodle.embed.process.config.store.ILibraryStore;
import de.flapdoodle.embed.process.extract.ITempNaming;
import de.flapdoodle.embed.process.io.directories.IDirectory;
import de.flapdoodle.embed.process.store.ArtifactStore;
import de.flapdoodle.embed.process.store.CachingArtifactStore;
import de.flapdoodle.embed.process.store.IArtifactStore;
import de.flapdoodle.embed.process.store.IDownloader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactStoreBuilder
extends AbstractBuilder<IArtifactStore> {
    private static Logger logger = LoggerFactory.getLogger(ArtifactStoreBuilder.class);
    private static final TypedProperty<ITempNaming> EXECUTABLE_NAMING = TypedProperty.with("ExecutableNaming", ITempNaming.class);
    private static final TypedProperty<IDirectory> TEMP_DIR_FACTORY = TypedProperty.with("TempDir", IDirectory.class);
    private static final TypedProperty<IDownloadConfig> DOWNLOAD_CONFIG = TypedProperty.with("DownloadConfig", IDownloadConfig.class);
    private static final TypedProperty<Boolean> USE_CACHE = TypedProperty.with("UseCache", Boolean.class);
    private static final TypedProperty<ILibraryStore> LIBRARIES = TypedProperty.with("Libraries", ILibraryStore.class);
    private static final TypedProperty<IDownloader> DOWNLOADER = TypedProperty.with("Downloader", IDownloader.class);

    public ArtifactStoreBuilder download(AbstractBuilder<IDownloadConfig> downloadConfigBuilder) {
        return this.download(downloadConfigBuilder.build());
    }

    public ArtifactStoreBuilder download(IDownloadConfig downloadConfig) {
        this.set(DOWNLOAD_CONFIG, downloadConfig);
        return this;
    }

    protected IProperty<IDownloadConfig> download() {
        return this.property(DOWNLOAD_CONFIG);
    }

    public ArtifactStoreBuilder tempDir(IDirectory tempDirFactory) {
        this.set(TEMP_DIR_FACTORY, tempDirFactory);
        return this;
    }

    protected IProperty<IDirectory> tempDir() {
        return this.property(TEMP_DIR_FACTORY);
    }

    public ArtifactStoreBuilder executableNaming(ITempNaming execNaming) {
        this.set(EXECUTABLE_NAMING, execNaming);
        return this;
    }

    protected IProperty<ITempNaming> executableNaming() {
        return this.property(EXECUTABLE_NAMING);
    }

    public ArtifactStoreBuilder useCache(boolean cache) {
        this.set(USE_CACHE, cache);
        return this;
    }

    protected IProperty<Boolean> useCache() {
        return this.property(USE_CACHE);
    }

    @Deprecated
    public ArtifactStoreBuilder cache(boolean cache) {
        return this.useCache(cache);
    }

    public ArtifactStoreBuilder libraries(ILibraryStore libraries) {
        this.set(LIBRARIES, libraries);
        return this;
    }

    protected IProperty<ILibraryStore> libraries() {
        return this.property(LIBRARIES);
    }

    public ArtifactStoreBuilder downloader(IDownloader downloader) {
        this.set(DOWNLOADER, downloader);
        return this;
    }

    protected IProperty<IDownloader> downloader() {
        return this.property(DOWNLOADER);
    }

    @Override
    public IArtifactStore build() {
        boolean useCache = this.get(USE_CACHE, true);
        logger.debug("Build ArtifactStore(useCache: {})", (Object)useCache);
        IArtifactStore artifactStore = new ArtifactStore(this.get(DOWNLOAD_CONFIG), this.get(TEMP_DIR_FACTORY), this.get(EXECUTABLE_NAMING), this.get(DOWNLOADER));
        if (useCache) {
            artifactStore = new CachingArtifactStore(artifactStore);
        }
        return artifactStore;
    }
}

