/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.extract;

import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.extract.ExecutableFileAlreadyExistsException;
import de.flapdoodle.embed.process.extract.IArchiveEntry;
import de.flapdoodle.embed.process.extract.IExtractionMatch;
import de.flapdoodle.embed.process.extract.ITempNaming;
import de.flapdoodle.embed.process.io.directories.IDirectory;
import de.flapdoodle.embed.process.io.file.FileAlreadyExistsException;
import de.flapdoodle.embed.process.io.file.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class FilesToExtract {
    private final ArrayList<FileSet.Entry> _files;
    private final ITempNaming _exeutableNaming;
    private final File _dirFactoryResult;
    private final boolean _dirFactoryResultIsGenerated;

    public FilesToExtract(IDirectory dirFactory, ITempNaming exeutableNaming, FileSet fileSet) {
        if (dirFactory == null) {
            throw new NullPointerException("dirFactory is NULL");
        }
        if (exeutableNaming == null) {
            throw new NullPointerException("exeutableNaming is NULL");
        }
        if (fileSet == null) {
            throw new NullPointerException("fileSet is NULL");
        }
        this._files = new ArrayList<FileSet.Entry>(fileSet.entries());
        this._dirFactoryResult = dirFactory.asFile();
        this._dirFactoryResultIsGenerated = dirFactory.isGenerated();
        this._exeutableNaming = exeutableNaming;
    }

    public File generatedBaseDir() {
        return this._dirFactoryResultIsGenerated ? this._dirFactoryResult : null;
    }

    public boolean nothingLeft() {
        return this._files.isEmpty();
    }

    public IExtractionMatch find(IArchiveEntry entry) {
        FileSet.Entry found = null;
        if (!entry.isDirectory()) {
            for (FileSet.Entry e : this._files) {
                if (!e.matchingPattern().matcher(entry.getName()).matches()) continue;
                found = e;
                break;
            }
            if (found != null) {
                this._files.remove(found);
            }
        }
        return found != null ? new Match(this._dirFactoryResult, this._exeutableNaming, found) : null;
    }

    static class Match
    implements IExtractionMatch {
        private final FileSet.Entry _entry;
        private final File _dirFactoryResult;
        private final ITempNaming _exeutableNaming;

        public Match(File dirFactoryResult, ITempNaming exeutableNaming, FileSet.Entry entry) {
            this._dirFactoryResult = dirFactoryResult;
            this._exeutableNaming = exeutableNaming;
            this._entry = entry;
        }

        @Override
        public FileType type() {
            return this._entry.type();
        }

        @Override
        public File write(InputStream source, long size) throws IOException {
            File destination;
            switch (this._entry.type()) {
                case Executable: {
                    try {
                        destination = Files.createTempFile(this._dirFactoryResult, this._exeutableNaming.nameFor("extract", this._entry.destination()));
                        break;
                    }
                    catch (FileAlreadyExistsException ex) {
                        throw new ExecutableFileAlreadyExistsException(ex);
                    }
                }
                default: {
                    destination = Files.createTempFile(this._dirFactoryResult, this._entry.destination());
                }
            }
            Files.write(source, size, destination);
            switch (this._entry.type()) {
                case Executable: {
                    destination.setExecutable(true);
                }
            }
            return destination;
        }
    }
}

