/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.runtime;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import de.flapdoodle.embed.process.collections.Collections;
import de.flapdoodle.embed.process.config.ISupportConfig;
import de.flapdoodle.embed.process.config.process.ProcessConfig;
import de.flapdoodle.embed.process.distribution.Platform;
import de.flapdoodle.embed.process.io.IStreamProcessor;
import de.flapdoodle.embed.process.io.LogWatchStreamProcessor;
import de.flapdoodle.embed.process.io.Processors;
import de.flapdoodle.embed.process.io.StreamToLineProcessor;
import de.flapdoodle.embed.process.runtime.ProcessControl;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Processes {
    private static Logger logger = Logger.getLogger(ProcessControl.class.getName());

    private Processes() {
    }

    public static Integer processId(Process process) {
        Integer pid = Processes.unixLikeProcessId(process);
        if (pid == null) {
            pid = Processes.windowsProcessId(process);
        }
        return pid;
    }

    static Integer unixLikeProcessId(Process process) {
        Class<?> clazz = process.getClass();
        try {
            if (clazz.getName().equals("java.lang.UNIXProcess")) {
                Field pidField = clazz.getDeclaredField("pid");
                pidField.setAccessible(true);
                Object value = pidField.get(process);
                if (value instanceof Integer) {
                    logger.fine("Detected pid: " + value);
                    return (Integer)value;
                }
            }
        }
        catch (SecurityException sx) {
            sx.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    static Integer windowsProcessId(Process process) {
        if (process.getClass().getName().equals("java.lang.Win32Process") || process.getClass().getName().equals("java.lang.ProcessImpl")) {
            try {
                Field f = process.getClass().getDeclaredField("handle");
                f.setAccessible(true);
                long handl = f.getLong(process);
                Kernel32 kernel = Kernel32.INSTANCE;
                WinNT.HANDLE handle = new WinNT.HANDLE();
                handle.setPointer(Pointer.createConstant((long)handl));
                int ret = kernel.GetProcessId(handle);
                logger.fine("Detected pid: " + ret);
                return ret;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static boolean killProcess(ISupportConfig support, Platform platform, IStreamProcessor output, int pid) {
        if (platform.isUnixLike()) {
            return ProcessControl.executeCommandLine(support, "[kill process]", new ProcessConfig(Collections.newArrayList("kill", "-2", "" + pid), output));
        }
        return false;
    }

    public static boolean termProcess(ISupportConfig support, Platform platform, IStreamProcessor output, int pid) {
        if (platform.isUnixLike()) {
            return ProcessControl.executeCommandLine(support, "[term process]", new ProcessConfig(Collections.newArrayList("kill", "" + pid), output));
        }
        return false;
    }

    public static boolean tryKillProcess(ISupportConfig support, Platform platform, IStreamProcessor output, int pid) {
        if (platform == Platform.Windows) {
            return ProcessControl.executeCommandLine(support, "[taskkill process]", new ProcessConfig(Collections.newArrayList("taskkill", "/F", "/pid", "" + pid), output));
        }
        return false;
    }

    public static boolean isProcessRunning(Platform platform, int pid) {
        try {
            if (platform.isUnixLike()) {
                Process pidof = Runtime.getRuntime().exec(new String[]{"kill", "-0", "" + pid});
                return pidof.waitFor() == 0;
            }
            String[] cmd = new String[]{"tasklist.exe", "/FI", "PID eq " + pid, "/FO", "CSV"};
            logger.finer("Command: " + Arrays.asList(cmd));
            ProcessBuilder processBuilder = ProcessControl.newProcessBuilder(Arrays.asList(cmd), true);
            Process process = processBuilder.start();
            LogWatchStreamProcessor logWatch = new LogWatchStreamProcessor("" + pid, new HashSet<String>(), StreamToLineProcessor.wrap(Processors.silent()));
            Processors.connect(new InputStreamReader(process.getInputStream()), logWatch);
            logWatch.waitForResult(2000L);
            logger.finer("logWatch output: " + logWatch.getOutput());
            return logWatch.isInitWithSuccess();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Trying to get process status", e);
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, "Trying to get process status", e);
            e.printStackTrace();
        }
        return false;
    }
}

