/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.runtime;

import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.exceptions.DistributionException;
import de.flapdoodle.embed.process.runtime.Executable;
import de.flapdoodle.embed.process.runtime.IStopable;
import de.flapdoodle.embed.process.store.IArtifactStore;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Starter<CONFIG extends IExecutableProcessConfig, EXECUTABLE extends Executable<CONFIG, PROCESS>, PROCESS extends IStopable> {
    private static Logger logger = Logger.getLogger(Starter.class.getName());
    private final IRuntimeConfig runtime;

    protected Starter(IRuntimeConfig config) {
        this.runtime = config;
    }

    public EXECUTABLE prepare(CONFIG config) {
        Distribution distribution = Distribution.detectFor(config.version());
        try {
            IArtifactStore artifactStore = this.runtime.getArtifactStore();
            if (artifactStore.checkDistribution(distribution)) {
                File exe = this.runtime.getArtifactStore().extractExe(distribution);
                return this.newExecutable(config, distribution, this.runtime, exe);
            }
            throw new DistributionException("could not find Distribution", distribution);
        }
        catch (IOException iox) {
            logger.log(Level.SEVERE, "start", iox);
            throw new DistributionException(distribution, (Throwable)iox);
        }
    }

    protected abstract EXECUTABLE newExecutable(CONFIG var1, Distribution var2, IRuntimeConfig var3, File var4);
}

