/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.runtime;

import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.config.ISupportConfig;
import de.flapdoodle.embed.process.config.io.ProcessOutput;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.io.Processors;
import de.flapdoodle.embed.process.io.StreamToLineProcessor;
import de.flapdoodle.embed.process.runtime.Executable;
import de.flapdoodle.embed.process.runtime.IStopable;
import de.flapdoodle.embed.process.runtime.ProcessControl;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

public abstract class AbstractProcess<T extends IExecutableProcessConfig, E extends Executable<T, P>, P extends IStopable>
implements IStopable {
    private static Logger logger = Logger.getLogger(AbstractProcess.class.getName());
    public static final int TIMEOUT = 20000;
    private final T config;
    private final IRuntimeConfig runtimeConfig;
    private final E executable;
    private ProcessControl process;
    private int processId;
    private boolean stopped = false;
    private Distribution distribution;

    public AbstractProcess(Distribution distribution, T config, IRuntimeConfig runtimeConfig, E executable) throws IOException {
        this.config = config;
        this.runtimeConfig = runtimeConfig;
        this.executable = executable;
        this.distribution = distribution;
        ProcessOutput outputConfig = runtimeConfig.getProcessOutput();
        try {
            this.onBeforeProcess(runtimeConfig);
            ProcessBuilder processBuilder = ProcessControl.newProcessBuilder(runtimeConfig.getCommandLinePostProcessor().process(distribution, this.getCommandLine(distribution, config, ((Executable)this.executable).getFile())), true);
            this.onBeforeProcessStart(processBuilder, config, runtimeConfig);
            this.process = ProcessControl.start(this.supportConfig(), processBuilder);
            ProcessControl.addShutdownHook(new JobKiller());
            this.onAfterProcessStart(this.process, runtimeConfig);
        }
        catch (IOException iox) {
            this.stop();
            throw iox;
        }
    }

    public T getConfig() {
        return this.config;
    }

    protected void onBeforeProcess(IRuntimeConfig runtimeConfig) throws IOException {
    }

    protected void onBeforeProcessStart(ProcessBuilder processBuilder, T config2, IRuntimeConfig runtimeConfig) {
    }

    protected void onAfterProcessStart(ProcessControl process, IRuntimeConfig runtimeConfig) throws IOException {
        ProcessOutput outputConfig = runtimeConfig.getProcessOutput();
        Processors.connect(process.getReader(), outputConfig.getOutput());
        Processors.connect(process.getError(), StreamToLineProcessor.wrap(outputConfig.getError()));
    }

    protected abstract List<String> getCommandLine(Distribution var1, T var2, File var3) throws IOException;

    protected abstract ISupportConfig supportConfig();

    @Override
    public abstract void stop();

    protected final void stopProcess() {
        if (this.process != null) {
            this.process.stop();
        }
    }

    public int waitFor() throws InterruptedException {
        return this.process.waitFor();
    }

    protected void setProcessId(int processId) {
        this.processId = processId;
    }

    protected boolean sendKillToProcess() {
        if (this.processId > 0) {
            return ProcessControl.killProcess(this.supportConfig(), this.distribution.getPlatform(), StreamToLineProcessor.wrap(this.runtimeConfig.getProcessOutput().getCommands()), this.processId);
        }
        return false;
    }

    protected boolean tryKillToProcess() {
        if (this.processId > 0) {
            return ProcessControl.tryKillProcess(this.supportConfig(), this.distribution.getPlatform(), StreamToLineProcessor.wrap(this.runtimeConfig.getProcessOutput().getCommands()), this.processId);
        }
        return false;
    }

    class JobKiller
    implements Runnable {
        JobKiller() {
        }

        @Override
        public void run() {
            AbstractProcess.this.stop();
        }
    }
}

