/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.io;

import de.flapdoodle.embed.process.io.IStreamProcessor;
import java.util.Set;
import java.util.logging.Logger;

public class LogWatchStreamProcessor
implements IStreamProcessor {
    private static Logger logger = Logger.getLogger(LogWatchStreamProcessor.class.getName());
    private final StringBuilder output = new StringBuilder();
    private final String success;
    private final Set<String> failures;
    private boolean initWithSuccess = false;
    private final IStreamProcessor destination;

    public LogWatchStreamProcessor(String success, Set<String> failures, IStreamProcessor destination) {
        this.success = success;
        this.failures = failures;
        this.destination = destination;
    }

    @Override
    public void process(String block) {
        this.destination.process(block);
        String line = block;
        this.output.append((CharSequence)line);
        if (this.output.indexOf(this.success) != -1) {
            this.initWithSuccess = true;
            this.gotResult();
        }
        for (String failure : this.failures) {
            if (this.output.indexOf(failure) == -1) continue;
            this.initWithSuccess = false;
            this.gotResult();
        }
    }

    @Override
    public void onProcessed() {
        this.gotResult();
    }

    private synchronized void gotResult() {
        this.notify();
    }

    public synchronized void waitForResult(long timeout) {
        try {
            this.wait(timeout);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean isInitWithSuccess() {
        return this.initWithSuccess;
    }

    public String getOutput() {
        return this.output.toString();
    }
}

