/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.config.io;

import de.flapdoodle.embed.process.io.IStreamProcessor;
import de.flapdoodle.embed.process.io.Processors;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProcessOutput {
    protected final IStreamProcessor output;
    protected final IStreamProcessor error;
    protected final IStreamProcessor commands;

    public ProcessOutput(IStreamProcessor output, IStreamProcessor error, IStreamProcessor commands) {
        this.output = output;
        this.error = error;
        this.commands = commands;
    }

    public IStreamProcessor getOutput() {
        return this.output;
    }

    public IStreamProcessor getError() {
        return this.error;
    }

    public IStreamProcessor getCommands() {
        return this.commands;
    }

    public static ProcessOutput getDefaultInstance(String label) {
        return new ProcessOutput(Processors.namedConsole("[" + label + " output]"), Processors.namedConsole("[" + label + " error]"), Processors.console());
    }

    public static ProcessOutput getInstance(String label, Logger logger) {
        return new ProcessOutput(Processors.named("[" + label + " output]", Processors.logTo(logger, Level.INFO)), Processors.named("[" + label + " error]", Processors.logTo(logger, Level.SEVERE)), Processors.logTo(logger, Level.FINE));
    }
}

