/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.nodejs;

import de.flapdoodle.embed.process.config.store.IPackageResolver;
import de.flapdoodle.embed.process.distribution.ArchiveType;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.distribution.IVersion;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class NodejsPaths
implements IPackageResolver {
    private static Logger logger = Logger.getLogger(NodejsPaths.class.getName());

    public Pattern executeablePattern(Distribution distribution) {
        return Pattern.compile(".*" + this.executableFilename(distribution));
    }

    public String executableFilename(Distribution distribution) {
        String mongodPattern;
        switch (distribution.getPlatform()) {
            case Linux: {
                mongodPattern = "node";
                break;
            }
            case Windows: {
                mongodPattern = "node.exe";
                break;
            }
            case OS_X: {
                mongodPattern = "node";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Platform " + distribution.getPlatform());
            }
        }
        return mongodPattern;
    }

    public ArchiveType getArchiveType(Distribution distribution) {
        ArchiveType archiveType;
        switch (distribution.getPlatform()) {
            case Linux: {
                archiveType = ArchiveType.TGZ;
                break;
            }
            case Windows: {
                archiveType = ArchiveType.EXE;
                break;
            }
            case OS_X: {
                archiveType = ArchiveType.TGZ;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Platform " + distribution.getPlatform());
            }
        }
        return archiveType;
    }

    public String getPath(Distribution distribution) {
        String sbitSize;
        String splatform;
        String sarchiveType;
        String sversion = NodejsPaths.getVersionPart(distribution.getVersion());
        ArchiveType archiveType = this.getArchiveType(distribution);
        String subdir = "";
        switch (archiveType) {
            case TGZ: {
                sarchiveType = "tar.gz";
                break;
            }
            case ZIP: {
                sarchiveType = "zip";
                break;
            }
            case EXE: {
                sarchiveType = "exe";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ArchiveType " + archiveType);
            }
        }
        switch (distribution.getPlatform()) {
            case Linux: {
                splatform = "-" + sversion + "-linux";
                break;
            }
            case Windows: {
                splatform = "";
                break;
            }
            case OS_X: {
                splatform = "-" + sversion + "-darwin";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Platform " + distribution.getPlatform());
            }
        }
        block10 : switch (distribution.getBitsize()) {
            case B32: {
                switch (distribution.getPlatform()) {
                    case Linux: {
                        sbitSize = "-x86";
                        break block10;
                    }
                    case Windows: {
                        sbitSize = "";
                        break block10;
                    }
                    case OS_X: {
                        sbitSize = "-x86";
                        break block10;
                    }
                }
                throw new IllegalArgumentException("Unknown Platform " + distribution.getPlatform());
            }
            case B64: {
                switch (distribution.getPlatform()) {
                    case Linux: {
                        sbitSize = "-x64";
                        break block10;
                    }
                    case Windows: {
                        sbitSize = "";
                        subdir = "x64/";
                        break block10;
                    }
                    case OS_X: {
                        sbitSize = "-x64";
                        break block10;
                    }
                }
                throw new IllegalArgumentException("Unknown Platform " + distribution.getPlatform());
            }
            default: {
                throw new IllegalArgumentException("Unknown BitSize " + distribution.getBitsize());
            }
        }
        return sversion + "/" + subdir + "node" + splatform + sbitSize + "." + sarchiveType;
    }

    protected static String getVersionPart(IVersion version) {
        return version.asInDownloadPath();
    }
}

