/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.nodejs;

import com.google.common.collect.Lists;
import de.flapdoodle.embed.nodejs.NodejsConfig;
import de.flapdoodle.embed.nodejs.NodejsExecutable;
import de.flapdoodle.embed.nodejs.NodejsSupportConfig;
import de.flapdoodle.embed.process.config.ExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.config.ISupportConfig;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.runtime.AbstractProcess;
import de.flapdoodle.embed.process.runtime.Executable;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class NodejsProcess
extends AbstractProcess<NodejsConfig, NodejsExecutable, NodejsProcess> {
    public NodejsProcess(Distribution distribution, NodejsConfig config, IRuntimeConfig runtime, NodejsExecutable nodejsExecutable) throws IOException {
        super(distribution, (ExecutableProcessConfig)config, runtime, (Executable)nodejsExecutable);
    }

    protected void onBeforeProcessStart(ProcessBuilder processBuilder, NodejsConfig config, IRuntimeConfig runtimeConfig) {
        super.onBeforeProcessStart(processBuilder, (ExecutableProcessConfig)config, runtimeConfig);
        processBuilder.directory(new File(config.getWorkingDirectory()));
    }

    protected List<String> getCommandLine(Distribution distribution, NodejsConfig config, File exe) throws IOException {
        return Lists.newArrayList((Object[])new String[]{exe.getAbsolutePath(), config.getFilename()});
    }

    protected ISupportConfig supportConfig() {
        return new NodejsSupportConfig();
    }

    public void stop() {
        this.stopProcess();
    }
}

