/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.spring.autoconfigure;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import de.flapdoodle.embed.mongo.commands.MongodArguments;
import de.flapdoodle.embed.mongo.commands.ServerAddress;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.packageresolver.Feature;
import de.flapdoodle.embed.mongo.spring.autoconfigure.AbstractServerFactory;
import de.flapdoodle.embed.mongo.spring.autoconfigure.MongodWrapper;
import de.flapdoodle.embed.mongo.transitions.Mongod;
import de.flapdoodle.embed.mongo.transitions.RunningMongodProcess;
import de.flapdoodle.embed.process.distribution.Version;
import de.flapdoodle.reverse.Listener;
import de.flapdoodle.reverse.StateID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;

public class SyncClientServerFactory
extends AbstractServerFactory {
    private static Logger logger = LoggerFactory.getLogger(SyncClientServerFactory.class);

    SyncClientServerFactory(MongoProperties properties) {
        super(properties);
        logger.info("sync server factory");
    }

    MongodWrapper createWrapper(IFeatureAwareVersion version, Mongod mongod, MongodArguments mongodArguments) {
        return new MongodWrapper(mongod.transitions((Version)version), this.addAuthUserToDB(this.properties), SyncClientServerFactory.initReplicaSet(version, mongodArguments));
    }

    private static MongoClient client(ServerAddress serverAddress) {
        return MongoClients.create((String)("mongodb://" + serverAddress));
    }

    private static MongoClient client(ServerAddress serverAddress, MongoCredential credential) {
        return MongoClients.create((MongoClientSettings)MongoClientSettings.builder().applyConnectionString(new ConnectionString("mongodb://" + serverAddress)).credential(credential).build());
    }

    private static Listener initReplicaSet(IFeatureAwareVersion version, MongodArguments mongodArguments) {
        Listener.TypedListener.Builder builder = Listener.typedBuilder();
        if (mongodArguments.replication().isPresent() && version.enabled(Feature.RS_INITIATE)) {
            builder.onStateReached(StateID.of(RunningMongodProcess.class), runningMongodProcess -> {
                try (MongoClient client = SyncClientServerFactory.client(runningMongodProcess.getServerAddress());){
                    client.getDatabase("admin").runCommand((Bson)Document.parse((String)"{replSetInitiate: {}}"));
                }
            });
        }
        return builder.build();
    }

    @Override
    protected Consumer<RunningMongodProcess> addAuthUserToDBCallback(String username, char[] password, String databaseName) {
        return runningMongodProcess -> {
            logger.info("enable " + username + " access for " + databaseName);
            String adminDatabaseName = "admin";
            try (MongoClient client = SyncClientServerFactory.client(runningMongodProcess.getServerAddress());){
                if (!SyncClientServerFactory.createUser(client.getDatabase(adminDatabaseName), username, password, "root")) {
                    throw new IllegalArgumentException("could not create " + username + " user in " + adminDatabaseName);
                }
            }
            client = SyncClientServerFactory.client(runningMongodProcess.getServerAddress(), MongoCredential.createCredential((String)username, (String)adminDatabaseName, (char[])password));
            var6_6 = null;
            try {
                if (!SyncClientServerFactory.createUser(client.getDatabase(databaseName), username, password, "readWrite")) {
                    throw new IllegalArgumentException("could not create " + username + " in " + databaseName);
                }
            }
            catch (Throwable throwable) {
                var6_6 = throwable;
                throw throwable;
            }
            finally {
                if (client != null) {
                    if (var6_6 != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            var6_6.addSuppressed(throwable);
                        }
                    } else {
                        client.close();
                    }
                }
            }
            client = SyncClientServerFactory.client(runningMongodProcess.getServerAddress(), MongoCredential.createCredential((String)username, (String)"test", (char[])password));
            var6_6 = null;
            try {
                client.getDatabase(databaseName).listCollectionNames().into(new ArrayList());
            }
            catch (Throwable throwable) {
                var6_6 = throwable;
                throw throwable;
            }
            finally {
                if (client != null) {
                    if (var6_6 != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            var6_6.addSuppressed(throwable);
                        }
                    } else {
                        client.close();
                    }
                }
            }
            logger.info("access for " + username + "@" + databaseName + " is enabled");
        };
    }

    @Override
    protected Consumer<RunningMongodProcess> sendShutdown(String username, char[] password, String databaseName) {
        return runningMongodProcess -> {
            logger.info("enable " + username + " access for " + databaseName + " - shutdown database");
            String adminDatabaseName = "admin";
            try (MongoClient client = SyncClientServerFactory.client(runningMongodProcess.getServerAddress(), MongoCredential.createCredential((String)username, (String)adminDatabaseName, (char[])password));){
                client.getDatabase(adminDatabaseName).runCommand((Bson)new Document().append("shutdown", (Object)1).append("force", (Object)true));
            }
            logger.info("access for " + username + "@" + databaseName + " is enabled - shutdown done");
            runningMongodProcess.shutDownCommandAlreadyExecuted();
        };
    }

    private static boolean createUser(MongoDatabase db, String username, char[] password, String ... roles) {
        Document result = db.runCommand((Bson)new Document().append("createUser", (Object)username).append("pwd", (Object)new String(password)).append("roles", Arrays.asList(roles)));
        return (Double)result.get((Object)"ok", Double.class) >= 1.0;
    }
}

