/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.spring.autoconfigure;

import de.flapdoodle.checks.Preconditions;
import de.flapdoodle.embed.mongo.transitions.RunningMongodProcess;
import de.flapdoodle.embed.process.io.progress.ProgressListener;
import de.flapdoodle.embed.process.io.progress.ProgressListeners;
import de.flapdoodle.reverse.Listener;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.TransitionWalker;
import de.flapdoodle.reverse.Transitions;
import java.util.Optional;

public class MongodWrapper {
    private final Transitions transitions;
    private final Optional<ProgressListener> progressListener;
    private final Listener stateChangeListener;
    private TransitionWalker.ReachedState<RunningMongodProcess> runningMongo = null;

    public MongodWrapper(Transitions transitions, ProgressListener progressListener, Listener stateChangeListener) {
        this.transitions = transitions;
        this.progressListener = Optional.of(progressListener);
        this.stateChangeListener = stateChangeListener;
    }

    private void start() {
        if (this.progressListener.isPresent()) {
            try (ProgressListeners.RemoveProgressListener ignored = ProgressListeners.setProgressListener((ProgressListener)this.progressListener.get());){
                this.runningMongo = this.transitions.walker().initState(StateID.of(RunningMongodProcess.class), new Listener[]{this.stateChangeListener});
            }
        } else {
            this.runningMongo = this.transitions.walker().initState(StateID.of(RunningMongodProcess.class), new Listener[]{this.stateChangeListener});
        }
    }

    private void stop() {
        Preconditions.checkNotNull(this.runningMongo, (String)"stop called, but runningMongo is null", (Object[])new Object[0]);
        this.runningMongo.close();
    }
}

