/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.spring.autoconfigure;

import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import de.flapdoodle.embed.mongo.commands.ImmutableMongodArguments;
import de.flapdoodle.embed.mongo.commands.MongodArguments;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.config.Storage;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.distribution.Versions;
import de.flapdoodle.embed.mongo.spring.autoconfigure.EmbeddedMongoProperties;
import de.flapdoodle.embed.mongo.spring.autoconfigure.MongodWrapper;
import de.flapdoodle.embed.mongo.transitions.ImmutableMongod;
import de.flapdoodle.embed.mongo.transitions.Mongod;
import de.flapdoodle.embed.mongo.transitions.RunningMongodProcess;
import de.flapdoodle.embed.process.distribution.Version;
import de.flapdoodle.embed.process.io.ProcessOutput;
import de.flapdoodle.embed.process.io.Processors;
import de.flapdoodle.embed.process.io.Slf4jLevel;
import de.flapdoodle.embed.process.io.StreamProcessor;
import de.flapdoodle.embed.process.io.progress.ProgressListener;
import de.flapdoodle.embed.process.io.progress.Slf4jProgressListener;
import de.flapdoodle.embed.process.runtime.Network;
import de.flapdoodle.reverse.Listener;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.Transition;
import de.flapdoodle.reverse.transitions.Start;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.mongo.MongoClientDependsOnBeanFactoryPostProcessor;
import org.springframework.boot.autoconfigure.data.mongo.ReactiveStreamsMongoClientDependsOnBeanFactoryPostProcessor;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.data.mongodb.core.MongoClientFactoryBean;
import org.springframework.data.mongodb.core.ReactiveMongoClientFactoryBean;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={MongoProperties.class, EmbeddedMongoProperties.class})
@AutoConfigureBefore(value={MongoAutoConfiguration.class, org.springframework.boot.autoconfigure.mongo.embedded.EmbeddedMongoAutoConfiguration.class})
@ConditionalOnClass(value={MongoClientSettings.class, Mongod.class})
@Import(value={EmbeddedMongoClientDependsOnBeanFactoryPostProcessor.class, EmbeddedReactiveStreamsMongoClientDependsOnBeanFactoryPostProcessor.class})
public class EmbeddedMongoAutoConfiguration {
    private static Logger logger = LoggerFactory.getLogger(EmbeddedMongoAutoConfiguration.class);
    private static final byte[] IP4_LOOPBACK_ADDRESS = new byte[]{127, 0, 0, 1};
    private static final byte[] IP6_LOOPBACK_ADDRESS = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
    private final MongoProperties properties;

    public EmbeddedMongoAutoConfiguration(MongoProperties properties) {
        this.properties = properties;
    }

    private InetAddress getHost() throws UnknownHostException {
        if (this.properties.getHost() == null) {
            return InetAddress.getByAddress(Network.localhostIsIPv6() ? IP6_LOOPBACK_ADDRESS : IP4_LOOPBACK_ADDRESS);
        }
        return InetAddress.getByName(this.properties.getHost());
    }

    @Bean(initMethod="start", destroyMethod="stop")
    @ConditionalOnMissingBean
    public MongodWrapper embeddedMongod(ApplicationContext context, EmbeddedMongoProperties embeddedProperties, ImmutableMongod immutableMongod, MongodArguments mongodArguments, ProcessOutput processOutput, ProgressListener progressListener) throws IOException {
        Net net;
        IFeatureAwareVersion version = EmbeddedMongoAutoConfiguration.determineVersion("de.flapdoodle", embeddedProperties.getVersion());
        Integer configuredPort = this.properties.getPort();
        Net net2 = net = configuredPort != null && configuredPort > 0 ? Net.of((String)this.getHost().getHostAddress(), (int)configuredPort, (boolean)Network.localhostIsIPv6()) : Net.of((String)this.getHost().getHostAddress(), (int)Network.freeServerPort((InetAddress)this.getHost()), (boolean)Network.localhostIsIPv6());
        if (configuredPort == null || configuredPort == 0) {
            EmbeddedMongoAutoConfiguration.setEmbeddedPort(context, net.getPort());
        }
        ImmutableMongod mongod = immutableMongod.withMongodArguments((Transition)Start.to(MongodArguments.class).initializedWith((Object)mongodArguments)).withNet((Transition)Start.to(Net.class).initializedWith((Object)net)).withProcessOutput((Transition)Start.to(ProcessOutput.class).initializedWith((Object)processOutput));
        return new MongodWrapper(mongod.transitions((Version)version), progressListener, EmbeddedMongoAutoConfiguration.addAuthUserToDB(this.properties));
    }

    private static Listener addAuthUserToDB(MongoProperties properties) {
        Listener.TypedListener.Builder typedBuilder = Listener.typedBuilder();
        String username = properties.getUsername();
        char[] password = properties.getPassword();
        String databaseName = properties.getMongoClientDatabase();
        if (username != null && password != null) {
            typedBuilder.onStateReached(StateID.of(RunningMongodProcess.class), EmbeddedMongoAutoConfiguration.addAuthUserToDBCallback(username, password, databaseName));
            typedBuilder.onStateTearDown(StateID.of(RunningMongodProcess.class), EmbeddedMongoAutoConfiguration.sendShutdown(username, password, databaseName));
        }
        return typedBuilder.build();
    }

    private static Consumer<RunningMongodProcess> addAuthUserToDBCallback(String username, char[] password, String databaseName) {
        return runningMongodProcess -> {
            try {
                logger.info("enable " + username + " access for " + databaseName);
                ServerAddress serverAddress = runningMongodProcess.getServerAddress();
                String adminDatabaseName = "admin";
                MongoClientOptions mongoClientOptions = MongoClientOptions.builder().build();
                try (com.mongodb.MongoClient client = new com.mongodb.MongoClient(serverAddress);){
                    if (!EmbeddedMongoAutoConfiguration.createUser(client.getDatabase(adminDatabaseName), username, password, "root")) {
                        throw new IllegalArgumentException("could not create " + username + " user in " + adminDatabaseName);
                    }
                }
                client = new com.mongodb.MongoClient(serverAddress, MongoCredential.createCredential((String)username, (String)adminDatabaseName, (char[])password), mongoClientOptions);
                var8_9 = null;
                try {
                    if (!EmbeddedMongoAutoConfiguration.createUser(client.getDatabase(databaseName), username, password, "readWrite")) {
                        throw new IllegalArgumentException("could not create " + username + " in " + databaseName);
                    }
                }
                catch (Throwable throwable) {
                    var8_9 = throwable;
                    throw throwable;
                }
                finally {
                    if (client != null) {
                        if (var8_9 != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable) {
                                var8_9.addSuppressed(throwable);
                            }
                        } else {
                            client.close();
                        }
                    }
                }
                client = new com.mongodb.MongoClient(serverAddress, MongoCredential.createCredential((String)username, (String)"test", (char[])password), mongoClientOptions);
                var8_9 = null;
                try {
                    client.getDatabase(databaseName).listCollectionNames().into(new ArrayList());
                }
                catch (Throwable throwable) {
                    var8_9 = throwable;
                    throw throwable;
                }
                finally {
                    if (client != null) {
                        if (var8_9 != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable) {
                                var8_9.addSuppressed(throwable);
                            }
                        } else {
                            client.close();
                        }
                    }
                }
                logger.info("access for " + username + "@" + databaseName + " is enabled");
            }
            catch (UnknownHostException ux) {
                throw new RuntimeException(ux);
            }
        };
    }

    private static Consumer<RunningMongodProcess> sendShutdown(String username, char[] password, String databaseName) {
        return runningMongodProcess -> {
            try {
                logger.info("enable " + username + " access for " + databaseName + " - shutdown database");
                ServerAddress serverAddress = runningMongodProcess.getServerAddress();
                String adminDatabaseName = "admin";
                MongoClientOptions mongoClientOptions = MongoClientOptions.builder().build();
                try (com.mongodb.MongoClient client = new com.mongodb.MongoClient(serverAddress, MongoCredential.createCredential((String)username, (String)adminDatabaseName, (char[])password), mongoClientOptions);){
                    client.getDatabase(adminDatabaseName).runCommand((Bson)new Document().append("shutdown", (Object)1));
                }
                logger.info("access for " + username + "@" + databaseName + " is enabled - shutdown done");
            }
            catch (UnknownHostException ux) {
                throw new RuntimeException(ux);
            }
        };
    }

    private static boolean createUser(MongoDatabase db, String username, char[] password, String ... roles) {
        Document result = db.runCommand((Bson)new Document().append("createUser", (Object)username).append("pwd", (Object)new String(password)).append("roles", Arrays.asList(roles)));
        return (Double)result.get((Object)"ok", Double.class) >= 1.0;
    }

    @Bean
    @ConditionalOnMissingBean
    public ImmutableMongod mongod() {
        return ImmutableMongod.instance();
    }

    @Bean
    @ConditionalOnMissingBean
    public ProgressListener progressListener() {
        return new Slf4jProgressListener(EmbeddedMongoAutoConfiguration.logger());
    }

    @Bean
    @ConditionalOnMissingBean
    public ProcessOutput processOutput() {
        Logger logger = EmbeddedMongoAutoConfiguration.logger();
        return ProcessOutput.builder().output(Processors.logTo((Logger)logger, (Slf4jLevel)Slf4jLevel.INFO)).error(Processors.logTo((Logger)logger, (Slf4jLevel)Slf4jLevel.ERROR)).commands(Processors.named((String)"[console>]", (StreamProcessor)Processors.logTo((Logger)logger, (Slf4jLevel)Slf4jLevel.DEBUG))).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public MongodArguments mongodArguments(EmbeddedMongoProperties embeddedProperties, MongoProperties mongoProperties) {
        ImmutableMongodArguments.Builder builder = MongodArguments.builder();
        EmbeddedMongoProperties.Storage storage = embeddedProperties.getStorage();
        if (storage != null && storage.getReplSetName() != null) {
            String replSetName = storage.getReplSetName();
            int oplogSize = storage.getOplogSize() != null ? (int)storage.getOplogSize().toMegabytes() : 0;
            builder.replication(Storage.of((String)replSetName, (int)oplogSize));
        }
        if (mongoProperties.getUsername() != null && mongoProperties.getPassword() != null) {
            builder.auth(true);
        }
        return builder.build();
    }

    private static Logger logger() {
        return LoggerFactory.getLogger((String)(EmbeddedMongoAutoConfiguration.class.getPackage().getName() + ".EmbeddedMongo"));
    }

    private static IFeatureAwareVersion determineVersion(String prefix, String version) {
        Assert.state((version != null ? 1 : 0) != 0, (String)("Set the " + prefix + ".mongodb.embedded.version property or define your own MongodConfig bean to use embedded MongoDB"));
        return Versions.withFeatures((Version)EmbeddedMongoAutoConfiguration.createEmbeddedMongoVersion(version));
    }

    private static Version.GenericVersion createEmbeddedMongoVersion(String version) {
        return Version.of((String)version);
    }

    private static void setEmbeddedPort(ApplicationContext context, int port) {
        EmbeddedMongoAutoConfiguration.setPortProperty(context, port);
    }

    private static void setPortProperty(ApplicationContext currentContext, int port) {
        if (currentContext instanceof ConfigurableApplicationContext) {
            MutablePropertySources sources = ((ConfigurableApplicationContext)currentContext).getEnvironment().getPropertySources();
            EmbeddedMongoAutoConfiguration.getMongoPorts(sources).put("local.mongo.port", port);
        }
        if (currentContext.getParent() != null) {
            EmbeddedMongoAutoConfiguration.setPortProperty(currentContext.getParent(), port);
        }
    }

    private static Map<String, Object> getMongoPorts(MutablePropertySources sources) {
        PropertySource propertySource = sources.get("mongo.ports");
        if (propertySource == null) {
            propertySource = new MapPropertySource("mongo.ports", new HashMap());
            sources.addFirst(propertySource);
        }
        return (Map)propertySource.getSource();
    }

    @ConditionalOnClass(value={com.mongodb.reactivestreams.client.MongoClient.class, ReactiveMongoClientFactoryBean.class})
    static class EmbeddedReactiveStreamsMongoClientDependsOnBeanFactoryPostProcessor
    extends ReactiveStreamsMongoClientDependsOnBeanFactoryPostProcessor {
        EmbeddedReactiveStreamsMongoClientDependsOnBeanFactoryPostProcessor() {
            super(new Class[]{MongodWrapper.class});
        }
    }

    @ConditionalOnClass(value={MongoClient.class, MongoClientFactoryBean.class})
    static class EmbeddedMongoClientDependsOnBeanFactoryPostProcessor
    extends MongoClientDependsOnBeanFactoryPostProcessor {
        EmbeddedMongoClientDependsOnBeanFactoryPostProcessor() {
            super(new Class[]{MongodWrapper.class});
        }
    }
}

