/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver;

import de.flapdoodle.embed.mongo.packageresolver.Command;
import de.flapdoodle.embed.mongo.packageresolver.DistributionMatch;
import de.flapdoodle.embed.mongo.packageresolver.HasPlatformMatchRules;
import de.flapdoodle.embed.mongo.packageresolver.ImmutablePackageFinderRule;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinderRule;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinderRules;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatch;
import de.flapdoodle.embed.mongo.packageresolver.UrlTemplatePackageResolver;
import de.flapdoodle.embed.mongo.packageresolver.VersionRange;
import de.flapdoodle.embed.process.config.store.DistributionPackage;
import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.distribution.ArchiveType;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.os.BitSize;
import de.flapdoodle.os.OS;
import java.util.Optional;

public class SolarisPackageFinder
implements PackageFinder,
HasPlatformMatchRules {
    private final Command command;
    private final PackageFinderRules rules;

    public SolarisPackageFinder(Command command) {
        this.command = command;
        this.rules = SolarisPackageFinder.rules(command);
    }

    @Override
    public PackageFinderRules rules() {
        return this.rules;
    }

    @Override
    public Optional<DistributionPackage> packageFor(Distribution distribution) {
        return this.rules.packageFor(distribution);
    }

    private static FileSet fileSetOf(Command command) {
        return FileSet.builder().addEntry(FileType.Executable, command.commandName()).build();
    }

    private static PlatformMatch match(BitSize bitSize) {
        return PlatformMatch.withOs(OS.Solaris).withBitSize(bitSize);
    }

    private static PackageFinderRules rules(Command command) {
        FileSet fileSet = SolarisPackageFinder.fileSetOf(command);
        ArchiveType archiveType = ArchiveType.TGZ;
        ImmutablePackageFinderRule firstRule = PackageFinderRule.builder().match(SolarisPackageFinder.match(BitSize.B64).andThen(DistributionMatch.any(VersionRange.of("3.4.0", "3.4.5"), VersionRange.of("3.2.0", "3.2.14"), VersionRange.of("3.0.0", "3.0.15"), VersionRange.of("2.6.0", "2.6.12")))).finder(UrlTemplatePackageResolver.builder().fileSet(fileSet).archiveType(archiveType).urlTemplate("/sunos5/mongodb-sunos5-x86_64-{version}.tgz").build()).build();
        ImmutablePackageFinderRule hiddenLegacyRule = PackageFinderRule.builder().match(SolarisPackageFinder.match(BitSize.B64).andThen(DistributionMatch.any(VersionRange.of("3.3.1", "3.3.1"), VersionRange.of("3.5.5", "3.5.5")))).finder(UrlTemplatePackageResolver.builder().fileSet(fileSet).archiveType(archiveType).urlTemplate("/sunos5/mongodb-sunos5-x86_64-{version}.tgz").build()).build();
        ImmutablePackageFinderRule failIfNothingMatches = PackageFinderRule.builder().match(PlatformMatch.withOs(OS.Solaris)).finder(PackageFinder.failWithMessage(distribution -> "solaris distribution not supported: " + distribution)).build();
        return PackageFinderRules.empty().withRules(firstRule, hiddenLegacyRule, failIfNothingMatches);
    }
}

