/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver;

import de.flapdoodle.embed.mongo.packageresolver.DistributionMatch;
import de.flapdoodle.embed.mongo.packageresolver.ImmutablePlatformMatch;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.os.BitSize;
import de.flapdoodle.os.CPUType;
import de.flapdoodle.os.OS;
import de.flapdoodle.os.Version;
import java.util.Optional;
import java.util.Set;
import org.immutables.value.Value;

@Value.Immutable
public interface PlatformMatch
extends DistributionMatch {
    public Set<Version> version();

    public Optional<CPUType> cpuType();

    public Optional<BitSize> bitSize();

    public Optional<OS> os();

    public static ImmutablePlatformMatch.Builder builder() {
        return ImmutablePlatformMatch.builder();
    }

    public static ImmutablePlatformMatch any() {
        return PlatformMatch.builder().build();
    }

    public static ImmutablePlatformMatch withOs(OS os) {
        return PlatformMatch.any().withOs(os);
    }

    @Override
    @Value.Auxiliary
    default public boolean match(Distribution distribution) {
        return PlatformMatch.match(this, distribution);
    }

    public static boolean match(PlatformMatch match, Distribution distribution) {
        if (PlatformMatch.dontMatch(match.os(), distribution.platform().operatingSystem())) {
            return false;
        }
        if (PlatformMatch.dontMatch(match.cpuType(), distribution.platform().architecture().cpuType())) {
            return false;
        }
        if (PlatformMatch.dontMatch(match.bitSize(), distribution.platform().architecture().bitSize())) {
            return false;
        }
        return !PlatformMatch.dontMatch(match.version(), distribution.platform().version());
    }

    public static <T> boolean dontMatch(Optional<T> match, T value) {
        return match.isPresent() && !match.get().equals(value);
    }

    public static <T extends Enum<T>> boolean dontMatch(Optional<T> match, T value) {
        return match.isPresent() && match.get() != value;
    }

    public static <T> boolean dontMatch(Optional<T> match, Optional<T> value) {
        return match.isPresent() && value.isPresent() && !match.get().equals(value.get());
    }

    public static <T> boolean dontMatch(Set<T> match, Optional<T> value) {
        return !match.isEmpty() && (!value.isPresent() || !match.contains(value.get()));
    }
}

