/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver;

import de.flapdoodle.embed.mongo.packageresolver.ImmutableNumericVersion;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public interface NumericVersion
extends Comparable<NumericVersion> {
    @Value.Parameter
    public int major();

    @Value.Parameter
    public int minor();

    @Value.Parameter
    public int patch();

    public Optional<String> build();

    @Override
    @Value.Auxiliary
    default public int compareTo(NumericVersion other) {
        int mc = Integer.compare(this.major(), other.major());
        int mm = Integer.compare(this.minor(), other.minor());
        int mp = Integer.compare(this.patch(), other.patch());
        int build = this.build().orElse("").compareTo(other.build().orElse(""));
        return mc != 0 ? mc : (mm != 0 ? mm : (mp != 0 ? mp : build));
    }

    public static NumericVersion of(int major, int minor, int patch) {
        return ImmutableNumericVersion.of(major, minor, patch);
    }

    public static NumericVersion of(String versionString) {
        int patch;
        int minor;
        int major;
        Optional<String> build = Optional.empty();
        if ("latest".equals(versionString)) {
            major = Integer.MAX_VALUE;
            minor = Integer.MAX_VALUE;
            patch = Integer.MAX_VALUE;
        } else {
            String[] semverParts = versionString.split("\\.", 3);
            major = Integer.parseInt(semverParts[0], 10);
            minor = Integer.parseInt(semverParts[1], 10);
            String semverPart3 = semverParts[2];
            int idxOfDash = semverPart3.indexOf(45);
            if (idxOfDash > 0) {
                build = Optional.of(semverPart3.substring(idxOfDash + 1));
                semverPart3 = semverPart3.substring(0, idxOfDash);
            }
            patch = Integer.parseInt(semverPart3, 10);
        }
        return ImmutableNumericVersion.of(major, minor, patch).withBuild(build);
    }

    default public boolean isNewerOrEqual(int major, int minor, int patch) {
        return this.isNewerOrEqual(NumericVersion.of(major, minor, patch));
    }

    default public boolean isOlderOrEqual(int major, int minor, int patch) {
        return this.isOlderOrEqual(NumericVersion.of(major, minor, patch));
    }

    default public boolean isNewerOrEqual(NumericVersion other) {
        return this.isNewer(other) || this.isEqual(other);
    }

    default public boolean isNewer(NumericVersion other) {
        return this.compareTo(other) > 0;
    }

    default public boolean isOlderOrEqual(NumericVersion other) {
        return this.isOlder(other) || this.isEqual(other);
    }

    default public boolean isOlder(NumericVersion other) {
        return this.compareTo(other) < 0;
    }

    default public boolean isEqual(NumericVersion other) {
        return this.compareTo(other) == 0;
    }

    default public boolean isNextOrPrevPatch(NumericVersion other) {
        if (this.major() != other.major()) {
            return false;
        }
        if (this.minor() != other.minor()) {
            return false;
        }
        return Math.abs(this.patch() - other.patch()) == 1;
    }

    default public String asString() {
        if (this.build().isPresent()) {
            return this.major() + "." + this.minor() + "." + this.patch() + "-" + this.build().get();
        }
        return this.major() + "." + this.minor() + "." + this.patch();
    }
}

