package de.flapdoodle.os.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OneOf}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableOneOf.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableOneOf.of()}.
 */
@Generated(from = "OneOf", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutableOneOf extends OneOf {
  private final List<DistinctPeculiarity<?>> pecularities;

  private ImmutableOneOf(Iterable<? extends DistinctPeculiarity<?>> pecularities) {
    this.pecularities = createUnmodifiableList(false, createSafeList(pecularities, true, false));
  }

  private ImmutableOneOf(
      ImmutableOneOf original,
      List<DistinctPeculiarity<?>> pecularities) {
    this.pecularities = pecularities;
  }

  /**
   * @return The value of the {@code pecularities} attribute
   */
  @Override
  public List<DistinctPeculiarity<?>> pecularities() {
    return pecularities;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link OneOf#pecularities() pecularities}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableOneOf withPecularities(DistinctPeculiarity<?>... elements) {
    List<DistinctPeculiarity<?>> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableOneOf(this, newValue));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link OneOf#pecularities() pecularities}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of pecularities elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOneOf withPecularities(Iterable<? extends DistinctPeculiarity<?>> elements) {
    if (this.pecularities == elements) return this;
    List<DistinctPeculiarity<?>> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableOneOf(this, newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOneOf} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOneOf
        && equalTo(0, (ImmutableOneOf) another);
  }

  private boolean equalTo(int synthetic, ImmutableOneOf another) {
    return pecularities.equals(another.pecularities);
  }

  /**
   * Computes a hash code from attributes: {@code pecularities}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + pecularities.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OneOf} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OneOf{"
        + "pecularities=" + pecularities
        + "}";
  }

  /**
   * Construct a new immutable {@code OneOf} instance.
   * @param pecularities The value for the {@code pecularities} attribute
   * @return An immutable OneOf instance
   */
  public static ImmutableOneOf of(List<DistinctPeculiarity<?>> pecularities) {
    return of((Iterable<? extends DistinctPeculiarity<?>>) pecularities);
  }

  /**
   * Construct a new immutable {@code OneOf} instance.
   * @param pecularities The value for the {@code pecularities} attribute
   * @return An immutable OneOf instance
   */
  public static ImmutableOneOf of(Iterable<? extends DistinctPeculiarity<?>> pecularities) {
    return validate(new ImmutableOneOf(pecularities));
  }

  private static ImmutableOneOf validate(ImmutableOneOf instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link OneOf} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OneOf instance
   */
  public static ImmutableOneOf copyOf(OneOf instance) {
    if (instance instanceof ImmutableOneOf) {
      return (ImmutableOneOf) instance;
    }
    return ImmutableOneOf.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableOneOf ImmutableOneOf}.
   * <pre>
   * ImmutableOneOf.builder()
   *    .addPecularities|addAllPecularities(de.flapdoodle.os.common.DistinctPeculiarity&amp;lt;?&amp;gt;) // {@link OneOf#pecularities() pecularities} elements
   *    .build();
   * </pre>
   * @return A new ImmutableOneOf builder
   */
  public static ImmutableOneOf.Builder builder() {
    return new ImmutableOneOf.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableOneOf ImmutableOneOf}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OneOf", generator = "Immutables")
  public static final class Builder {
    private List<DistinctPeculiarity<?>> pecularities = new ArrayList<DistinctPeculiarity<?>>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OneOf} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OneOf instance) {
      Objects.requireNonNull(instance, "instance");
      addAllPecularities(instance.pecularities());
      return this;
    }

    /**
     * Adds one element to {@link OneOf#pecularities() pecularities} list.
     * @param element A pecularities element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addPecularities(DistinctPeculiarity<?> element) {
      this.pecularities.add(Objects.requireNonNull(element, "pecularities element"));
      return this;
    }

    /**
     * Adds elements to {@link OneOf#pecularities() pecularities} list.
     * @param elements An array of pecularities elements
     * @return {@code this} builder for use in a chained invocation
     */
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder addPecularities(DistinctPeculiarity<?>... elements) {
      for (DistinctPeculiarity<?> element : elements) {
        this.pecularities.add(Objects.requireNonNull(element, "pecularities element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link OneOf#pecularities() pecularities} list.
     * @param elements An iterable of pecularities elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder pecularities(Iterable<? extends DistinctPeculiarity<?>> elements) {
      this.pecularities.clear();
      return addAllPecularities(elements);
    }

    /**
     * Adds elements to {@link OneOf#pecularities() pecularities} list.
     * @param elements An iterable of pecularities elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPecularities(Iterable<? extends DistinctPeculiarity<?>> elements) {
      for (DistinctPeculiarity<?> element : elements) {
        this.pecularities.add(Objects.requireNonNull(element, "pecularities element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableOneOf ImmutableOneOf}.
     * @return An immutable instance of OneOf
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOneOf build() {
      return ImmutableOneOf.validate(new ImmutableOneOf(null, createUnmodifiableList(true, pecularities)));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
