/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.os;

import de.flapdoodle.os.Architecture;
import de.flapdoodle.os.Distribution;
import de.flapdoodle.os.ImmutablePlatform;
import de.flapdoodle.os.OS;
import de.flapdoodle.os.Version;
import de.flapdoodle.os.common.HasPecularities;
import de.flapdoodle.os.common.PeculiarityInspector;
import de.flapdoodle.os.common.attributes.AttributeExtractorLookup;
import de.flapdoodle.os.common.attributes.LoggingWrapper;
import de.flapdoodle.os.common.matcher.MatcherLookup;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Value.Immutable
public interface Platform {
    public static final Logger logger = LoggerFactory.getLogger(Platform.class);

    public OS operatingSystem();

    public Architecture architecture();

    public Optional<Distribution> distribution();

    public Optional<Version> version();

    public static Platform detect() {
        boolean explain = "true".equals(System.getProperty("de.flapdoodle.os.explain"));
        AttributeExtractorLookup attributeExtractorLookup = AttributeExtractorLookup.systemDefault();
        MatcherLookup matcherLookup = MatcherLookup.systemDefault();
        if (explain) {
            attributeExtractorLookup = LoggingWrapper.wrap(attributeExtractorLookup);
            matcherLookup = LoggingWrapper.wrap(matcherLookup);
        }
        Platform result = Platform.detect(attributeExtractorLookup, matcherLookup);
        if (explain) {
            logger.info("Platform.detect() -> " + result);
        }
        return result;
    }

    public static Platform detect(AttributeExtractorLookup attributeExtractorLookup, MatcherLookup matcherLookup) {
        ImmutablePlatform.Builder builder = ImmutablePlatform.builder();
        OS os = Platform.detectOS(attributeExtractorLookup, matcherLookup);
        Architecture architecture = Platform.detectArchitecture(attributeExtractorLookup, matcherLookup, os.architectures());
        Optional<Distribution> dist = Platform.detectDistribution(attributeExtractorLookup, matcherLookup, os.distributions());
        Optional version = dist.flatMap(d -> Platform.detectVersion(attributeExtractorLookup, matcherLookup, d));
        return builder.operatingSystem(os).distribution(dist).version(version).architecture(architecture).build();
    }

    public static OS detectOS(AttributeExtractorLookup attributeExtractorLookup, MatcherLookup matcherLookup) {
        return (OS)PeculiarityInspector.match((AttributeExtractorLookup)attributeExtractorLookup, (MatcherLookup)matcherLookup, (HasPecularities[])OS.values());
    }

    public static Optional<Distribution> detectDistribution(AttributeExtractorLookup attributeExtractorLookup, MatcherLookup matcherLookup, Iterable<? extends Distribution> distributions) {
        return PeculiarityInspector.find(attributeExtractorLookup, matcherLookup, distributions);
    }

    public static Optional<Version> detectVersion(AttributeExtractorLookup attributeExtractorLookup, MatcherLookup matcherLookup, Distribution distribution) {
        return Platform.detectVersion(attributeExtractorLookup, matcherLookup, distribution.versions());
    }

    public static Optional<Version> detectVersion(AttributeExtractorLookup attributeExtractorLookup, MatcherLookup matcherLookup, List<? extends Version> versions) {
        return PeculiarityInspector.find(attributeExtractorLookup, matcherLookup, versions);
    }

    public static Architecture detectArchitecture(AttributeExtractorLookup attributeExtractorLookup, MatcherLookup matcherLookup, List<? extends Architecture> architectures) {
        return PeculiarityInspector.match(attributeExtractorLookup, matcherLookup, architectures);
    }
}

