package de.flapdoodle.os.common;

import de.flapdoodle.os.common.attributes.Attribute;
import de.flapdoodle.os.common.matcher.Match;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Peculiarity}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePeculiarity.builder()}.
 */
@Generated(from = "Peculiarity", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutablePeculiarity<T> implements Peculiarity<T> {
  private final Attribute<T> attribute;
  private final Match<T> match;

  private ImmutablePeculiarity(
      Attribute<T> attribute,
      Match<T> match) {
    this.attribute = attribute;
    this.match = match;
  }

  /**
   * @return The value of the {@code attribute} attribute
   */
  @Override
  public Attribute<T> attribute() {
    return attribute;
  }

  /**
   * @return The value of the {@code match} attribute
   */
  @Override
  public Match<T> match() {
    return match;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Peculiarity#attribute() attribute} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for attribute
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePeculiarity<T> withAttribute(Attribute<T> value) {
    if (this.attribute == value) return this;
    Attribute<T> newValue = Objects.requireNonNull(value, "attribute");
    return new ImmutablePeculiarity<>(newValue, this.match);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Peculiarity#match() match} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for match
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePeculiarity<T> withMatch(Match<T> value) {
    if (this.match == value) return this;
    Match<T> newValue = Objects.requireNonNull(value, "match");
    return new ImmutablePeculiarity<>(this.attribute, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePeculiarity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePeculiarity<?>
        && equalTo((ImmutablePeculiarity<?>) another);
  }

  private boolean equalTo(ImmutablePeculiarity<?> another) {
    return attribute.equals(another.attribute)
        && match.equals(another.match);
  }

  /**
   * Computes a hash code from attributes: {@code attribute}, {@code match}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + attribute.hashCode();
    h += (h << 5) + match.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Peculiarity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Peculiarity{"
        + "attribute=" + attribute
        + ", match=" + match
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Peculiarity} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable Peculiarity instance
   */
  public static <T> ImmutablePeculiarity<T> copyOf(Peculiarity<T> instance) {
    if (instance instanceof ImmutablePeculiarity<?>) {
      return (ImmutablePeculiarity<T>) instance;
    }
    return ImmutablePeculiarity.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePeculiarity ImmutablePeculiarity}.
   * <pre>
   * ImmutablePeculiarity.&amp;lt;T&amp;gt;builder()
   *    .attribute(de.flapdoodle.os.common.attributes.Attribute&amp;lt;T&amp;gt;) // required {@link Peculiarity#attribute() attribute}
   *    .match(de.flapdoodle.os.common.matcher.Match&amp;lt;T&amp;gt;) // required {@link Peculiarity#match() match}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutablePeculiarity builder
   */
  public static <T> ImmutablePeculiarity.Builder<T> builder() {
    return new ImmutablePeculiarity.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutablePeculiarity ImmutablePeculiarity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Peculiarity", generator = "Immutables")
  public static final class Builder<T> {
    private static final long INIT_BIT_ATTRIBUTE = 0x1L;
    private static final long INIT_BIT_MATCH = 0x2L;
    private long initBits = 0x3L;

    private Attribute<T> attribute;
    private Match<T> match;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Peculiarity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> from(Peculiarity<T> instance) {
      Objects.requireNonNull(instance, "instance");
      attribute(instance.attribute());
      match(instance.match());
      return this;
    }

    /**
     * Initializes the value for the {@link Peculiarity#attribute() attribute} attribute.
     * @param attribute The value for attribute 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> attribute(Attribute<T> attribute) {
      this.attribute = Objects.requireNonNull(attribute, "attribute");
      initBits &= ~INIT_BIT_ATTRIBUTE;
      return this;
    }

    /**
     * Initializes the value for the {@link Peculiarity#match() match} attribute.
     * @param match The value for match 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> match(Match<T> match) {
      this.match = Objects.requireNonNull(match, "match");
      initBits &= ~INIT_BIT_MATCH;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePeculiarity ImmutablePeculiarity}.
     * @return An immutable instance of Peculiarity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePeculiarity<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePeculiarity<>(attribute, match);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ATTRIBUTE) != 0) attributes.add("attribute");
      if ((initBits & INIT_BIT_MATCH) != 0) attributes.add("match");
      return "Cannot build Peculiarity, some of required attributes are not set " + attributes;
    }
  }
}
