package de.flapdoodle.formula.values.properties;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ReadOnlyProperty}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableReadOnlyProperty.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableReadOnlyProperty.of()}.
 */
@Generated(from = "ReadOnlyProperty", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableReadOnlyProperty<O, T>
    extends ReadOnlyProperty<O, T> {
  private final Class<O> type;
  private final String name;
  private final Function<O, T> getter;

  private ImmutableReadOnlyProperty(Class<O> type, String name, Function<O, T> getter) {
    this.type = Objects.requireNonNull(type, "type");
    this.name = Objects.requireNonNull(name, "name");
    this.getter = Objects.requireNonNull(getter, "getter");
  }

  private ImmutableReadOnlyProperty(
      ImmutableReadOnlyProperty<O, T> original,
      Class<O> type,
      String name,
      Function<O, T> getter) {
    this.type = type;
    this.name = name;
    this.getter = getter;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  protected Class<O> type() {
    return type;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  protected String name() {
    return name;
  }

  /**
   * @return The value of the {@code getter} attribute
   */
  @Override
  protected Function<O, T> getter() {
    return getter;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReadOnlyProperty#type() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReadOnlyProperty<O, T> withType(Class<O> value) {
    if (this.type == value) return this;
    Class<O> newValue = Objects.requireNonNull(value, "type");
    return new ImmutableReadOnlyProperty<>(this, newValue, this.name, this.getter);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReadOnlyProperty#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReadOnlyProperty<O, T> withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableReadOnlyProperty<>(this, this.type, newValue, this.getter);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReadOnlyProperty#getter() getter} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for getter
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReadOnlyProperty<O, T> withGetter(Function<O, T> value) {
    if (this.getter == value) return this;
    Function<O, T> newValue = Objects.requireNonNull(value, "getter");
    return new ImmutableReadOnlyProperty<>(this, this.type, this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableReadOnlyProperty} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableReadOnlyProperty<?, ?>
        && equalTo(0, (ImmutableReadOnlyProperty<?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableReadOnlyProperty<?, ?> another) {
    return type.equals(another.type)
        && name.equals(another.name)
        && getter.equals(another.getter);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code name}, {@code getter}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + type.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + getter.hashCode();
    return h;
  }

  /**
   * Construct a new immutable {@code ReadOnlyProperty} instance.
 * @param <O> generic parameter O
 * @param <T> generic parameter T
   * @param type The value for the {@code type} attribute
   * @param name The value for the {@code name} attribute
   * @param getter The value for the {@code getter} attribute
   * @return An immutable ReadOnlyProperty instance
   */
  public static <O, T> ImmutableReadOnlyProperty<O, T> of(Class<O> type, String name, Function<O, T> getter) {
    return new ImmutableReadOnlyProperty<>(type, name, getter);
  }

  /**
   * Creates an immutable copy of a {@link ReadOnlyProperty} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <O> generic parameter O
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable ReadOnlyProperty instance
   */
  public static <O, T> ImmutableReadOnlyProperty<O, T> copyOf(ReadOnlyProperty<O, T> instance) {
    if (instance instanceof ImmutableReadOnlyProperty<?, ?>) {
      return (ImmutableReadOnlyProperty<O, T>) instance;
    }
    return ImmutableReadOnlyProperty.<O, T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableReadOnlyProperty ImmutableReadOnlyProperty}.
   * <pre>
   * ImmutableReadOnlyProperty.&amp;lt;O, T&amp;gt;builder()
   *    .type(Class&amp;lt;O&amp;gt;) // required {@link ReadOnlyProperty#type() type}
   *    .name(String) // required {@link ReadOnlyProperty#name() name}
   *    .getter(function.Function&amp;lt;O, T&amp;gt;) // required {@link ReadOnlyProperty#getter() getter}
   *    .build();
   * </pre>
   * @param <O> generic parameter O
   * @param <T> generic parameter T
   * @return A new ImmutableReadOnlyProperty builder
   */
  public static <O, T> ImmutableReadOnlyProperty.Builder<O, T> builder() {
    return new ImmutableReadOnlyProperty.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableReadOnlyProperty ImmutableReadOnlyProperty}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ReadOnlyProperty", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<O, T> {
    private static final long INIT_BIT_TYPE = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_GETTER = 0x4L;
    private long initBits = 0x7L;

    private @Nullable Class<O> type;
    private @Nullable String name;
    private @Nullable Function<O, T> getter;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ReadOnlyProperty} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<O, T> from(ReadOnlyProperty<O, T> instance) {
      Objects.requireNonNull(instance, "instance");
      type(instance.type());
      name(instance.name());
      getter(instance.getter());
      return this;
    }

    /**
     * Initializes the value for the {@link ReadOnlyProperty#type() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<O, T> type(Class<O> type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link ReadOnlyProperty#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<O, T> name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link ReadOnlyProperty#getter() getter} attribute.
     * @param getter The value for getter 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<O, T> getter(Function<O, T> getter) {
      this.getter = Objects.requireNonNull(getter, "getter");
      initBits &= ~INIT_BIT_GETTER;
      return this;
    }

    /**
     * Builds a new {@link ImmutableReadOnlyProperty ImmutableReadOnlyProperty}.
     * @return An immutable instance of ReadOnlyProperty
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableReadOnlyProperty<O, T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableReadOnlyProperty<>(null, type, name, getter);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_GETTER) != 0) attributes.add("getter");
      return "Cannot build ReadOnlyProperty, some of required attributes are not set " + attributes;
    }
  }
}
