package de.flapdoodle.formula.values.properties;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ModifiableProperty}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableModifiableProperty.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableModifiableProperty.of()}.
 */
@Generated(from = "ModifiableProperty", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableModifiableProperty<O, T>
    extends ModifiableProperty<O, T> {
  private final Class<O> type;
  private final String name;
  private final Function<O, T> getter;
  private final BiConsumer<O, T> setter;

  private ImmutableModifiableProperty(
      Class<O> type,
      String name,
      Function<O, T> getter,
      BiConsumer<O, T> setter) {
    this.type = Objects.requireNonNull(type, "type");
    this.name = Objects.requireNonNull(name, "name");
    this.getter = Objects.requireNonNull(getter, "getter");
    this.setter = Objects.requireNonNull(setter, "setter");
  }

  private ImmutableModifiableProperty(
      ImmutableModifiableProperty<O, T> original,
      Class<O> type,
      String name,
      Function<O, T> getter,
      BiConsumer<O, T> setter) {
    this.type = type;
    this.name = name;
    this.getter = getter;
    this.setter = setter;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  protected Class<O> type() {
    return type;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  protected String name() {
    return name;
  }

  /**
   * @return The value of the {@code getter} attribute
   */
  @Override
  protected Function<O, T> getter() {
    return getter;
  }

  /**
   * @return The value of the {@code setter} attribute
   */
  @Override
  protected BiConsumer<O, T> setter() {
    return setter;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ModifiableProperty#type() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableModifiableProperty<O, T> withType(Class<O> value) {
    if (this.type == value) return this;
    Class<O> newValue = Objects.requireNonNull(value, "type");
    return new ImmutableModifiableProperty<>(this, newValue, this.name, this.getter, this.setter);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ModifiableProperty#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableModifiableProperty<O, T> withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableModifiableProperty<>(this, this.type, newValue, this.getter, this.setter);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ModifiableProperty#getter() getter} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for getter
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableModifiableProperty<O, T> withGetter(Function<O, T> value) {
    if (this.getter == value) return this;
    Function<O, T> newValue = Objects.requireNonNull(value, "getter");
    return new ImmutableModifiableProperty<>(this, this.type, this.name, newValue, this.setter);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ModifiableProperty#setter() setter} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for setter
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableModifiableProperty<O, T> withSetter(BiConsumer<O, T> value) {
    if (this.setter == value) return this;
    BiConsumer<O, T> newValue = Objects.requireNonNull(value, "setter");
    return new ImmutableModifiableProperty<>(this, this.type, this.name, this.getter, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableModifiableProperty} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableModifiableProperty<?, ?>
        && equalTo(0, (ImmutableModifiableProperty<?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableModifiableProperty<?, ?> another) {
    return type.equals(another.type)
        && name.equals(another.name)
        && getter.equals(another.getter)
        && setter.equals(another.setter);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code name}, {@code getter}, {@code setter}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + type.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + getter.hashCode();
    h += (h << 5) + setter.hashCode();
    return h;
  }

  /**
   * Construct a new immutable {@code ModifiableProperty} instance.
 * @param <O> generic parameter O
 * @param <T> generic parameter T
   * @param type The value for the {@code type} attribute
   * @param name The value for the {@code name} attribute
   * @param getter The value for the {@code getter} attribute
   * @param setter The value for the {@code setter} attribute
   * @return An immutable ModifiableProperty instance
   */
  public static <O, T> ImmutableModifiableProperty<O, T> of(Class<O> type, String name, Function<O, T> getter, BiConsumer<O, T> setter) {
    return new ImmutableModifiableProperty<>(type, name, getter, setter);
  }

  /**
   * Creates an immutable copy of a {@link ModifiableProperty} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <O> generic parameter O
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable ModifiableProperty instance
   */
  public static <O, T> ImmutableModifiableProperty<O, T> copyOf(ModifiableProperty<O, T> instance) {
    if (instance instanceof ImmutableModifiableProperty<?, ?>) {
      return (ImmutableModifiableProperty<O, T>) instance;
    }
    return ImmutableModifiableProperty.<O, T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableModifiableProperty ImmutableModifiableProperty}.
   * <pre>
   * ImmutableModifiableProperty.&amp;lt;O, T&amp;gt;builder()
   *    .type(Class&amp;lt;O&amp;gt;) // required {@link ModifiableProperty#type() type}
   *    .name(String) // required {@link ModifiableProperty#name() name}
   *    .getter(function.Function&amp;lt;O, T&amp;gt;) // required {@link ModifiableProperty#getter() getter}
   *    .setter(function.BiConsumer&amp;lt;O, T&amp;gt;) // required {@link ModifiableProperty#setter() setter}
   *    .build();
   * </pre>
   * @param <O> generic parameter O
   * @param <T> generic parameter T
   * @return A new ImmutableModifiableProperty builder
   */
  public static <O, T> ImmutableModifiableProperty.Builder<O, T> builder() {
    return new ImmutableModifiableProperty.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableModifiableProperty ImmutableModifiableProperty}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ModifiableProperty", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<O, T> {
    private static final long INIT_BIT_TYPE = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_GETTER = 0x4L;
    private static final long INIT_BIT_SETTER = 0x8L;
    private long initBits = 0xfL;

    private @Nullable Class<O> type;
    private @Nullable String name;
    private @Nullable Function<O, T> getter;
    private @Nullable BiConsumer<O, T> setter;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableProperty} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<O, T> from(ModifiableProperty<O, T> instance) {
      Objects.requireNonNull(instance, "instance");
      type(instance.type());
      name(instance.name());
      getter(instance.getter());
      setter(instance.setter());
      return this;
    }

    /**
     * Initializes the value for the {@link ModifiableProperty#type() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<O, T> type(Class<O> type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link ModifiableProperty#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<O, T> name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link ModifiableProperty#getter() getter} attribute.
     * @param getter The value for getter 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<O, T> getter(Function<O, T> getter) {
      this.getter = Objects.requireNonNull(getter, "getter");
      initBits &= ~INIT_BIT_GETTER;
      return this;
    }

    /**
     * Initializes the value for the {@link ModifiableProperty#setter() setter} attribute.
     * @param setter The value for setter 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<O, T> setter(BiConsumer<O, T> setter) {
      this.setter = Objects.requireNonNull(setter, "setter");
      initBits &= ~INIT_BIT_SETTER;
      return this;
    }

    /**
     * Builds a new {@link ImmutableModifiableProperty ImmutableModifiableProperty}.
     * @return An immutable instance of ModifiableProperty
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableModifiableProperty<O, T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableModifiableProperty<>(null, type, name, getter, setter);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_GETTER) != 0) attributes.add("getter");
      if ((initBits & INIT_BIT_SETTER) != 0) attributes.add("setter");
      return "Cannot build ModifiableProperty, some of required attributes are not set " + attributes;
    }
  }
}
